/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 225669 $
 * \date $Date:: 2021-03-03 15:13:38 +0300#$
 * \author $Author: borodin $
 * \brief       .
 */

#if !defined( READER_RIC_RIC_INT_H )
#define READER_RIC_RIC_INT_H

#if !defined( _RESOURCE )
/*   . */
extern TSupResourceInstance RIC_RESOURCE;
#else
#define RIC_RESOURCE RIC_DLL_INSTANCE
extern HINSTANCE RIC_DLL_INSTANCE;
#endif /* !defined( _RESOURCE ) */

#define RIC_UNIQUE_LENGTH 12
#define OSCAR_UNIQUE_LENGTH 14
#define TRUST_UNIQUE_LENGTH 17
#define MAX_UNIQUE_LENGTH 17

#define RIC_STATUS_START 0
#define RIC_STATUS_PIN_VERIFIED 1
#define RIC_STATUS_FILE_SELECTED 2

#define UNI_LEN 4
#define PIN_LENGTH 8

#define RIC_APPLICATION 0x0b00

#define RIC_BLOCK_READ 64
#define RIC_BLOCK_WRITE 64
#define OSCAR_BLOCK_READ 118
#define OSCAR_BLOCK_WRITE 32
#define TRUST_BLOCK_READ 118
#define TRUST_BLOCK_WRITE 32

#define RIC_PATH_CFG _TEXT( "\\config\\KeyCarriers\\RIC\\" )
#define OSCAR_PATH_CFG _TEXT( "\\config\\KeyCarriers\\Oscar\\" )
#define OSCAR2_PATH_CFG _TEXT( "\\config\\KeyCarriers\\Oscar2\\" )

#define BASE_FILE_CFG _TEXT( "\\size_" )
#define RIC_ATR _TEXT( "\\ATR" )
#define RIC_MASK _TEXT( "\\Mask" )
#define RIC_FOLDERS _TEXT( "\\Folders" )
#define DEFAULT_CONNECT _TEXT( "Default" )
#define KCHANNEL_CONNECT _TEXT( "KChannel" )

#define PF_FILES 1
#define PF_APPLICATION 4

typedef enum _CardType {
    CardType_RIC,
    CardType_OSCAR,
    CardType_OSCAR2,
    CardType_Magistra
} CardType;

/*      . */
extern const unsigned char OSCAR2_FILE_INDEX[6];
/*       . */
extern const unsigned char *OSCAR2_FILE_NUMBERS[2];

typedef DWORD (*UniqueFormFun)( unsigned char unique_num[4], 
    TCHAR *unique );

struct TRICContext_;
typedef struct TRICContext_ TRICContext;

typedef DWORD (*Change_pin)( TRICContext *ctx, 
    unsigned char new_pin[PIN_LENGTH] );

struct TRICContext_ 
{
    BOOL folder_exist;
    TSCardAPDUCmd apdu;
    TSCardSimpleAPDUCmd apdu_full;
    TSCardBerTLVSearch ber_tlv_search;
    TSCardSimpleTLVSearch simple_tlv_search;
    TSupSysEContext *reader;
    unsigned char unique[UNI_LEN];
    unsigned char file;
    unsigned short application;
    unsigned status;
    size_t file_length;
    /*    OSCAR / RIC */
    size_t unique_length;
    UniqueFormFun unique_form;
    Change_pin change_pin;
    size_t block_len_read;
    size_t block_len_write;
    unsigned char class_tag;
    CardType card_type;
    int retries;
    const TCHAR * connect_name;
};

/*  . */
DWORD ric_unregister(
    TSupSysContext *context, TSupSysInfo *info );

/*   . */
DWORD ric_context_free(
    TSupSysContext *context, TSupSysInfo *info );

/*   . */
DWORD ric_context_dup(
    TSupSysContext *context, TSupSysInfo *info );

/*    . */
DWORD ric_connect_carrier(
    TSupSysContext *context, TSupSysInfo *info );


DWORD ric_get_password_type(TSupSysContext *context, TSupSysInfo *info);
DWORD ric_get_auth_info(TSupSysContext *context, TSupSysInfo *info);
DWORD ric_get_param(TSupSysContext *context, TSupSysInfo *info);

DWORD ric_unique_get(
    TSupSysContext *context, TSupSysInfo *info );

DWORD ric_login(
    TSupSysContext *context, TSupSysInfo *info );

DWORD ric_logout(
    TSupSysContext *context, TSupSysInfo *info );

DWORD ric_file_open(
    TSupSysContext *context, TSupSysInfo *info );

DWORD ric_file_close(
    TSupSysContext *context, TSupSysInfo *info );

DWORD ric_file_chsize(
    TSupSysContext *context, TSupSysInfo *info );

DWORD ric_file_read(
    TSupSysContext *context, TSupSysInfo *info );

DWORD ric_file_write(
    TSupSysContext *context, TSupSysInfo *info );

/*   . */
DWORD ric_info_instance(
    TSupSysContext *context, TSupSysInfo *info );

/*  */
DWORD ric_info_nickname(TSupSysContext *context, TSupSysInfo *info);
DWORD ric_info_name(TSupSysContext *context, TSupSysInfo *info);
DWORD oscar_info_name(TSupSysContext *context, TSupSysInfo *info);
DWORD oscar2_info_name(TSupSysContext *context, TSupSysInfo *info);
DWORD trust_info_name(TSupSysContext *context, TSupSysInfo *info);
DWORD trusts_info_name(TSupSysContext *context, TSupSysInfo *info);
DWORD trustd_info_name(TSupSysContext *context, TSupSysInfo *info);

DWORD oscar_info_nickname(
    TSupSysContext *context, TSupSysInfo *info);

DWORD oscar2_info_nickname(
    TSupSysContext *context, TSupSysInfo *info);

DWORD trustd_info_nickname(
    TSupSysContext *context, TSupSysInfo *info);

DWORD trusts_info_nickname(
    TSupSysContext *context, TSupSysInfo *info);

DWORD trust_info_nickname(
    TSupSysContext *context, TSupSysInfo *info);

DWORD ric_passwd_change(
    TSupSysContext *context, TSupSysInfo *info );

DWORD ric_unique_num( TRICContext *reader, 
    unsigned char unique_num[UNI_LEN] );

DWORD ric_verify_pin( TRICContext *ctx, const char * pin, int *retries );

DWORD ric_select_file( TRICContext *ctx, 
    unsigned char file, size_t *length );

DWORD ric_file_size( TSupSysContext *context, TSupSysInfo *info );

DWORD ric_folder_open( TSupSysContext *context, TSupSysInfo *info );
DWORD send_apdu (TRICContext * ctx, const BYTE * apdu, const BYTE * in, size_t in_len, BYTE * out, size_t * out_len);
DWORD select_app (TRICContext * ctx);

/* ----------------- base ----------------- */

DWORD base_property_init( 
    TSupSysContext *context, TSupSysInfo *info, unsigned files,
    const TCHAR *BASE_PATH_CFG, const TCHAR *NAME );

DWORD base_property_done( 
    TSupSysContext *context, TSupSysInfo *info );

DWORD base_wizard_init( 
    TSupSysContext *context, TSupSysInfo *info, unsigned files,
    const TCHAR *def_atr, const TCHAR *def_mask, const TCHAR *def_folder,
    const TCHAR *BASE_PATH_CFG, const TCHAR *NAME );

DWORD base_wizard_done( 
    TSupSysContext *context, TSupSysInfo *info );

DWORD base_wizard_attach(
    TSupSysContext *context, TSupSysInfo *info );

/* -----------------  ----------------- */
DWORD ric_unique_form( unsigned char unique_num[4],
    TCHAR *unique );

/*  . */
DWORD ric_register(
    TSupSysContext *context, TSupSysInfo *info );

DWORD ric_change_pin( TRICContext *ctx, 
    unsigned char new_pin[PIN_LENGTH] );

/* -----------------  ----------------- */
DWORD oscar_unique_form( unsigned char unique_num[4],
    TCHAR *unique );

/*  . */
DWORD oscar_register(
    TSupSysContext *context, TSupSysInfo *info );

DWORD oscar2_register(
    TSupSysContext *context,
    TSupSysInfo *info);

DWORD oscar_change_pin( TRICContext *ctx, 
    unsigned char new_pin[PIN_LENGTH] );

DWORD oscar_info_ids( 
    TSupSysContext *context, TSupSysInfo *info );

DWORD trust_reset(
    TSupSysContext *context, TSupSysInfo *info);

/* -----------------  c 2-  ----------------- */
DWORD oscar2_file_offset(
	unsigned char file_id, size_t *offset, const TCHAR *connect);

DWORD oscar2_info_ids(
    TSupSysContext *context, TSupSysInfo *info );

DWORD oscar2_file_length( 
    unsigned char file_id, size_t *length, const TCHAR *connect );


/* -----------------  ----------------- */

#define DeclSupSysFunction(f) \
    DWORD f( TSupSysContext *context, \
		TSupSysInfo *info )

DeclSupSysFunction(trust_register);
DeclSupSysFunction(trust_connect_carrier);
DeclSupSysFunction(trust_preconnect_carrier);
DeclSupSysFunction(trust_unique_get);
DeclSupSysFunction(trust_folder_enum_open);
DeclSupSysFunction(trust_folder_enum_next);
DeclSupSysFunction(trust_folder_enum_close);
DeclSupSysFunction(trust_folder_open);
DeclSupSysFunction(trust_login);
DeclSupSysFunction(trust_logout);
DeclSupSysFunction(trust_file_open);

DWORD trust_unique_form(unsigned char unique_num[UNI_LEN], TCHAR *unique);

DWORD trust_select_application( 
    TRICContext *ctx );

DWORD trust_change_pin(
    TRICContext *ctx, 
    unsigned char pin[PIN_LENGTH] );

DWORD trust_select_file( 
    TRICContext *ctx,
    unsigned char file_id, 
    size_t *length );

DWORD trust_unique_num( 
    TRICContext *ctx, 
    unsigned char unique_num[UNI_LEN] );

DWORD trust_verify_pin(
    TRICContext *ctx, 
    unsigned char pin[PIN_LENGTH],
    int *retries );


#endif /* !defined( READER_RIC_RIC_INT_H ) */
/* end of file: $Id: ric_int.h 225669 2021-03-03 12:13:38Z borodin $ */
