/*
 * Copyright(C) 2008  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 225669 $
 * \date $Date:: 2021-03-03 15:13:38 +0300#$
 * \author $Author: borodin $
 * \brief        
 *        ( Trust).
 */

#if !defined(ATRUST_FUNS) || !defined(ATRUST_TABLE) || \
    !defined(Atrust_media_get_table) || \
    !defined(Atrust_property_init) || \
    !defined(Atrust_wizard_init) || \
    !defined(Atrust_info_ids)
#   error "    "
#endif
#if !defined(ATRUST_PATH_CFG)
#   error "    "
#endif
#if !defined(ATRUST_ATR)
#   error "  ATR"
#endif
#if !defined(ATRUST_MASK)
#   error "   ATR"
#endif
#if !defined(ATRUST_FILE_NAMES)
#   error "   "
#endif
#if !defined(ATRUST_IDS_ITEMS) || \
    !defined(ATRUST_IDS) || \
    !defined(AIDS_TRUST_NAME)
#   error "   "
#endif

#if defined( _WIN32 )
static DWORD Atrust_property_init(TSupSysContext *context, 
				   TSupSysInfo *info );
static DWORD Atrust_wizard_init(
				 TSupSysContext *context, 
				 TSupSysInfo *info );

#endif
static DWORD Atrust_info_ids(
    TSupSysContext *context, 
    TSupSysInfo *info );

/*!
 * \ingroup trust_internal
 * \brief      
 * \sa #TSupSysFunctionTable, #TSupSysFunctionTableItem
 */
static const TSupSysFunctionTableItem ATRUST_FUNS[] =
{
    { SUPSYS_FUN_NICKNAME, Atrust_nickname},
    { SUPSYS_FUN_NAME, Atrust_name },
    { SUPSYS_FUN_INSTANCE, ric_info_instance },
    { SUPSYS_FUN_CONTEXT_DUP, ric_context_dup },
    { SUPSYS_FUN_CONTEXT_FREE, ric_context_free },
    { SUPSYS_FUN_IDS_BLOCK, Atrust_info_ids },
    { SUPSYS_FUN_VERSIONSUPPORT, info_versionsupport},
#if defined _WIN32
    { SUPSYSW_FUN_PROPERTY_INIT, Atrust_property_init },
    { SUPSYSW_FUN_PROPERTY_DONE, base_property_done },
    { SUPSYSW_FUN_WIZARD_INIT, Atrust_wizard_init },
    { SUPSYSW_FUN_WIZARD_ATTACH, base_wizard_attach },
    { SUPSYSW_FUN_WIZARD_DONE, base_wizard_done },
#endif

    { SUPSYS_FUN_REGISTER, trust_register },
    { SUPSYS_FUN_UNREGISTER, ric_unregister },

    { READER_FUN_GET_PARAM, ric_get_param },
    { READER_FUN_AUTH_INFO, ric_get_auth_info },
    { READER_FUN_PASSWORD_TYPE, ric_get_password_type },

    { RSCARD_FUN_CONNECT_CARRIER, trust_connect_carrier },

    { READER_FUN_UNIQUE_GET, trust_unique_get },   

    { READER_FUN_FOLDER_ENUM_OPEN, trust_folder_enum_open },
    { READER_FUN_FOLDER_ENUM_NEXT, trust_folder_enum_next },
    { READER_FUN_FOLDER_ENUM_CLOSE, trust_folder_enum_close },
    { READER_FUN_FOLDER_OPEN, trust_folder_open },

    { READER_FUN_LOGOUT, trust_logout },
    { READER_FUN_RESTORE_DEFAULT_ROOT, trust_reset},
    { READER_FUN_SIMPLE_LOGIN_ASCII, ric_login },

    { READER_FUN_OPEN, trust_file_open },
    { READER_FUN_CLOSE, ric_file_close },
    { READER_FUN_PASSWD_CHANGE_ASCII, ric_passwd_change },

    { READER_FUN_READ, ric_file_read },
    { READER_FUN_WRITE, ric_file_write },
    { READER_FUN_CHSIZE, ric_file_chsize },
    { READER_FUN_LENGTH, ric_file_size }
};

/*!
 * \ingroup trust_internal
 * \brief     ( Trust).
 * \sa #TSupSysFunctionTable, #TSupSysFunctionTableItem, 
 */
static const TSupSysFunctionTable ATRUST_TABLE =
{
    sizeof(ATRUST_FUNS)/sizeof(ATRUST_FUNS[0]),
    ATRUST_FUNS
};

/*!
 * \ingroup trust_internal
 * \brief       ( Trust).
 * \sa #rdr_register_all, #TSupSysExportFunction
 * \return      .
 * \internal    #TRUST_TABLE
 */
const TSupSysEHandle *
    Atrust_media_get_table( void )
{
    return (const TSupSysEHandle*)&ATRUST_TABLE;
}

#if defined( _WIN32 )
DWORD Atrust_property_init(
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    return base_property_init(context, info, 0, ATRUST_PATH_CFG, ATRUST_NAME);
}

DWORD Atrust_wizard_init(
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    return base_wizard_init( context, info, 
	0,
	ATRUST_ATR,
	ATRUST_MASK,
	ATRUST_FILE_NAMES,
	ATRUST_PATH_CFG,
	ATRUST_NAME
	);
}
#endif

#include "Win32/ric_rc.h"

static const TSupSysInfoIDSBaseItem ATRUST_IDS_ITEMS[] = 
{
    { SUPSYS_IDS_BLOCK_BASE, AIDS_TRUST_NAME, SUPSYS_IDS_BASE_QUANT_V2 },
    { SUPSYS_IDS_BLOCK_ICON, IDI_TRUST, SUPSYS_IDS_ICON_QUANT_V1 },
};

/*!
 * \ingroup trust_internal
 * \brief     
 */
static const TSupSysInfoIDSBase ATRUST_IDS = 
{
    sizeof(ATRUST_IDS_ITEMS)/sizeof(ATRUST_IDS_ITEMS[0]),
    ATRUST_IDS_ITEMS
};

/*!
 * \ingroup trust_fun_general
 * \brief      
 * \param context [in]  .  .
 * \param info [out]  #TSupSysInfoIDSBase
 * \return  .
 * \retval #ERROR_SUCCESS   .
 * \retval #(DWORD)ERROR_INVALID_PARAMETER   
 */
static DWORD Atrust_info_ids(
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    UNUSED( context );

    SUPSYS_PRE_INFO( info, TSupSysInfoIDSBase );
    memcpy( info, &ATRUST_IDS, sizeof( TSupSysInfoIDSBase ) );
    return ERROR_SUCCESS;
}
