#include "fat12prj.h"
#include "os_specific.h"
#include "fat12_script_wrapper.h"

BOOL is_dir(const TCHAR* path) {
    struct stat st;
    if (stat(path, &st) == -1)
	return FALSE;
    if (!S_ISDIR(st.st_mode))
	return FALSE;
    return TRUE;
}

DWORD open_named_mutex(const char* mutex_name, TGenericMutex *mutex) {
    TSupportMutex* support_mutex = (TSupportMutex*)malloc(sizeof(TSupportMutex));
    if (!support_mutex) {
	return (DWORD)NTE_NO_MEMORY;
    }
    support_mutex_init(support_mutex);
    DWORD res = support_mutex_open(support_mutex, mutex_name, GMUTEX_SNAME);
    if (ERROR_SUCCESS == res)
	*mutex = support_mutex;
    else {
	free(support_mutex);
    }

    return res;
}

DWORD delete_mutex(TGenericMutex mutex) {
    TSupportMutex* support_mutex = (TSupportMutex*)mutex;
    if(!support_mutex)
	return ERROR_SUCCESS;
    support_mutex_close(support_mutex);
    free(support_mutex);
    return ERROR_SUCCESS;
}

DWORD lock_mutex(TGenericMutex mutex) {
    TSupportMutex* support_mutex = (TSupportMutex*)mutex;
    return support_mutex_lock(*support_mutex);
}

DWORD unlock_mutex(TGenericMutex mutex) {
    TSupportMutex* support_mutex = (TSupportMutex*)mutex;
    return support_mutex_unlock(*support_mutex);
}

DWORD config_get_string(const TCHAR *path, size_t *plen, TCHAR *val) {
    return support_registry_get_string(path, plen, val);
}

