/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

#include "fat12prj.h"
#ifdef UNIX
#include <unistd.h>
#endif /* UNIX */

/*!
 * \ingroup fat12_interface
 * \brief 
 * \return \link fat12_error  \endlink
 */
DWORD fat12_connect( 
    TSupSysContext *context, 
    TSupSysInfo *info )
{
  TFat12Context *ctx = (TFat12Context*)context;
#ifdef FREEBSD
  uid_t euid;
#endif
  size_t len;

  UNUSED(info);

  SUPSYS_PRE_INFO( info, TSupSysInfoConnect );
  SUPSYS_PRE_CONTEXT( context, TFat12Context );
  SUPSYS_PRE( ctx->path == NULL );
  
  len=_tcslen(ctx->connect)+2;
#ifdef UNIX
  len+=strlen(CSP_FLOPPY_ROOT)+1;
#ifdef FREEBSD
  /* Not correct, as we don't know what is uid_t */
  len+=16;
#endif /* FREEBSD */
#else /* UNIX */
  len+=1;
#endif /* UNIX */
  ctx->path = (TCHAR*)malloc( (len + 1) * sizeof( TCHAR ) );
  if (ctx->path == NULL) 
      return (DWORD)NTE_NO_MEMORY;
#ifdef UNIX
  _stprintf( ctx->path, "%s%s/", CSP_FLOPPY_ROOT, ctx->connect );
#ifdef FREEBSD
  support_user_id_ex(NULL,NULL,&euid,NULL);
  _stprintf( ctx->path+_tcslen(ctx->path), "%lu/", (unsigned long)euid );
#endif /* FREEBSD */
#else /* UNIX */
  _tcscpy( ctx->path, ctx->connect );
  _tcscat( ctx->path, _TEXT(":/") );
#endif /* UNIX */
  return ERROR_SUCCESS;
}
