/*
 * Copyright(C) 2000-2010  
 *
 *    , 
 *   .
 *
 *  ,    , 
 *         
 *   .
 *
 *     
 *     .
 */


#include <stdio.h>
#ifdef _WIN32
#include <windows.h>
#include <wincrypt.h>
#include <wincryptex.h>
#else
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <WinCryptEx.h>
#endif	// _WIN32
#include "UnixEnroll.h"
#define TYPE_DER (X509_ASN_ENCODING | PKCS_7_ASN_ENCODING)


//   (    ,   
//    )
//----------------------------------------------------------------------
//     .     
//  ,      
// /opt/cprocsp/src/samples/CSP/MSCA 
//----------------------------------------------------------------------


static void HandleError(const char *s);
#ifdef _WIN32
#   define CONTAINER L"test"
#else
#   define CONTAINER L"\\\\.\\HDIMAGE\\test"
#endif

class Callbacks: public UnixEnroll::UserCallbacks
{
public:
	bool askPermissionToAddToRootStore( const BYTE* pbCert, DWORD cbCert, bool force = false) const;
	UserCallbacks* clone() const;
	virtual ~Callbacks() {}
};

//--------------------------------------------------------------------
//  askPermissionToAddToRootStore   

bool Callbacks::askPermissionToAddToRootStore( const BYTE* pbCert, DWORD cbCert, bool) const
{
    UNUSED(pbCert);
    UNUSED(cbCert);
    return true;
}

UnixEnroll::UserCallbacks* Callbacks::clone() const
{
	return new Callbacks();
}


//       HandleError,  
//   ,         
//   (stderr)    . 
//         , 
//        .

void HandleError(const char *s){
	DWORD err = GetLastError();
	printf("Error number     : 0x%x\n", err);
	printf("Error description: %s\n", s);
	if(!err) err = 1;
	exit(err);
} 	

static long InstallCert(BSTR bstrData){
	HRESULT res = -1;
	Callbacks tb;
	UnixEnroll * pEnroll =  new UnixEnroll(tb,false);
	const char * StoreName = "My";
	LONG StoreType=CERT_SYSTEM_STORE_CURRENT_USER;

	//  put_CAStoreFlags        
	//  
	pEnroll->put_CAStoreFlags(StoreType);
	// put_MyStoreFlags        .
	pEnroll->put_MyStoreFlags(StoreType);
	// put_RootStoreFlags         .
	pEnroll->put_RootStoreFlags(StoreType);
	// put_RequestStoreFlags       .
	pEnroll->put_RequestStoreFlags(StoreType);
	// put_MyStoreName     
	pEnroll->put_MyStoreName(ConvertStringToBSTR(StoreName));
	// put_ProviderType   CSP   .
	pEnroll->put_ProviderType(PROV_GOST_2001_DH);
	//  put_DeleteRequestCert      
	//     
	pEnroll->put_DeleteRequestCert(TRUE);
        
	//  PKCS#7   .
	res = pEnroll->acceptPKCS7(bstrData);
    	
	delete pEnroll;
	return res;
} //   InstallCert



int main(int argc, char* argv[]){
	FILE* fileCert; 
	BSTR bstrData;
	std::string str;
	int c;
	HRESULT res;
	if (argc == 2)
	    fileCert = fopen(argv[1],"rb");
	else
	    if ((fileCert = fopen("certificate.cer", "rb")) == NULL){
		HandleError( "Error open file.");
		return 1;
	    }
	    
	while ( (c = fgetc(fileCert)) != EOF ){
		str = str + (char)c;
	}
	
	printf("cert = %s \n\n", str.c_str());
	bstrData = ConvertStringToBSTR(str.c_str());	
	
	res = InstallCert(bstrData);
	
	if (res != S_OK){
		SysFreeString(bstrData);
		fclose(fileCert);
		HandleError( "Error installing certificate.");
	} else {
		printf("Successful installing certificate. \n");
	}
	
	SysFreeString(bstrData);
	fclose(fileCert);
	
	return 0;
}//end of main



//END-OF-FILE
