/*
 * Copyright(C) 2010 -, 
 *
 *    , 
 *   -.
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *     -.
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 127051 $
 * \date $Date:: 2015-09-09 15:08:20 +0300#$
 * \author $Author: pav $
 *
 * \brief      POSIX <signal.h>
 *
 */

#ifndef sup_signal_h_
#define sup_signal_h_

#ifdef UNIX
    #include <signal.h>

    #include "reader/support.h"
    #include "reader/sup_errno.h"
    #include "reader/sup_signal_safe.h"

    #ifdef __cplusplus
    extern "C" {
    #endif
	typedef void (*support_sighandler_t)(int);

	    // TODO:XX     support_an_signal()?
	SUPPORT_ACTUAL_NOSIG(support_sighandler_t,
	             /* No prefix, see C99, 6.10.3, Exmpl. 5 */,
		    signal, (int sig, void (*sahfunc)(int)),
		    (sig, sahfunc),
		    SIG_ERR != ret,
		    (EET_FTEXT(db_ctx, "%s(%d, %p) = %p fail %s(%d)"),
		    SFUNC, sig, sahfunc,
		    ret, SUP_STRERROR(serrno), serrno))
	SUPPORT_NOSIG(support_sighandler_t,
		    /* No prefix, see C99, 6.10.3, Exmpl. 5 */,
		    signal, (int sig, void (*sahfunc)(int)),
		    (sig, sahfunc),
		    SIG_ERR != ret,
		    (EET_FTEXT(db_ctx, "%s(%d, %p) = %p fail %s(%d)"),
		    SFUNC, sig, sahfunc,
		    ret, SUP_STRERROR(serrno), serrno))
	    // TODO:XX     support_an_sigaction()?
	SUPPORT_ACTUAL_NOSIG(int,
	             /* No prefix, see C99, 6.10.3, Exmpl. 5 */,
		    sigaction, (int sig, 
				const struct sigaction *SUPPORT_RESTRICT act, 
				struct sigaction *SUPPORT_RESTRICT oact),
		    (sig, act, oact),
		    0 == ret,
		    (EET_FTEXT(db_ctx, "%s(%d, %p, %p) = %d fail %s(%d)"),
		    SFUNC, sig, act, oact,
		    ret, SUP_STRERROR(serrno), serrno))
	SUPPORT_NOSIG(int,
	             /* No prefix, see C99, 6.10.3, Exmpl. 5 */,
		    sigaction, (int sig, 
				const struct sigaction *SUPPORT_RESTRICT act, 
				struct sigaction *SUPPORT_RESTRICT oact),
		    (sig, act, oact),
		    0 == ret,
		    (EET_FTEXT(db_ctx, "%s(%d, %p, %p) = %d fail %s(%d)"),
		    SFUNC, sig, act, oact,
		    ret, SUP_STRERROR(serrno), serrno))
    #ifdef __cplusplus
    }
    #endif
#endif /* UNIX */
#endif /* sup_signal_h_ */
