/*
 * Copyright(C) 2010 -, 
 *
 *    , 
 *   -.
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *     -.
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 127051 $
 * \date $Date:: 2015-09-09 15:08:20 +0300#$
 * \author $Author: pav $
 *
 * \brief      POSIX <fcntl.h>
 *
 */

#ifndef sup_fcntl_h_
#define sup_fcntl_h_

#ifdef UNIX
    #include <fcntl.h>
#else 
    #include <Winsock2.h>
#endif

#include "reader/support.h"
#include "reader/sup_errno.h"
#include "reader/sup_signal_safe.h"
#include "reader/sup_sys_socket.h"

#ifdef __cplusplus
extern "C" {
#endif

#if !defined UNIX
    #define F_GETFL 3
    #define F_SETFL 4
    #define O_NONBLOCK  8
#endif

#ifdef UNIX
    SUPPORT_ACTUAL_NOSIG(int, /* No prefix, see C99, 6.10.3, Exmpl. 5 */,
		fcntl, (int fildes, int cmd, int arg),
		(fildes, cmd, arg),
		-1 != ret,
		(EET_FTEXT(db_ctx, "%s(%d, %d, %d) = %d fail %s(%d)"),
		SFUNC, fildes, cmd, arg,
		ret, SUP_STRERROR(serrno), serrno))
#else
    SUPPORT_ACTUAL_NOSIG(int, /* No prefix, see C99, 6.10.3, Exmpl. 5 */,
		ioctlsocket, (__in SOCKET s, __in long cmd,
					    __inout u_long *argp),
		(s, cmd, argp),
		-1 != ret,
		(EET_FTEXT(db_ctx, "%s(%d, %d, %p) = %d fail %s(%d)"),
		SFUNC, s, cmd, argp,
		ret, SUP_STRERROR(serrno), serrno))

    static SUP_INLINE int support_an_fcntl(SOCKET fildes, int cmd, int arg)
    { 
	u_long nbio_yesno;

	if(/*TODO:XXX */F_GETFL == cmd) {
	    return O_NONBLOCK;
	}
	if(F_SETFL != cmd || 0 != (arg&~O_NONBLOCK)) {
	    return -1;
	}
	nbio_yesno = arg&O_NONBLOCK;

	return support_an_ioctlsocket(fildes, FIONBIO, &nbio_yesno);
    }
#endif

#ifdef __cplusplus
}
#endif
#endif /* sup_fcntl_h_ */
