#ifndef IKEV2G_TYPES_H_
#define IKEV2G_TYPES_H_

#ifdef HAVE_STDBOOL_H
# include <stdbool.h>
#else
# ifndef HAVE__BOOL
#  define _Bool signed char
# endif /* HAVE__BOOL */
# define bool _Bool
# define false 0
# define true 1
# define __bool_true_false_are_defined 1
#endif /* HAVE_STDBOOL_H */
#ifndef FALSE
# define FALSE false
#endif /* FALSE */
#ifndef TRUE
# define TRUE  true
#endif /* TRUE */

#include <stdint.h>

/**
 * @brief Encryption algorithm transform IDs.
 *
 * IDs according to IANA numeration.
 * For more information see:
 *  https://www.iana.org/assignments/ikev2-parameters/ikev2-parameters.xhtml
 */
typedef enum IKE_ALG_ID
{
    /**
     * @brief AEAD transform based on the Kuznyechik.
     */
    GOST3412_2015_K = 32,

    /**
     * @brief AEAD transform based on the Magma.
     */
    GOST3412_2015_M = 33,
} IKE_ALG_ID;

/**
 * @brief Key exchange method transform IDs.
 *
 * IDs according to IANA numeration.
 */
typedef enum IKE_DH_GROUP
{
    /**
     * @brief id-tc26-gost-3410-2012-256-paramSetA curve.
     */
    GOST3410_2012_256 = 33,

    /**
     * @brief id-tc26-gost-3410-2012-512-paramSetC curve.
     */
    GOST3410_2012_512 = 34,
} IKE_DH_GROUP;

/**
 * @brief Hash algorithms IDs.
 *
 * IDs according to IANA numeration.
 */
typedef enum IKE_GOST_HMAC_ID {
    /**
     * @brief 256-bit Streebog.
     */
    HMAC_STREEBOG_256 = 6,

    /**
     * @brief 512-bit Streebog.
     */
    HMAC_STREEBOG_512 = 7
} IKE_GOST_HMAC_ID;

#endif /* IKEV2G_TYPES_H_ */
