#ifndef WND_UTILS_H_INCLUDED
#define WND_UTILS_H_INCLUDED

#ifdef UNIX
# define CPUI_INLINE inline
#else
# define CPUI_INLINE __inline
#endif

static const int autownd_default_max_event_checks = -1; //-1 means infinity
static const int autownd_default_interval = 500; //ms

typedef struct TAutoWindowParams_ {
    int max_event_checks;
    int interval;
} TAutoWindowParams;

static CPUI_INLINE TAutoWindowParams autownd_get_default_window_params() {
    TAutoWindowParams res;
    res.max_event_checks = autownd_default_max_event_checks;
    res.interval = autownd_default_interval;
    return res;
}

static CPUI_INLINE void autownd_decrement_event_checks(int* checks) {
    if (*checks == -1) {
	return; //infinity
    }
    else {
	(*checks) -= 1;
	return;
    }
}

static CPUI_INLINE int autownd_get_default_interval() {
    return autownd_default_interval;
}

static CPUI_INLINE int autownd_get_default_max_event_checks() {
    return autownd_default_max_event_checks;
}

#endif //WND_UTILS_H_INCLUDED
