#ifndef _CPGUI_H_
#define _CPGUI_H_

#include "WinCryptEx.h"
#include "CPCryptEx.h"
#include "reader/support.h"
#include "reader/support_utf8.h"
#include "wnd_utils.h"
#include "compiler_attributes.h"
#include "visualizer.h"

/*
          , :
  1.  cpgui.h ( ).  WinCryptEx.h -  ,  CryptoApi     .
  2.  CSP\src\RuNetCSP\NewCarrier\message.c ( car_find.c) (   ).
  3.  CSP\src\RuNetCSP\csptypes.idl ,      .  ,   csptypes.h
  4.    CSP\src\RuNetCSP\sescsp.idl -    .  ,   sescsp.h
  5.  CSP\src\RuNetCSP\sescp-cp.c -       . 
       cpcspi
  
  6.      cpui.   .

  7.  CSP\src\RuNetCSP\rmcp-ses.cpp -       .
      cpcspr

  8.   csptypes.h  CSP/src/fenix.
      :
  
  9.   CSP\src\fenix\test\march-ms\march-ms-c.c, CSP\src\fenix\test\march-ms\march-ms-s.c.
      march-ms.

  10.      CSP\src\fenix\wirecp_m.c.
  11.   CSP\src\fenix\test\march-wire\march-wire-s.c, CSP\src\fenix\test\march-wire\march-wire-c.c.
  12.   CSP\src\fenix\sup-callback.c,   -  .
      march-wire  cpcsphc.

  13.   CSP\src\fenix\impl-wire_c.c, CSP\src\fenix\wirecp-cpc.c, CSP\src\fenix\wirecp-cpc.c.
       fenix  unix.

  14.     CSP/cpui/Win32.not/ -     unix.
 */

/*! \internal
* \ingroup grp_carrier_wind_real
* \brief  -  
*/
typedef struct CPUISelectItem_ {
    TCHAR name[MAX_CONTAINER_NAME_LEN + 1]; /*!<    */
    TCHAR unique[MAX_INPUT_CONTAINER_STRING_LEN + 1]; /*!<     */
    TCHAR reader_name[MAX_READER_NAME_LEN + 1]; /*!< ""   */
    TCHAR nickname[MAX_READER_NAME_LEN + 1]; /*!<    */
    TCHAR connect[256]; /*!<   */
    TCHAR friendly_name[256]; /*!<    */
    BYTE property_version;
    BYTE property_flags;
} CPUISelectItem;


typedef HRESULT WINAPI cpui_enum_containers_open(void *arg, void **ctx, DWORD flags) ATTR_USERES;

typedef HRESULT WINAPI cpui_enum_containers_next(void *arg, void *ctx, CPUISelectItem* item) ATTR_USERES;

typedef HRESULT WINAPI cpui_enum_containers_close(void *arg, void *ctx) ATTR_USERES;

/*! \internal
* \ingroup grp_carrier_wind_real
* \brief    
*/
typedef struct CRYPTOAPI_SELECT_WND_CONFIG_ {
    DWORD size_of;
    DWORD flags; /*!< [in]   . */
    void * enum_containers_arg;
    cpui_enum_containers_open * enum_containers_open;
    cpui_enum_containers_next * enum_containers_next;
    cpui_enum_containers_close * enum_containers_close;
} CRYPTOAPI_SELECT_WND_CONFIG;

/*! \internal
* \ingroup grp_carrier_wind_real
* \brief    
*/
typedef struct CRYPTOAPI_SELECT_WND_OUT_
{
    TCHAR container_name[MAX_INPUT_CONTAINER_STRING_LEN + 1]; /*!< [out]  ,       . */
} CRYPTOAPI_SELECT_WND_OUT;

#ifdef __cplusplus
extern "C" {
#endif
    HRESULT WINAPI CPSelectContainer(
    /* in */ HWND parent,
    /* in */ CRYPTOAPI_SELECT_WND_CONFIG * info,
    /* out */ CRYPTOAPI_SELECT_WND_OUT * out) ATTR_USERES;
#ifdef __cplusplus
}
#endif

#define CRYPTOAPI_MESSAGE_BTN_OK	1
#define CRYPTOAPI_MESSAGE_BTN_CANCEL	2
#define CRYPTOAPI_MESSAGE_DEF_CANCEL	4
#define CRYPTOAPI_MESSAGE_BTN_LIC	8
#define CRYPTOAPI_MESSAGE_BTN_PRESS_BUY	16
#define CRYPTOAPI_MESSAGE_2001_KEY	128

/*     */
typedef struct CRYPTOAPI_MESSAGE_WND_CONFIG_ {
    DWORD size_of;
    DWORD num; /*!<    . */
    DWORD buttons; /*!<   . */
    TCHAR containername [256]; /*!<   " " */
    TCHAR* message; // message 
    DWORD message_len; //message len
} CRYPTOAPI_MESSAGE_WND_CONFIG;

/*    */
typedef struct CRYPTOAPI_MESSAGE_WND_OUT_ {
    DWORD ok;
} CRYPTOAPI_MESSAGE_WND_OUT;


/*     */
typedef struct CRYPTOAPI_MESSAGE_WND_CONFIG_EX_ {
    HWND parent;    /*!<    */
    WORD language; /*!<   */
    WORD buttons; /*!<    */
    char * header; /*!<  , NULL     */
    char * text; /*!<  */
} CRYPTOAPI_MESSAGE_WND_CONFIG_EX;

/*   
ctx -   
parent -   ,    
some_event -   
*/
typedef HRESULT WINAPI cpui_message_event(/* [in] */ const HDISPMESSAGECONTEXT ctx, const TAutoWindowParams* window_params,  /* [out] */ void * some_event) ATTR_USERES;


/*     */
typedef struct CRYPTOAPI_MESSAGE_WND_CONFIG_AUTO_ {
    HWND parent;    /*!<    */
    WORD language; /*!<   */
    WORD buttons; /*!<    */
    char * header; /*!<  , NULL     */
    char * text; /*!<  */
    cpui_message_event * fun_event; /*!< ,   */
    TAutoWindowParams window_params;
} CRYPTOAPI_MESSAGE_WND_CONFIG_AUTO;

/*   

     .
: 
parent -   ;
language - ,     ;
buttons: 
 CRYPTOAPI_MESSAGE_BTN_OK, CRYPTOAPI_MESSAGE_BTN_CANCEL, CRYPTOAPI_MESSAGE_BTN_LIC      .
 CRYPTOAPI_MESSAGE_DEF_CANCEL    CANCEL.
 CRYPTOAPI_MESSAGE_BTN_PRESS_BUY     .
 CRYPTOAPI_MESSAGE_2001_KEY      2001 . 
header -  . NULL,       ;
text -    utf8;
  ERROR_CANCELLED,    ,     "   1 ",   S_OK.
  ERROR_RETRY,     CRYPTOAPI_MESSAGE_BTN_LIC,       BUY;
  ,   OK,   S_OK;
  NTE_FAIL,     CRYPTOAPI_MESSAGE_BTN_LIC,       BUY.
  SCARD_W_CANCELLED_BY_USER,    CANCEL;
     CryptoApi.
*/
#ifdef __cplusplus
extern "C" {
#endif
    HRESULT WINAPI CPDisplayMessage(
    /* [in] */ HWND parent,
    /* [in] */ CRYPTOAPI_MESSAGE_WND_CONFIG *info,
    /* [out] */ CRYPTOAPI_MESSAGE_WND_OUT * out) ATTR_USERES;
    HRESULT WINAPI CPDisplayMessageEx( /* [in] */ CRYPTOAPI_MESSAGE_WND_CONFIG_EX *info) ATTR_USERES;
    HRESULT WINAPI CPDisplayMessageAuto( /* [in] */ const HDISPMESSAGECONTEXT ctx, /* [in] */ CRYPTOAPI_MESSAGE_WND_CONFIG_AUTO *info) ATTR_USERES;

#ifdef __cplusplus
}
#endif

/*    char*     UTF8*/

/*   .

       - ,   main.         
  main (M)   - unblocking (U).       M, ,   ,
  U.

     ,      .        ,     
  ,     .   ,     ,  ,  , 
     -  ,  0 -   - ,     : 
ca_sspf_ask = M0,
ca_sspf_change = 0M,
ca_sspf_unblock = UM,
ca_sspf_ask_change = MM.

          :
ca_sspf_ask -> ca_sspf_unblock,   can_ask_unblocking == 1,    SCARD_W_CHV_BLOCKED.
ca_sspf_change -> ca_sspf_unblock,   can_ask_unblocking == 1,    SCARD_W_CHV_BLOCKED.
ca_sspf_change -> ca_sspf_ask_change,   can_ask_main == 1,    SCARD_W_CARD_NOT_AUTHENTICATED.
    .

 can_ask_main     ca_sspf_ask.    .
 can_ask_main    ca_sspf_change,    ,     .
 can_ask_unblocking    ca_sspf_ask,     .      " ".
 can_ask_unblocking    ca_sspf_change,     ,     .

     ca_sspf_ask,             .
     ca_sspf_change,              .
     ca_sspf_unblock,              .
   ca_sspf_ask_change  .
*/
typedef enum
{
    ca_sspf_ask = 1,	    /* " "*/
    ca_sspf_change = 2,	    /* " "  "  "*/
    ca_sspf_unblock = 3,    /* " "  "   "*/
    ca_sspf_ask_change = 4  /* "      "*/
} PWDFKC_WINDOW_START_STATES;

/*       ,        */
#define PWDFKC_PASSWORD_ASK_INDEX 0
#define PWDFKC_PASSWORD_CHANGE_INDEX 1
#define PWDFKC_PASSWORD_UNBLOCK_INDEX 2
#define PWDFKC_PASSWORD_ASK_CHANGE_INDEX 3
#define PWDFKC_PASSWORD_INDEX_NUMBER 4


/*    .
parent -   ,    

set_info->auth_type   ,    .    main_pass.auth_type   .
set_info->password -  
set_info->flags.save_in_cache -     0,  .
set_info->flags.save_in_registry -     0,  .
set_info->reserved      .

 :
1.  CryptoAPI -     ,   .
2. SCARD_W_CARD_NOT_AUTHENTICATED -    .     ca_sspf_change (   ).
        ca_sspf_ask_change,    ( can_ask_main).
3. SCARD_W_CHV_BLOCKED -    .      ca_sspf_change (    ).
        ca_sspf_unblock,    ( can_ask_unblocking).
4. ERROR_INVALID_STATE -  ,       / ,   .
*/
typedef HRESULT WINAPI cpui_pwdfkc_change_auth(const PWDFKC_CONTEXT* ctx, HWND parent, const CRYPT_PIN_WND_SOURCE_PARAM* set_info) ATTR_USERES;

/*   .
parent -   ,    

set_info->auth_type   ,     (   unblocking_pass.auth_type,   main_pass.auth_type   ).
set_info->password -  
set_info->flags.once -     0,  .
set_info->flags.save -    . 1,   , 0 .
set_info->reserved    {0,NULL}.

 :
1.  CryptoAPI -     ,   .
2. SCARD_W_CHV_BLOCKED -    .     ca_sspf_ask,    .
        ca_sspf_unblock,    ( can_ask_unblocking).
3. ERROR_INVALID_STATE -  ,       / ,   .
*/
typedef HRESULT WINAPI cpui_pwdfkc_auth(const PWDFKC_CONTEXT* ctx, HWND parent, const CRYPT_PIN_WND_SOURCE_PARAM * pass) ATTR_USERES;

/*     . 
      ,      
     .          .*/
#define AUTH_INFO_TRYES_UNDEFINED 0x8000  

/*   "     " */
#define AUTH_INFO_ERROR_NO	0

/*   "  " */
#define AUTH_INFO_ERROR_BLOCKED_MAIN	1

/*   "  " */
#define AUTH_INFO_ERROR_BLOCKED_UNBLOCKING	2

/*   "  " */
#define AUTH_INFO_ERROR_BLOCKED_BOTH	(AUTH_INFO_ERROR_BLOCKED_MAIN | AUTH_INFO_ERROR_BLOCKED_UNBLOCKING)

/*  "         " */
#define AUTH_INFO_ERROR_NEED_MAIN		4

/*  "        " */
#define AUTH_INFO_ERROR_NEED_UNBLOCKING		8

/*  "   ,  " */
#define AUTH_INFO_ERROR_BLOCKED_MAIN_TEMP	16

/*        .
              .
    out_info: 
1.    ,       .
2.    out_info->error. (    ).  
2.1. AUTH_INFO_ERROR_BLOCKED_MAIN  -    ,      .
2.2. AUTH_INFO_ERROR_BLOCKED_UNBLOCKING  -  (  )  ,    .    
                                    ,  , ,    .     
				     .
2.3. AUTH_INFO_ERROR_BLOCKED_BOTH -    .    .
2.4. AUTH_INFO_ERROR_NEED_MAIN	-         .      
				  AUTH_INFO_ERROR_BLOCKED_MAIN, AUTH_INFO_ERROR_BLOCKED_UNBLOCKING.
2.5. AUTH_INFO_ERROR_NEED_UNBLOCKING -         .      
				  AUTH_INFO_ERROR_BLOCKED_UNBLOCKING.
2.6. AUTH_INFO_ERROR_NO -	       .
   AUTH_INFO_ERROR_BLOCKED_MAIN        .
   AUTH_INFO_ERROR_BLOCKED_BOTH      SCARD_W_CHV_BLOCKED.
   AUTH_INFO_ERROR_BLOCKED_UNBLOCKING      SCARD_W_CHV_BLOCKED  ,      
      SCARD_W_CHV_BLOCKED.

 :
1. ERROR_SUCCESS -     .
2.  CryptoAPI -  ,      .
3. ERROR_INVALID_STATE -  ,       / ,   .
*/
typedef HRESULT WINAPI cpui_pwdfkc_get_auth_info(const PWDFKC_CONTEXT* ctx, HWND parent, CRYPT_WND_INFO_PARAM* out_info) ATTR_USERES;

/*  .*/
typedef struct
{
    BOOL exist; /* ,         */
    char * name;    /* .  NULL   ,   -     */
} PWDFKC_INIT_COUNTER;


/*    */
typedef struct
{
    unsigned show : 1;	 /* ,       */
    unsigned change : 1; /* ,    */
    unsigned set1 : 1;	 /* ,      1 (  ) */
} PWDFKC_FIELD_FLAGS;


/*      */
typedef struct
{
    DWORD auth_type;		/*    CSP.   . */
    struct
    {
	char * term;		/*   */
	char * not_same;	/*     */
    } strings;			/*  */
    char * example;		    /*  .  , unused */
    SHORT min_length;		    /*   */
    SHORT max_length;		    /*   */
    DATA_BLOB enc;		    /*    . unused */
} PWDFKC_PASSWORD_INPUT;

/*  -  */
typedef struct
{
    HWND parent;	    /*     */
    WORD language; 	    /*   */
    PWDFKC_WINDOW_START_STATES start_state;	    /*    (   ) */
    struct
    {
	unsigned can_ask_main : 1;	/*       (.  PWDFKC_WINDOW_START_STATES ) */
	unsigned can_ask_unblocking : 1;	/*       (.  PWDFKC_WINDOW_START_STATES ) */
    } flags;	    /*   */
    PWDFKC_FIELD_FLAGS	save_in_cache;	/*   "   " */
    PWDFKC_FIELD_FLAGS	save_in_system;	/*   "   " */
    char * header; /*   */
    char * text[PWDFKC_PASSWORD_INDEX_NUMBER]; /*    */
    char * add_text;	/*  (,  ) */
    struct
    {
	char* group;	    /*    */
	char* reader_term;	    /*    */
	char* reader_value;	    /*    */
	char* unique_term;	    /*    */
	char* unique_value;	    /*    */
	char* container_term;	    /*    */
	char* container_value;	    /*    */
	BOOL unique_exists;
    } name; /*    */
    PWDFKC_PASSWORD_INPUT  main_pass;	    /*   */
    PWDFKC_PASSWORD_INPUT  unblocking_pass;	    /*   ,      two_pass,  ,    */
    PWDFKC_INIT_COUNTER main_counters[CPCAR_COUNTER_CONTAINER_NUMBER];	/*         */
    PWDFKC_INIT_COUNTER unblocking_counters[CPCAR_COUNTER_ROOT_NUMBER];		/*         */

    cpui_pwdfkc_get_auth_info*	fun_info;	/* callback     */
    cpui_pwdfkc_auth*		fun_auth;	/* callback    */
    cpui_pwdfkc_change_auth*	fun_change;	/* callback   ()  */
}  CRYPTOAPI_PASSWORD_FKC_WND_CONFIG;

/*   .

         .        (. PWDFKC_WINDOW_START_STATES).
   ca_sspf_ask       .
   ca_sspf_change       .
   ca_sspf_unblock       B      .

 ca_sspf_ask   " ",  can_ask_main.        ca_sspf_ask_change,     .
   show_properties       ,     .

   ,   ,      a_counters, b_counters.
   times_exist,      time_private_key, time_public_key.
      .

    ,     ,     show_properties  "" ,   
   .

 ,  header.
          text[i],  i -  . (,  ca_sspf_ask - PWDFKC_PASSWORD_ASK_INDEX).
 add_text != 0,     add_text.
 name.group!=0,         name.group.
 name.reader_term!=0,         name.reader_term.
 name.reader_value!=0,      .
 name.unique_term!=0,         name.unique_term.
 name.unique_value!=0,      .
 name.container_term!=0,         name.container_term.
 name.container_value!=0,      .
 name.unique_exists == FALSE,       ,   

  ,    ,      .

            .
      .
      error!=0,     ,  error,    ,     
.
      ERROR_SUCCESS,      ,        .
       ,      (   ),   ;
     ,        .

         A      (    ).
        .

          B.

1.      ca_sspf_ask,          :
1.1.  .

1.2.         ca_sspf_unblock,    ,    :
 1.2.1  .
 1.2.2  .
1.3.         ca_sspf_ask_change,   :
 1.3.1.  .
 1.3.2.  .

2.      ca_sspf_change,          :
2.1.  .
2.2.          ca_sspf_unblock,    ,    :
 2.2.1.  .
 2.2.2.  .
2.3.         ca_sspf_ask_change,    ,    :
 2.3.1.  .
 2.3.2.  .

3.      ca_sspf_unblock,         :
3.1.  .
3.2.  .

   CryptoAPI    SCARD_W_CARD_NOT_AUTHENTICATED, SCARD_W_CHV_BLOCKED, ERROR_INVALID_STATE,   ,
     .
*/
#ifdef __cplusplus
extern "C" {
#endif
HRESULT WINAPI CPQueryPinEx(const PWDFKC_CONTEXT* ctx, const CRYPTOAPI_PASSWORD_FKC_WND_CONFIG* info) ATTR_USERES;
#ifdef __cplusplus
}
#endif

#define VISUALIZER_CONTROL_FLAG_ASK_PASSWORD 1 /* , ,          */

/*  -      */
typedef struct
{
    CRYPTOAPI_PASSWORD_FKC_WND_CONFIG * info;	/*      ,       CPQueryPinEx. */
    PHS_SIGNING_DATA signing_data;		/*    ,   . */
    PHS_ADDITIONAL_DATA additional_data;	/* ,     ,     signing_data. */
    DWORD context_flags;			/*    ,    .    CRYPT_SILENT. 
						      ,   . */
    DWORD control_flags;			/*   ,  .  , VISUALIZER_CONTROL_FLAG_ASK_PASSWORD. */
}  CRYPTOAPI_VISUALIZER_WND_CONFIG;

/*      .
 (control_flags & VISUALIZER_CONTROL_FLAG_ASK_PASSWORD) != 0,   ,   signing_data  additional_data,    
       ,   info.
 (control_flags & VISUALIZER_CONTROL_FLAG_ASK_PASSWORD) == 0,   ,   signing_data  additional_data,    
  .
        ca_sspf_change  (?)

   CryptoAPI    SCARD_W_CARD_NOT_AUTHENTICATED, SCARD_W_CHV_BLOCKED, ERROR_INVALID_STATE,   ,
     ,  ,    .
  ERROR_SUCCESS,     .
  NTE_SILENT_CONTEXT,     ,    ,  .
  SCARD_W_CANCELLED_BY_USER,     .
  NTE_BAD_DATA,   . 
  ERROR_UNSUPPORTED_TYPE,     .
*/
#ifdef __cplusplus
extern "C" {
#endif
    HRESULT WINAPI CPAskForSign(const PWDFKC_CONTEXT* ctx, const CRYPTOAPI_VISUALIZER_WND_CONFIG* info) ATTR_USERES;
#ifdef __cplusplus
}
#endif


/*! 
     legacy-  
*/

typedef struct _CRYPTOAPI_CARRIER_INFO {
    DWORD login_type;
    short max_length;
    short min_length;
    /* [string][full] */ TCHAR *reader_name;
    /* [string][full] */ TCHAR *nickname;
    /* [string][full] */ TCHAR *passwd_term;
    unsigned char flags;
} CRYPTOAPI_CARRIER_INFO;

typedef struct _CRYPTOAPI_CARRIER_LIST {
    short n;
    /* [size_is] */ CRYPTOAPI_CARRIER_INFO *parts;
} CRYPTOAPI_CARRIER_LIST;

typedef struct _CRYPTOAPI_RDR_PIN_FLAGS {
    unsigned char use_double;
    unsigned char same_double;
    unsigned char save_passwd;
    unsigned char disable_save_passwd;
} CRYPTOAPI_RDR_PIN_FLAGS;

typedef struct _CRYPTOAPI_PIN_WND_CONFIG {
    DWORD size_of;
    CRYPTOAPI_CARRIER_INFO context;
    /* [full][string] */ TCHAR *header;
    /* [full][string] */ TCHAR *text;
    /* [full][string] */ TCHAR *input;
    /* [full][string] */ TCHAR *input2;
    /* [full][string] */ TCHAR *default_passwd;
    /* [full][string] */ TCHAR *not_same;
    /* [full][string] */ TCHAR *save_text;
    /* [full][string] */ TCHAR *container_name;
    CRYPTOAPI_RDR_PIN_FLAGS flags;
    int try_number;
    DWORD idd;
    DWORD container_flags;
    DWORD action;
#ifndef NO_NK
    short n;
    short k;
    short max_n;
    short max_k;
#endif // NO_NK
} CRYPTOAPI_PIN_WND_CONFIG;

typedef struct _CRYPTOAPI_PIN_WND_OUT {
    TCHAR passwd[256];
    TCHAR passwd2[256];
#ifndef NO_NK
    TCHAR container[256];
    short n;
    short k;
    char create_container;
#endif // NO_NK
    char save_passwd;
} CRYPTOAPI_PIN_WND_OUT;

#ifdef __cplusplus
extern "C" {
#endif //__cplusplus
    HRESULT WINAPI CPQueryPin(
	/* [in] */ HWND parent,
	/* [in] */ CRYPTOAPI_PIN_WND_CONFIG *info,
	/* [in] */ CRYPTOAPI_SELECT_WND_CONFIG * select_info,
	/* [out] */ CRYPTOAPI_PIN_WND_OUT * out) ATTR_USERES;
#ifdef __cplusplus
}
#endif //__cplusplus


/*
 *         
 *     :
 * utf8z     '\0',    ;
 * utf8z       '\0',  ;
 *  i = 0..CRYPTOAPI_SELECT_READER_MAX_APPLET_COUNT-1:
 * utf8z  unique[i],  '\0',  unique[i] ;
 * utf8z  info[i],  '\0',  info[i] ;
 * ---------------------------------- version 2 ----------------------------------
 * utf8z     '\0',    ;
 * DWORD  ;
 */
typedef struct _CRYPT_SELECT_READER_ITEM
{
    HSELREADER	context; 	/*! \brief  / */
    ULONGLONG	icon_count;	/*! \brief   */
    HSELREADERICON icons[CRYPTOAPI_SELECT_READER_ICONS_NUMBER]; /*! \brief   */
    ULONGLONG	unique_count;	/*! \brief   */
    DWORD	retcode[CRYPTOAPI_SELECT_READER_MAX_APPLET_COUNT]; /*! \brief    */
} CRYPT_SELECT_READER_ITEM;

/*     .
 *   ctx,    parent,    list_context.
 */
typedef HRESULT WINAPI cpui_selreader_list_open (HSELREADERINITDATA ctx, HWND parent, HSELREADERLISTCONTEXT * list_context) ATTR_USERES;

/*      .
 *   ctx,    parent,   .
 * list_context -  ,    (ctx, parent).
 * item_size -   -    out_item.   -         out_item!=NULL,
 *    ,  out_item == NULL,
 *    ,       .
 *       ,  NULL   ,      .
 * out_item -     .
 */
typedef HRESULT WINAPI cpui_selreader_list_next(HSELREADERINITDATA ctx, HWND parent, HSELREADERLISTCONTEXT list_context, size_t * item_size, CRYPT_SELECT_READER_ITEM * out_item) ATTR_USERES;

/*   .
 *   ctx,    parent,     list_context.
 */
typedef HRESULT WINAPI cpui_selreader_list_free(HSELREADERINITDATA ctx, HWND parent, HSELREADERLISTCONTEXT list_context) ATTR_USERES;

/*     (    ).
 *   ctx,    parent,      reader    current_applet. 
 */
typedef HRESULT WINAPI cpui_selreader_set_answer (HSELREADERINITDATA ctx, HWND parent, HSELREADER reader, unsigned int current_applet) ATTR_USERES;

/*     .
 *   ctx,    parent,     defcontext.
 */
/* borodin ,       . 2020-jan-23 */
typedef HRESULT WINAPI cpui_selreader_set_default(HSELREADERINITDATA ctx, HWND parent, HSELREADER defcontext);

/*    .
 *   ctx,    parent,   reader.
 *  ,    cpui_selreader_list_next,         ,  
 * ,  .
 */
typedef HRESULT WINAPI cpui_selreader_delete_hselreader(HSELREADERINITDATA ctx, HWND parent, HSELREADER reader) ATTR_USERES;


/*     .
 *   ctx,    parent,    icon  x_icon*y_icon   <= priority.
 * out_size -      out_data. 
 *    out_size         ,    ,  out_data == NULL
 *          . 
 */
typedef HRESULT WINAPI cpui_selreader_icon_transmit(HSELREADERINITDATA ctx, HWND parent, HSELREADERICON icon, DWORD x_icon, DWORD y_icon, DWORD priority, size_t * out_size, LPBYTE out_data) ATTR_USERES;

/*
 *           .
 */
typedef struct
{
    HWND parent; /*!<  Win32,  . */
    WORD language; /*!<    */
    DWORD flags;  /*!< ,   */

    char * header; /*!<  , NULL  . */
    char * text; /*!<   , NULL  . */
    char * text_for_empty; /*!<      . */
    char * defreader; /*!<     */

    cpui_selreader_list_open * list_open; /*!<    */
    cpui_selreader_list_next * list_next; /*!<      */
    cpui_selreader_list_free * list_free; /*!<    */
    cpui_selreader_delete_hselreader * del_reader; /*!<    */
    cpui_selreader_set_answer * set_answer; /*!<     */
    cpui_selreader_set_default * set_def;      /*!<    . */
    cpui_selreader_icon_transmit * get_icon_info; /*!<     .   NULL. */
} CRYPTOAPI_SELECT_READER_CONFIG;

#ifdef __cplusplus
extern "C" {
#endif
    HRESULT WINAPI CPSelectReader(HSELREADERINITDATA ctx, const CRYPTOAPI_SELECT_READER_CONFIG *init_info) ATTR_USERES;
#ifdef __cplusplus
}
#endif

typedef HRESULT(WINAPI *cpuifkc_select_carrier_ptr_t)(HSELREADERINITDATA ctx, const CRYPTOAPI_SELECT_READER_CONFIG *init_info) ATTR_USERES;

typedef HRESULT(WINAPI *cpui_query_pin_ex_ptr_t)(const PWDFKC_CONTEXT* ctx, const CRYPTOAPI_PASSWORD_FKC_WND_CONFIG* info) ATTR_USERES;

typedef HRESULT(WINAPI *cpui_query_pin_ptr_t)(HWND parent, CRYPTOAPI_PIN_WND_CONFIG* info, CRYPTOAPI_SELECT_WND_CONFIG* select_info, CRYPTOAPI_PIN_WND_OUT* out) ATTR_USERES;

typedef HRESULT(WINAPI *cpui_display_message_ex_ptr_t)(CRYPTOAPI_MESSAGE_WND_CONFIG_EX * info) ATTR_USERES;

typedef HRESULT(WINAPI *cpui_display_message_ptr_t)(HWND parent, CRYPTOAPI_MESSAGE_WND_CONFIG * info, CRYPTOAPI_MESSAGE_WND_OUT * out) ATTR_USERES;

typedef HRESULT(WINAPI *cpui_select_container_ptr_t)(HWND parent, CRYPTOAPI_SELECT_WND_CONFIG * info, CRYPTOAPI_SELECT_WND_OUT * out) ATTR_USERES;

typedef HRESULT(WINAPI *cpui_display_message_auto_ptr_t)(const HDISPMESSAGECONTEXT ctx, CRYPTOAPI_MESSAGE_WND_CONFIG_AUTO *info) ATTR_USERES;

typedef HRESULT(WINAPI *cpui_ask_for_sign_ptr_t)(const PWDFKC_CONTEXT* ctx, const CRYPTOAPI_VISUALIZER_WND_CONFIG* info) ATTR_USERES;

#ifndef CSP_EXPORT
#define CSP_EXPORT extern
#endif /* CSP_EXPORT */

#ifdef __cplusplus
extern "C" {
#endif

#if defined _WIN32
#define UI_MODULE_NAME _TEXT("cpui.dll") 
#define DISPLAY_MESSAGE_NAME_EX "cpui_display_message_ex"
#define DISPLAY_MESSAGE_NAME_AUTO "cpui_display_message_auto"
#define DISPLAY_MESSAGE_NAME "cpui_display_message"
#define SELECT_CONTAINER_NAME "cpui_select_container"
#define QUERY_PIN_NAME "cpui_query_pin"
#define QUERY_PIN_EX_NAME "cpui_query_pin_ex"
#define SELECT_CARRIER_NAME "cpui_choice_carrier"
#define ASK_FOR_SIGN_NAME "cpui_ask_for_sign"
#else
#define UI_MODULE_NAME _TEXT("libcpui.so")
#define DISPLAY_MESSAGE_NAME_EX "CPDisplayMessageEx"
#define DISPLAY_MESSAGE_NAME_AUTO "CPDisplayMessageAuto"
#define DISPLAY_MESSAGE_NAME "CPDisplayMessage"
#define SELECT_CONTAINER_NAME "CPSelectContainer"
#define QUERY_PIN_NAME "CPQueryPin"
#define QUERY_PIN_EX_NAME "CPQueryPinEx"
#define ASK_FOR_SIGN_NAME "CPAskForSign"
#endif

#ifdef __cplusplus
}
#endif


#endif /*_CPGUI_H_*/
