#ifndef CALLCTX_H_INCLUDED
#define CALLCTX_H_INCLUDED 1

#include "BaseArithmDef_64.h"
#include "compiler_attributes.h"

#ifdef __cplusplus
extern "C" {
#endif


typedef struct _CP_CALL_CTX_ CP_CALL_CTX, *pCP_CALL_CTX;
typedef struct _CRYPT_CSP_ CRYPT_CSP, * LPCRYPT_CSP;

typedef struct _CRYPT_CSP_THREAD_		CRYPT_CSP_THREAD,		*LPCRYPT_CSP_THREAD;
typedef struct _CSP_THREAD_TEMP_DATA		CSP_THREAD_TEMP_DATA,		*LPCSP_THREAD_TEMP_DATA;
typedef struct _CSP_THREAD_TEMP_CIPHER_DATA	CSP_THREAD_TEMP_CIPHER_DATA,	*LPCSP_THREAD_TEMP_CIPHER_DATA;
typedef struct _CSP_THREAD_TEMP_HASH_DATA	CSP_THREAD_TEMP_HASH_DATA,	*LPCSP_THREAD_TEMP_HASH_DATA;
typedef struct _CSP_THREAD_VTB_MP		CSP_THREAD_VTB_MP,		*LPCSP_THREAD_VTB_MP;

typedef struct _CP_ASTACK_ CP_ASTACK;



/*   . */
struct RND_CONTEXT_;

/*! \internal
* \brief      .
*
* \param context [in/out]  ,     
*    .
* \param buffer [out] ,     .
* \param length [in]     .
* \return TRUE,   , FALSE .
*/
typedef BOOL(*GetRandomFunction)(pCP_CALL_CTX pCallCtx, struct RND_CONTEXT_ *context, LPBYTE buffer, uint32_t length, uint32_t flags) ATTR_USERES;

/*! \internal
* \brief      .
*
* \param context [in/out]  ,     
*    .
* \param additional_input [in]        
* \param additional_input_length [in]         
* \param buffer [out] ,     .
* \param length [in]     .
* \return TRUE,   , FALSE .
*/

typedef BOOL(*GetRandomFunctionEx)(pCP_CALL_CTX pCallCtx, struct RND_CONTEXT_ *context,
    const BYTE * additional_input, uint32_t additional_input_length,
    LPBYTE buffer, uint32_t length, uint32_t flags) ATTR_USERES;

/*! \internal
* \brief      .
*
* \param context [in/out]  ,     
*    .
* \return TRUE,      ( ),
*  FALSE .
*/
typedef BOOL(*IsRandomInitedFunction)(pCP_CALL_CTX pCallCtx, struct RND_CONTEXT_ *context) ATTR_USERES;

/*! \internal
* \brief      .
*
* \param context [in/out]  ,     
*    .
* \param seed [in]  .
*/
typedef BOOL(*SetRandomSeedFunction)(pCP_CALL_CTX pCallCtx, struct RND_CONTEXT_ *context, const LPBYTE seed, size_t length, DWORD dwInitFlags) ATTR_USERES;

/*! \internal
* \brief      .
*
* \param context [in/out]  
* \param entropy_input_reseed [in] 
* \param entropy_input_length [in]  
* \param additional_input [in]  
* \param additional_input_length [in]   
*/
typedef BOOL(*ReseedFunction)(pCP_CALL_CTX pCallCtx, struct RND_CONTEXT_ *context,
    const BYTE * entropy_input_reseed, DWORD entropy_input_length,
    const BYTE * additional_input_reseed, DWORD additional_input_length) ATTR_USERES;

/*! \internal
* \brief     .
*/
typedef struct RND_CONTEXT_ {

    DWORD Flags;			    /*!<   .*/
    DWORD dwSecurityLevel;

    /*      */
    GetRandomFunction make_random; /*!<      . */
    IsRandomInitedFunction is_inited; /*!<      . */

    /*    */
    SetRandomSeedFunction set_random_seed; /*!<     random_seed. */

    /*    */
    ReseedFunction reseed;
    GetRandomFunctionEx make_random_ex; /*!<           . */

    void * pOuter; /*     DRBG,    */
} RND_CONTEXT, *LPRND_CONTEXT;

/*   SetLastError/GetLastError */
void	rSetLastError	(pCP_CALL_CTX pCallCtx, DWORD err);
DWORD	rGetLastError	(pCP_CALL_CTX pCallCtx) ATTR_USERES;

#ifdef _CRTDBG_MAP_ALLOC
#define rAllocMemory(pCallCtx,dwSize,dwMemPoolId) (pCallCtx, dwMemPoolId,calloc(dwSize, 1))
#define rFreeMemory(pCallCtx,pMem,dwMemPoolId)  (pCallCtx, dwMemPoolId,free(pMem))
#else
/*   AllocMemory/FreeMemory */
LPVOID	rAllocMemory	(pCP_CALL_CTX pCallCtx, size_t dwSize, DWORD dwMemPoolId) ATTR_USERES;
void	rFreeMemory	(pCP_CALL_CTX pCallCtx, VOID *pMem, DWORD dwMemPoolId);
#endif

/*!   */
BOOL	rInitMemory	(pCP_CALL_CTX pCallCtx) ATTR_USERES;

#if !defined UNIX
/*!    */
void	rDoneMemory	(pCP_CALL_CTX pCallCtx);
#endif /* !UNIX */
/*!    */
void	rValidateMemory	(pCP_CALL_CTX pCallCtx);

void	rInitCallCtx	(pCP_CALL_CTX pCallCtx, LPCRYPT_CSP hCSP);


#define	 ROOT_PRSG_CRITICAL_ERROR	   1

struct _CP_CALL_CTX_
{
    LPCRYPT_CSP			hCSP;
    LPCRYPT_CSP_THREAD		hCSPthread; // ,       hCSP  hCSPthread
    LPRND_CONTEXT		ThreadPRSG; //        MakeRandom
    DWORD			dwError;
    DWORD			dwThreadId;
    DWORD			dwCommonKArrayLength;
    BYTE                       *pbCommonKArray; 
    BOOL			bOwnFPU;
    int				iCntFPU;
    DWORD			dwFPUOpType;
    DWORD			dwCriticalErrorFlags;

    struct cp_vtb_28147_89     *pVTB;
    CP_ASTACK		       *pAStk;
};


#ifdef __cplusplus
}
#endif

#endif /* CALLCTX_H_INCLUDED */
