/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
#ifdef _WIN32
    #pragma setlocale("rus")
#endif
/*
 * Copyright(C) 2013  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */
/*!
 * \brief   TLS  
 */

#ifndef __KTLS_h__
#define __KTLS_h__

#if !defined(_MSC_VER)
    #include "common.h"
    #include "CSP_WinDef.h"
    #include "ntstatus.h"
    typedef ULONG NTSTATUS;
#endif

#include "wincspc.h"
#include "CSP_Sspi.h"
#include "ipsec/include/sadb.h"
/*! \defgroup ProKTLS     TLS  
  \ingroup ProUKTLS
  \note        Linux-
*/


/*!   
*\ingroup ProKTLS */
typedef void CAPI_EXTC
KTLSLogDecl(void *pUfnAgr, 
	   log_severity_t severity, unsigned uFlags, 
	   const char *fmt, ...);

/*!      
*\ingroup ProKTLS */
typedef void CAPI_EXTC
KTLSSetLogLvlDecl(void *pUfnAgr, log_severity_t severity, unsigned uFlags);

/*!        ktls_gost_handle 
*\ingroup ProKTLS */
typedef struct ktls_gost_in_st {
    void             *pUfnArg;
    /*!< \brief    .*/
    KTLSLogDecl	     *LogUfn;
    /*!< \brief   ,   0.*/
    KTLSSetLogLvlDecl *SetLogLvlUfn;
    /*!< \brief   ,    #LogUfn.*/
    unsigned         allocatedMem;
    /*!< \brief    ktls_gost_handle  (  requiredMem  #ktls_gost_out_st).*/
    void*            reserved[4];
    /*!< \brief ,  ,  .*/
    LPCPC_CONFIG pConfig;/*!<   ,      */
    HCRYPTMODULE hCSP;/*!<   ,     TLS */
} ktls_gost_in;

/*!        ktls_gost_handle 
*\ingroup ProKTLS */
typedef struct ktls_gost_out_st {
    unsigned requiredMem;
    /*!< \brief   ktls_gost_handle  .*/
   void*    reserved[7];
    /*!< \brief ,  ,  .*/
} ktls_gost_out;


/*!      
\ingroup ProKTLS*/
typedef struct 
{
    int dummy;
} *CPKTLS_HANDLE; 

/*!  TLS  
* \ingroup ProKTLS
*/
typedef struct _CPKTLS_vtbl_ CPKTLS_VTBL, * ktls_gost_handle;

/*! \ingroup ProKTLS
*   
*/
#define CPKTLS_CONTEXT_EXPORT_TO_USER    (0x10000)
#define CPKTLS_CONTEXT_EXPORT_DELETE_OLD (0x20000)  //    

/*! \ingroup ProKTLS
* \brief  cpktls_init_gost()     TLS  
* \param h [in/out]-    ,       TLS        SADB
* \param in [in] - ,        ( ,   )
* \param uFlags [in] -           0
* \param out [out] - ,     ,    
* \returns     STATUS_SUCCESS
* \retval STATUS_SUCCESS \e   .     h  NULL,   out   ,   .
* \retval STATUS_NO_MEMORY \e     
* \retval STATUS_INTERNAL_ERROR \e     
*/
DWORD CAPI_EXTC cpktls_init_gost(
    ktls_gost_handle h,
    const ktls_gost_in *in,
    unsigned uFlags,
    ktls_gost_out *out
);

/*! \ingroup ProKTLS
* \brief cpktls_shutdown_gosti() -     TLS.
* \param h [in/out] -    TLS
* \param uFlags -  ,    0
* \returns STATUS_SUCCESS
*/
DWORD CAPI_EXTC cpktls_shutdown_gost (
    ktls_gost_handle h,
    unsigned uFlags
);

typedef DWORD CAPI_EXTC ImportContext_t (
    ktls_gost_handle h,
    PSecBuffer pPackedContext, 
    PRIVKEY *hPriv,
    PUBKEY_2012 *hPub,
    unsigned uFlags, 
    CPKTLS_HANDLE *phCtx
);

typedef DWORD CAPI_EXTC ExportContext_t (
    ktls_gost_handle h,
    CPKTLS_HANDLE hCtx,
    PRIVKEY *hPriv,
    PUBKEY_2012 *hPub,
    unsigned uFlags,
    PSecBuffer pPackedContext
);

/*
Seal()
      ,     ,    ( EncryptMessage()  ).
*/
typedef DWORD CAPI_EXTC Seal_t (
    ktls_gost_handle h,
    CPKTLS_HANDLE hCtx,
    IN ULONG fQOP,
    IN OUT PSecBufferDesc Message,
    IN ULONG MessageSeqNo 
);

/*
UnSeal()
  ,               ( DecryptMessage()  ).
*/
typedef DWORD CAPI_EXTC UnSeal_t (
    ktls_gost_handle h,
    CPKTLS_HANDLE hCtx,
    IN OUT PSecBufferDesc Message,
    IN ULONG MessageSeqNo,
    OUT PULONG pfQOP 
);

/*
QueryAttributes()
       ( QueryContextAttributes()  ).
*/
typedef DWORD CAPI_EXTC QueryAttributes_t (
    ktls_gost_handle h,
    CPKTLS_HANDLE hCtx,
    IN ULONG Attribute,
    IN OUT PVOID Buffer
);

/*
CompleteToken()
      ( ApplyControlToken()  ).
*/
typedef DWORD CAPI_EXTC CompleteToken_t (
    ktls_gost_handle h,
    CPKTLS_HANDLE hCtx,
    IN PSecBufferDesc Token
);

/*
   ,     ( DeleteSecurityContext()  ).
*/
typedef DWORD CAPI_EXTC DeleteContext_t (
    ktls_gost_handle h,
    unsigned uFlags,
    CPKTLS_HANDLE hCtx
);
/*! \ingroup ProKTLS 
 * \brief ,     TLS      SADB
*/
struct _CPKTLS_vtbl_
{
    ImportContext_t * ImportContext; /*!<   #ImportContext */
    ExportContext_t * ExportContext; /*!<   #ExportContext */
    Seal_t * Seal;/*!<   #Seal */ 
    UnSeal_t * UnSeal;/*!<   #UnSeal */ 
    QueryAttributes_t * QueryAttributes;/*!<   #QueryAttributes */ 
    CompleteToken_t * CompleteToken;/*!<   #CompleteToken */ 
    DeleteContext_t * DeleteContext;/*!<   #DeleteContext */ 
    GEN_SADB tlsdb; /*!<   SADB */
};

#endif
