/*
 * Copyright (C) 1997-2003 by Objective Systems, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by Objective Systems, Inc.
 *
 * PROPRIETARY NOTICE
 *
 * This software is an unpublished work subject to a confidentiality agreement
 * and is protected by copyright and trade secret law.  Unauthorized copying,
 * redistribution or other use of this work is prohibited.
 *
 * The above notice of copyright on this source code product does not indicate
 * any actual or intended publication of such source code.
 *
 *****************************************************************************/
/*
// CHANGE LOG
// Date         Init    Description
// 04/24/02     ED      Added XD_ macros 
// 09/07/02     ED      Added XD_CHKEND macro
// 09/15/02     AB      XD_CHKEND macro renamed to XD_CHKBUFEND; 
//                      added some more macros
//
////////////////////////////////////////////////////////////////////////////
*/
/* asn1intl.h - ASN.1 runtime internal definitions */
/**
 * @file asn1intl.h
 */

#ifndef _ASN1INTL_H_
#define _ASN1INTL_H_

#ifndef _COMPACT
#define LOG_ASN1ERR(ctxt,stat) \
   rtErrSetData(&ctxt->errInfo,stat,__FILE__,__LINE__)

#define ASN1_PRINT_OCTSTR(os) \
printf ("%-*.*s", os.numocts, os.numocts, os.data)

#else /* _COMPACT */
#undef _TRACE
#define LOG_ASN1ERR(ctxt,stat) rtErrSetData(&ctxt->errInfo,stat,0,0)
#define ASN1_PRINT_OCTSTR(os)
#endif /* _COMPACT */

#endif /* _ASN1INTL_H_ */
