#ifndef CPP_ENROLL_CSP_INFORMATION_OBJECT_H_
#define CPP_ENROLL_CSP_INFORMATION_OBJECT_H_

#include "cppcades.h"
#include "CPPEnrollEnumerations.h"
#include "CPPEnrollCollections.h"

using namespace ATL;

namespace CryptoPro {
namespace PKI {
namespace Enroll {

class CPPEnrollCspAlgorithms;
class CPPEnrollReaders;
class CPPEnrollReaderModes;
class CPPEnrollContainers;

class CPPEnrollCspInformation
{
public:
    CPPEnrollCspInformation(void);
    ~CPPEnrollCspInformation(void);
    HRESULT InitializeFromName(CAtlString& strName);
    HRESULT get_CspAlgorithms(boost::shared_ptr<CPPEnrollCspAlgorithms>& pVal);
    HRESULT get_KeySpec(X509KeySpec* pVal);
    HRESULT get_Readers(boost::shared_ptr<CPPEnrollReaders>& pVal);
    HRESULT get_LegacyCsp(bool* pVal);
    HRESULT get_Name(CAtlString& pVal);
    HRESULT get_Type(X509ProviderType* pVal);
    HRESULT GetReaderModes(DWORD dwFlags, boost::shared_ptr<CPPEnrollReaderModes>& pVal);
    HRESULT EnumContainers(boost::shared_ptr<CPPEnrollContainers>& pVal);

    // internal only
    HRESULT Initialize(LPCTSTR szProvName, DWORD dwProvType);
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollCspInformation);
    void CheckInitialized();
    HRESULT InitializeInternal(LPCTSTR szProvName, DWORD dwProvType);
    HRESULT FillCspAlgorithmsInfo(DWORD dwIncrementalLength);
    CCryptProvEx m_hProv;
    boost::shared_ptr<CPPEnrollCspAlgorithms> m_pAlgorithms;
    X509KeySpec m_keySpec;
    bool m_bLegacyCsp;
    CAtlString m_provName;
    X509ProviderType m_provType;
};

} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_CSP_INFORMATION_OBJECT_H_
