#ifndef CPP_ENROLL_CSP_ALGORITHM_OBJECT_H_
#define CPP_ENROLL_CSP_ALGORITHM_OBJECT_H_

#include "cppcades.h"
#include "CPPEnrollEnumerations.h"
#include "CPPEnrollObjectId.h"

using namespace ATL;

namespace CryptoPro {
namespace PKI {
namespace Enroll {

class CPPEnrollCspAlgorithm
{
public:
    CPPEnrollCspAlgorithm(void);
    ~CPPEnrollCspAlgorithm(void);
    HRESULT GetAlgorithmOid(DWORD Length, AlgorithmFlags AlgFlags,
        boost::shared_ptr<CPPEnrollObjectId>& pObjectId);
    HRESULT get_DefaultLength(DWORD* pVal);
    HRESULT get_IncrementLength(DWORD* pVal);
    HRESULT get_MaxLength(DWORD* pVal);
    HRESULT get_MinLength(DWORD* pVal);
    HRESULT get_Name(CAtlString& AlgorithmName);
    //      CNG-
    HRESULT get_Operations(AlgorithmOperationFlags* pVal);
    HRESULT get_Type(AlgorithmType* pVal);
    // internal only
    HRESULT Initialize(PROV_ENUMALGS_EX* pProvEnumAlgs, DWORD dwIncrementLength);
    void CheckInitialized();
    HRESULT GetObjectId(boost::shared_ptr<CPPEnrollObjectId>& pObjectId);
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollCspAlgorithm);
    bool m_bInitialized;
    DWORD m_dwDefaultLength;
    DWORD m_dwIncrementLength;
    DWORD m_dwMaxLength;
    DWORD m_dwMinLength;
    CAtlString m_strAlgorithmName;
    boost::shared_ptr<CPPEnrollObjectId> m_pObjectId;
    AlgorithmOperationFlags m_operations;
    AlgorithmType m_type;
};

} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_CSP_ALGORITHM_OBJECT_H_
