#ifndef CPP_ENROLL_ALTERNATIVE_NAME_OBJECT_H_
#define CPP_ENROLL_ALTERNATIVE_NAME_OBJECT_H_

#include "cppcades.h"
#include "CPPEnrollEnumerations.h"
#include "CPPEnrollObjectId.h"
#include "CPPEnrollCollections.h"
#include <atlcrypt2.h>

using namespace ATL;
namespace CryptoPro {
namespace PKI {
namespace Enroll {

class CPPEnrollAlternativeName
{
public:
    CPPEnrollAlternativeName(void);
    ~CPPEnrollAlternativeName(void);
    HRESULT InitializeFromOtherName(
        boost::shared_ptr<CPPEnrollObjectId>& pObjectId, 
        EncodingType Encoding,
        CAtlStringW sRawData,
        bool bToBeWrapped);

    HRESULT get_ObjectId(boost::shared_ptr<CPPEnrollObjectId>& pObjectId);

    HRESULT get_Value(CBlob& pVal);

private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollAlternativeName);
    boost::shared_ptr<CPPEnrollObjectId> m_pOid;
    // CAtlString m_sData;
    CStringBlob m_value;
};

} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_ALTERNATIVE_NAME_OBJECT_H_
