#ifndef CPPCADES_PERSONAL_CARDHOLDER_DATA_H_
#define CPPCADES_PERSONAL_CARDHOLDER_DATA_H_
#include "cppcades.h"
#include "CPPCadesIdentityCard.h"
#include "UECInternal.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesPersonalCardholderDataObject
{
public:
    CPPCadesPersonalCardholderDataObject();
    ~CPPCadesPersonalCardholderDataObject();

    HRESULT set_Address(const CAtlString& newVal);
    HRESULT get_Address(CAtlString& pVal);
    HRESULT set_PhoneNumber(const CAtlString& newVal);
    HRESULT get_PhoneNumber(CAtlString& pVal);
    HRESULT set_Email(const CAtlString& newVal);
    HRESULT get_Email(CAtlString& pVal);
    HRESULT set_IndividualTaxpayerNumber(const CAtlString& newVal);
    HRESULT get_IndividualTaxpayerNumber(CAtlString& pVal);
    HRESULT set_DrivingLicenseNumber(const CAtlString& newVal);
    HRESULT get_DrivingLicenseNumber(CAtlString& pVal);
    HRESULT set_VehicleRegistrationCertificate(const CAtlString& newVal);
    HRESULT get_VehicleRegistrationCertificate(CAtlString& pVal);
    HRESULT get_IdentityCard(boost::shared_ptr<CPPCadesIdentityCardObject>& pVal);
    HRESULT Submit();
    HRESULT ResetAllData();

    // internal use
    HRESULT InitFromEncodedData(const ATL2::CStringBlob& encData, bool isTrusted,
        ATL2::CCryptProvEx& cryptProv);
    HRESULT Clear();
private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesPersonalCardholderDataObject);
    ATL2::CCryptProvEx m_cryptProv;
    bool m_isTrusted;

    PERSONAL_DATA m_data;
    boost::shared_ptr<CPPCadesIdentityCardObject> m_pIdentityCard;

};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif //CPPCADES_PERSONAL_CARDHOLDER_DATA_H_
