#ifndef CPPCADES_OMS_DATA_H_
#define CPPCADES_OMS_DATA_H_
#include "cppcades.h"
#include "CPPCadesIdentityCard.h"
#include "UECInternal.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesOMSDataObject
{
public:
    CPPCadesOMSDataObject();
    ~CPPCadesOMSDataObject();

    HRESULT get_OGRN(CAtlString& pVal);
    HRESULT get_OKATO(CAtlString& pVal);
    HRESULT get_EffectiveDate(CAtlString& pVal);
    HRESULT get_ExpirationDate(CAtlString& pVal);

    // internal use
    HRESULT InitFromEncodedData(const CStringBlob& encData);
    HRESULT Clear();
private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesOMSDataObject);
    OMS_DATA m_data;
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif //CPPCADES_OMS_DATA_H_

