#ifndef CPPCADES_CP_ENVELOPEDDATA_OBJECT_H_
#define CPPCADES_CP_ENVELOPEDDATA_OBJECT_H_

#include "cppcades.h"
#include "CPPCadesCPAlgorithm.h"
#include "CPPCadesCPCertificate.h"
#include "CPPCadesCollections.h"
#include "CPPCadesContent.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPEnvelopedDataObject
{
public:
    CPPCadesCPEnvelopedDataObject(void);
    ~CPPCadesCPEnvelopedDataObject(void);

#ifndef UNIX
    HRESULT put_Content(const BSTR pVal);
    HRESULT get_Content(CComBSTR& pVal);
#endif // UNIX

    HRESULT put_Content(LPCSTR pbData, DWORD cbData);
    HRESULT get_Content(CStringBlob& pVal);

    HRESULT put_ContentEncoding(CADESCOM_CONTENT_ENCODING_TYPE EncodingType);
    HRESULT get_ContentEncoding(CADESCOM_CONTENT_ENCODING_TYPE* pVal);

    HRESULT get_Algorithm(boost::shared_ptr<CPPCadesCPAlgorithmObject>& pVal);
    HRESULT get_Recipients(boost::shared_ptr<CPPCadesCPRecipientsObject>& pVal);
    HRESULT Encrypt(CAPICOM_ENCODING_TYPE EncodingType, CBlob& pVal);
    HRESULT Decrypt(const CBlob& EncryptedMessage);
    HRESULT StreamEncrypt(const char *pbData, unsigned long cbData, BOOL isFinal, CBlob &retval);
    HRESULT StreamDecrypt(const char *pbData, unsigned long cbData, BOOL isFinal, CBlob &retval);

    //internal use

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPEnvelopedDataObject);
    //   EnvelopedData    
    void ResetState();

    boost::shared_ptr<CPPCadesCPRecipientsObject> m_pRecipients;
    boost::shared_ptr<CPPCadesCPAlgorithmObject> m_pAlg;
    CCadesContent m_content;
    CCryptProv m_Prov;
    HCRYPTMSG m_hMsg; 
    CBlob m_stream_buf;
    BOOL m_bDecrypt_started;
};
} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_ENVELOPEDDATA_OBJECT_H_

