#ifndef CPPCADES_CP_ENCODEDDATA_OBJECT_H_
#define CPPCADES_CP_ENCODEDDATA_OBJECT_H_

#include "cppcades.h"
#include "cplib/Blob.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPEncodedDataObject
{
public:
    CPPCadesCPEncodedDataObject(void);
    ~CPPCadesCPEncodedDataObject(void);

    HRESULT Format(BOOL bMultiLines, CAtlStringW& pVal);
    HRESULT Decoder(void** pVal);
    HRESULT get_Value(CAPICOM_ENCODING_TYPE EncodingType, CBlob& pVal);

    //internal use
    HRESULT put_encBlob(const CBlob& pVal);
    HRESULT put_OID(CAtlStringA pVal); //   CryptFormatObject

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPEncodedDataObject);

    CAtlStringA m_OID;
    CBlob m_value;
};
} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_ENCODEDDATA_OBJECT_H_

