#ifndef CPPCADES_CP_BASICCONSTRAINTS_OBJECT_H_
#define CPPCADES_CP_BASICCONSTRAINTS_OBJECT_H_

#include "cppcades.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPBasicConstraintsObject
{
public:
    CPPCadesCPBasicConstraintsObject(void);
    ~CPPCadesCPBasicConstraintsObject(void);

    HRESULT get_IsPresent(BOOL *pVal);
    HRESULT put_IsPresent(BOOL pVal);
    HRESULT get_IsCritical(BOOL *pVal);
    HRESULT put_IsCritical(BOOL pVal);
    HRESULT get_IsCertificateAuthority(BOOL *pVal);
    HRESULT get_IsPathLenConstraintPresent(BOOL *pVal);
    HRESULT get_PathLenConstraint(DWORD *pVal);
        
    // Internal use
    HRESULT put_IsCertificateAuthority(BOOL pVal);
    HRESULT put_IsPathLenConstraintPresent(BOOL pVal);
    HRESULT put_PathLenConstraint(DWORD pVal);

    void clear();

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPBasicConstraintsObject);

    DWORD m_pathLen;
    BOOL m_isPresent;
    BOOL m_isCritical;
    BOOL m_isCA;
    BOOL m_isPathLenPresent;
};
} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_BASICCONSTRAINTS_OBJECT_H_


