#ifndef CPPCADESCPATTRIBUTE_H_
#define CPPCADESCPATTRIBUTE_H_
#include "cppcades.h"
#include "CPPCadesCPOID.h"
#include "cplib/Blob.h"
#include "cplib/DateTime.h"
#include <vector>

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPAttributeObject
{
public:
    CPPCadesCPAttributeObject();
    CPPCadesCPAttributeObject(PCRYPT_ATTRIBUTE pAttr);
    ~CPPCadesCPAttributeObject();

    HRESULT put_OID(CAtlStringA newVal);
    HRESULT get_OID(boost::shared_ptr<CPPCadesCPOIDObject>& pVal);

    HRESULT put_Value(CBlob pVal);
    HRESULT get_Value(CBlob& pVal);

    HRESULT put_Name(CADESCOM_ATTRIBUTE name);
    HRESULT get_Name(CADESCOM_ATTRIBUTE* pName);

    HRESULT put_ValueEncoding(CAPICOM_ENCODING_TYPE EncodingType);
    HRESULT get_ValueEncoding(CAPICOM_ENCODING_TYPE* pEncodingType);

    //internal use
    PCCRYPT_ATTRIBUTE get_CryptAttributeStruct();
    HRESULT put_DateTimeValue(const CryptoPro::CDateTime& value);
private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPAttributeObject);
    CAPICOM_ENCODING_TYPE m_encodingType;
#pragma warning(push)
#pragma warning(disable: 4251)
    boost::shared_ptr<CPPCadesCPOIDObject> m_pOID;
    std::vector<CBlob> m_values;
    std::vector<CRYPT_ATTR_BLOB> m_cryptAttrValues;
#pragma warning(pop)
    CRYPT_ATTRIBUTE m_pAttr;
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif //CPPCADESCPATTRIBUTE_H_
