/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 138236 $
 * \date $Date:: 2016-05-11 12:17:11 +0300#$
 * \author $Author: dim $
 *
 * \brief   
 *
 * :   (HVIS).
 */

#include "hvis_prj.h" 
#include "visualizer.h"


/*    .
SCARD_W_CANCELLED_BY_USER -    .
ERROR_SUCCESS -  .
ERROR_UNSUPPORTED_TYPE -     .
   .
*/
DWORD hvis_ask_user(const TSupSysEContext *context, BOOL silent_context, PHS_SIGNING_DATA signing_data, PHS_ADDITIONAL_DATA additional_data) 
{
    THvisAskInfo info;
    if (context == NULL)
	return (DWORD)ERROR_INVALID_PARAMETER;
    info.silent = silent_context;
    info.additional_data = additional_data;
    info.signing_data = signing_data;
    return supsys_call(context, HASHVIS_FUN_ASK, (TSupSysInfo*)&info);
}

/*!
* \ingroup hvis_error_fun
* \brief   parent HWND.
* \param context [in]  .
* \param hwnd [in] parent HWND.
* \retval ERROR_SUCCESS HWND    HWND  .
* \retval " " \ret hvis_err_code
*/
DWORD hvis_init_ctx(const TSupSysEContext *context, HWND hwnd, char * utf8header, WORD language, char * utf8contname)
{
    DWORD code;
    THVisFunInit init_st;
    SUPSYS_PRE(context);

    init_st.header = utf8header;
    init_st.language = language;
    init_st.parent = hwnd;
    init_st.name = utf8contname;

    code = supsys_call(context, HASHVIS_FUN_INIT, (TSupSysInfo*)&init_st);
    if (code == (DWORD)ERROR_NOT_SUPPORTED)
	code = ERROR_SUCCESS;
    return code;
}
