#ifndef OS_SPECIFIC_INCLUDED
#define OS_SPECIFIC_INCLUDED
#include  "reader.kit/sup_sys.h"
#ifdef __cplusplus
extern "C" {
#endif //__cplusplus
    typedef  void* TGenericMutex;

    //behaves like GetLogicalDriveStrings on windows. 
    //buffer is sequence of null-terminated strings plus additional null-terminator.
    DWORD get_usb_labels(const TCHAR* path_to_item, TCHAR* buffer, size_t* buffer_len);

    DWORD get_path_by_label(const TCHAR* path_to_item, const TCHAR* uuid, TCHAR** out_path);
    DWORD open_named_mutex(const TCHAR* mutex_name, TGenericMutex* mutex);
    DWORD delete_mutex(TGenericMutex mutex);
    DWORD lock_mutex(TGenericMutex mutex);
    DWORD unlock_mutex(TGenericMutex mutex);
    BOOL is_dir(const TCHAR* path);
    DWORD config_get_string(const TCHAR *path, size_t *plen, TCHAR *val);

#ifdef __cplusplus
}
#endif //__cplusplus
#endif //OS_SPECIFIC_INCLUDED
