/*
 * Copyright(C) 2002-2011  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

#include "fat12prj.h"
#include <unistd.h>

/*++++
 * Lock function
 ++++*/
DWORD fat12_lock( 
    TSupSysContext *context, 
    TSupSysInfo *info )
{
  TFat12Context *ctx = (TFat12Context*)context;
  UNUSED(info);

  SUPSYS_PRE_CONTEXT( context, TFat12Context );

  if (!ctx->locked)
  {
    if(lock_mutex(ctx->lock))
	return (DWORD)SCARD_W_CANCELLED_BY_USER;
    ctx->locked = TRUE;
  }
  return ERROR_SUCCESS;
}

/*++++
 * Unlock function
 ++++*/
DWORD fat12_unlock( 
    TSupSysContext *context, 
    TSupSysInfo *info )
{
  TFat12Context *ctx = (TFat12Context*)context;

  UNUSED(info);
  SUPSYS_PRE_CONTEXT( context, TFat12Context );
  
  if (ctx->locked)
  {
    ctx->locked = FALSE;
    unlock_mutex(ctx->lock);
  }
  return ERROR_SUCCESS;
}
