/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/****
 * $Id: f12klen.c 206422 2020-02-10 13:50:43Z frolov $
 *
 *       (READER).
 *
 *   /      (FAT12).
 *
 *   /      .
 *    .
 *
 * : fat12_length
 ****/

#include "fat12prj.h" /*+ Project (READER/FAT12) include.
     include    (READER/FAT12). +*/

/*++++
 *    .
 ++++*/
DWORD fat12_length(
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    TReaderInfoLength *inf = (TReaderInfoLength*)info;
    TFat12Context *ctx = (TFat12Context*)context;
#ifndef UNIX
    BY_HANDLE_FILE_INFORMATION finfo;
#endif /* UNIX */

    SUPSYS_PRE_CONTEXT( context, TFat12Context );
    SUPSYS_PRE_INFO( info, TReaderInfoLength );

#ifdef UNIX
    if( fseek( ctx->handle, 0, SEEK_END ) )
	return fat12_os_error();
    *inf = (size_t)ftell( ctx->handle );
    if( *inf == (size_t)-1 )
	return fat12_os_error();
#else /* UNIX */
    if( !GetFileInformationByHandle( ctx->handle, &finfo ) )
	return fat12_os_error();
    *inf = (size_t)finfo.nFileSizeLow;
    if( finfo.nFileSizeHigh )
	*inf = (size_t)-1;
#endif /* UNIX */
    return ERROR_SUCCESS;
}

DWORD fat12_free_space(
    TSupSysContext *context,
    TSupSysInfo *info
) {
    size_t* free_space = (size_t*) info;
    SUPSYS_PRE_CONTEXT(context, TFat12Context);
    SUPSYS_PRE_INFO(info, size_t);
    *free_space = (size_t)-1;
    return ERROR_SUCCESS;
}
