#!/bin/sh
PATH="`getconf PATH`":"$PATH"
poname=`basename $1`
test -z "$GENCAT" && GENCAT=/usr/bin/gencat
test -z "$ICONV" && ICONV=/usr/bin/iconv
test -z "$COPYEX_DIR" && COPYEX_DIR=/opt/cprocsp/src/rdk/copyex
(
$GENCAT ${poname}.cat ${1}.msg && \
$ICONV -f cp1251 -t utf-8 <${1}_cp1251.msg > ${poname}_utf-8.msg
) || exit $?

for encoding in koi8-r iso8859-5 cp866; do
    $ICONV -f utf-8 -t $encoding <${poname}_utf-8.msg > "${poname}_${encoding}.msg" || exit $?
done

(
LANG=ru_RU.cp1251 LC_ALL=ru_RU.cp1251 $GENCAT ${poname}_cp1251.cat ${1}_cp1251.msg                2>&1 | grep -v "invalid character: message ignored"
LANG=ru_RU.koi8r LC_ALL=ru_RU.koi8r $GENCAT ${poname}_koi8-r.cat ${poname}_koi8-r.msg             2>&1 | grep -v "invalid character: message ignored"
LANG=ru_RU.cp866 LC_ALL=ru_RU.cp866 $GENCAT ${poname}_cp866.cat ${poname}_cp866.msg               2>&1 | grep -v "invalid character: message ignored"
LANG=ru_RU.iso88595 LC_ALL=ru_RU.iso88595 $GENCAT ${poname}_iso8859-5.cat ${poname}_iso8859-5.msg 2>&1 | grep -v "invalid character: message ignored"
LANG=ru_RU.utf8 LC_ALL=ru_RU.utf8 $GENCAT ${poname}_utf-8.cat ${poname}_utf-8.msg                 2>&1 | grep -v "invalid character: message ignored"
) # expected errs
exit 0 # to avoid retcode from grep
