/*
* Copyright(C) 2000-2014
*
*    , 
*   .
*
*  ,    , 
*         
*   .
*
*     
*     .
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef _WIN32
#   include <windows.h>
#   include <wincrypt.h>
#else
#   include <stdlib.h>
#   include <CSP_WinDef.h>
#   include <CSP_WinCrypt.h>
#endif
#include <WinCryptEx.h>

//   (    ,   
//    )
//-------------------------------------------------------------------------------------------------------------
//       PRFKEYMAT (CALG_GR3411_PRFKEYMAT, 
// CALG_GR3411_2012_256_PRFKEYMAT  CALG_GR3411_2012_512_PRFKEYMAT)   
//    ,      CALG_G28147  CALG_SYMMETRIC_512.
//       CALG_GR3412_2015_M  CALG_GR3412_2015_K.
//-------------------------------------------------------------------------------------------------------------



static void HandleError(const char *s);

int main() {

    //------------------------------------------------------------------------
    //  .

    HCRYPTPROV hProv = 0;
    HCRYPTKEY hPrfKey = 0;
    HCRYPTHASH hPrfHash = 0;

    CRYPT_DATA_BLOB prfSeedBlob;
    BYTE pbPrfSeedData[] = { 0x11, 0x22, 0x33, 0x44 };

    BYTE pbDataFirst[10];
    DWORD cbDataFirst = 0;

    HCRYPTKEY hDerivedKey256 = 0;
    
    BYTE pbDataSecond[100];
    DWORD cbDataSecond = 0;

    HCRYPTKEY hDerivedKey512 = 0;
    

    //------------------------------------------------------------------------
    //     .

    if(CryptAcquireContext(
	&hProv, 
	NULL, 
	NULL, 
	PROV_GOST_2012_256, 
	CRYPT_VERIFYCONTEXT)) 
    {
	printf("CSP context acquired.\n");
    }
    else
    {
	HandleError("Error during CryptAcquireContext.");
    }

    //------------------------------------------------------------------------
    //    PRF.

    if(CryptGenKey(     
	hProv,      
	CALG_G28147,      
	0, 
	&hPrfKey))
    {   
	printf("PRF key is created. \n");
    }
    else
    {
	HandleError("Error during CryptGenKey.");
    }

    //------------------------------------------------------------------------
    //    PRF.

    if(CryptCreateHash(
	hProv,
	CALG_GR3411_2012_256_PRFKEYMAT,
	hPrfKey,
	0,
	&hPrfHash))
    {
	printf("PRF hash is created. \n");
    }
    else
    {
	HandleError("Error during CryptCreateHash.");
    }

    //------------------------------------------------------------------------
    //  seed  PRF.

    prfSeedBlob.pbData = pbPrfSeedData;
    prfSeedBlob.cbData = sizeof(pbPrfSeedData);

    if(CryptSetHashParam(
	hPrfHash,
	HP_PRFKEYMAT_SEED,
	(LPBYTE)&prfSeedBlob,
	0))
    {
	printf("PRF seed is set. \n");
    }
    else
    {
	HandleError("Error during CryptSetHashParam.");
    }

    //------------------------------------------------------------------------
    //     .

    cbDataFirst = sizeof(pbDataFirst);

    if(CryptGetHashParam(
	hPrfHash,
	HP_HASHVAL,
	pbDataFirst,
	&cbDataFirst,
	0))
    {
	printf("First part of data produced. \n");
    }
    else
    {
	HandleError("Error during CryptGetHashParam.");
    }

    //------------------------------------------------------------------------
    //   256 .

    if(CryptDeriveKey(
	hProv,
	CALG_G28147,
	hPrfHash,
	0,
	&hDerivedKey256))
    {
	printf("256-bit key derived. \n");
    }
    else
    {
	HandleError("Error during CryptDeriveKey.");
    }

    //------------------------------------------------------------------------
    //      .

    cbDataSecond = sizeof(pbDataSecond);

    if(CryptGetHashParam(
	hPrfHash,
	HP_HASHVAL,
	pbDataSecond,
	&cbDataSecond,
	0))
    {
	printf("Second part of data produced. \n");
    }
    else
    {
	HandleError("Error during CryptGetHashParam.");
    }

    //------------------------------------------------------------------------
    //   512 .

    if(CryptDeriveKey(
	hProv,
	CALG_SYMMETRIC_512,
	hPrfHash,
	0,
	&hDerivedKey512))
    {
	printf("512-bit key derived. \n");
    }
    else
    {
	HandleError("Error during CryptDeriveKey.");
    }

    //------------------------------------------------------------------------
    //  .

    if (hDerivedKey256) {
	CryptDestroyKey(hDerivedKey256);
    }

    if (hDerivedKey512) {
	CryptDestroyKey(hDerivedKey512);
    }

    if (hPrfHash) {
	CryptDestroyHash(hPrfHash);
    }

    if (hPrfKey) {
	CryptDestroyKey(hPrfKey);
    }

    if (hProv) {
	CryptReleaseContext(hProv, 0);
    }

    return 0;
}



//  
// (    ,   
//     )

//       HandleError,  
//   ,         
//   (stderr)    . 
//         , 
//        .

static void HandleError(const char *s) {
    fprintf(stderr, "An error occurred in running the program. \n");
    fprintf(stderr, "%s\n", s);
    fprintf(stderr, "Error number %x.\n", GetLastError());
    fprintf(stderr, "Program terminating. \n");
    exit(1);
}
