/*
 * Copyright(C) 2010 -, 
 *
 *    , 
 *   -.
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *     -.
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 127051 $
 * \date $Date:: 2015-09-09 15:08:20 +0300#$
 * \author $Author: pav $
 *
 * \brief      POSIX <sys/stat.h>
 *
 */

#ifndef sup_sys_stat_h_
#define sup_sys_stat_h_

#ifdef UNIX
#ifdef __cplusplus
extern "C" {
#endif
    #include <sys/stat.h>

    #include "reader/support.h"
    #include "reader/sup_errno.h"
    #include "reader/sup_signal_safe.h"

    SUPPORT_ACTUAL_NOSIG(int, /* No prefix, see C99, 6.10.3, Exmpl. 5 */,
		chmod, (const char *path, mode_t mode),
		(path, mode),
		0 == ret,
		(EET_FTEXT(EET_db_ctx, "%s(%s, 0%o) = %d fail %s(%d)"),
		SFUNC, 
		path, (int)mode,
		ret, SUP_STRERROR(serrno), serrno))
    SUPPORT_ACTUAL_NOSIG(int, 
		_t, mkdir, (const TCHAR *path, mode_t mode),
		(path, mode),
		(0 == (ret) || EEXIST == (serrno)),
		(EET_FTEXT(EET_db_ctx, "%s(%s, 0%o) = %d fail %s(%d)"),
		SFUNC,
		path, (int)mode,
		ret, SUP_STRERROR(serrno), (serrno)))
#ifdef __cplusplus
}
#endif
#endif /* UNIX */
#endif /* sup_sys_stat_h_ */
