/*
 * Copyright(C) 2010 -, 
 *
 *    , 
 *   -.
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *     -.
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 144639 $
 * \date $Date:: 2016-09-05 12:48:30 +0300#$
 * \author $Author: dim $
 *
 * \brief    / 
 *        POSIX sched_yield()
 *
 */

#ifndef sup_sched_h_
#define sup_sched_h_

#ifdef UNIX
    #include <sched.h>
#else
    #include <Windows.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

  /*
   * Linux 2.4.*      
   *         
   *
   * Linux > 2.6.0
   * http://lwn.net/Articles/31462/ [Posted May 7, 2003 by corbet]
   *
   * it moves the process to the "expired" queue,
   * effectively cancelling the rest of the process's time slice.
   * So a process calling sched_yield() now must wait until
   * all other runnable processes in the system have used up
   * their time slices before it will get the processor again.
   *
   * ,     srv_thread_exception.cpp?
   *
   *     PKCS11  2012
   *   sched_yield()    
   *
   * Windows
   * ...   ...
  */
#if !defined UNIX
    #define support_yield()	((void)SwitchToThread())
#else
    #define support_yield()	((void)sched_yield())
#endif

#ifdef __cplusplus
}
#endif
#endif /* sup_sched_h_ */
