/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
#ifdef _WIN32
    #pragma setlocale("rus")
#endif
/*
 * Copyright(C) 2013  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */
/*!
 * \brief     TLS   
 *          .
 */

#ifndef __UTLS_h__
#define __UTLS_h__

#if !defined(_MSC_VER)
    #include "common.h"
    #include "CSP_WinDef.h"
    #include "ntstatus.h"
    typedef ULONG NTSTATUS;
#endif

#include "wincspc.h"
#include "CSP_Sspi.h"
#include "ipsec/include/sadb.h"
/*! \defgroup ProUKTLS       TLS     
* \ingroup ProSSPSSPI
*    ,      
*       
*/
/*! \defgroup ProUTLS      
  \ingroup ProUKTLS
*/
/*! \struct utlsdb_token
* \ingroup ProUTLS
* \brief    
*/
typedef struct
{
    PRIVKEY Priv; /*!< \brief    */
    PUBKEY_2012 Pub; /*!< \brief    */
} utlsdb_token;

/*! \ingroup ProUTLS
* \brief       SADB  SSPI
*/
typedef struct _CPUTLS_vtbl_ CPUTLS_VTBL, * utls_gost_handle;
/*! \struct _CPUTLS_vtbl_
* \ingroup ProUTLS
* \brief ,         SSPI
*/
struct _CPUTLS_vtbl_
{
    GEN_SADB tlsdb; /*!< \brief   SADB */
    PSecurityFunctionTable pSSPI; /*!< \brief   SSPI */
};

/*! \ingroup ProUTLS
* \brief  utls_gost_in,       utls_gost_handle
*/
typedef struct utls_gost_in_st {
   unsigned         allocatedMem;
    /*!< \brief    utls_gost_handle  (  requiredMem  #utls_gost_out_st).*/
    void*            reserved[7];
    /*!< \brief ,  ,  .*/
} utls_gost_in;

/*! \struct utls_gost_out_st
* \ingroup ProUTLS
* \brief  utls_gost_out,       utls_gost_handle
*/

typedef struct utls_gost_out_st {
    unsigned requiredMem;
    /*!< \brief   utls_gost_handle  .*/
   void*    reserved[7];
    /*!< \brief ,  ,  .*/
} utls_gost_out;
/*! \ingroup ProUTLS
* \def CPUTLS_CONTEXT_EXPORT_TO_KERNEL
* \brief      
*/
#define CPUTLS_CONTEXT_EXPORT_TO_KERNEL  (0x1000)   
#define CPUTLS_CONTEXT_EXPORT_RESET_NEW	 (0x2000)   //  master_secret    
#define CPUTLS_CONTEXT_EXPORT_DELETE_OLD (0x4000)   //    
/*! \def CPUTLS_ATTR_CREDENTIAL_HANDLE
* \ingroup ProUTLS
* \brief        Credentials
*/
#define CPUTLS_ATTR_CREDENTIAL_HANDLE	 (0x1001)   
/*! \ingroup ProUTLS
* \brief  cputls_init_gost()     TLS.
* \param h [in/out] -        .
* \param in [in] -    \ref utls_gost_in_st      
* \param uFlags [in] -  ,  
* \param out [out] -    \ref utls_gost_out_st      ,   
* \return    
* \retval STATUS_SUCCESS \e  .   h  NULL   out   ,     
* \retval STATUS_INTERNAL_ERROR \e    
* \retval STATUS_NO_MEMORY \e      
*/
DWORD cputls_init_gost(
    utls_gost_handle h,
    const utls_gost_in *in,
    unsigned uFlags,
    utls_gost_out *out
);

/*! \ingroup ProUTLS
* \brief  cputls_shutdown_gost()   
* \note ,   utls_gost_handle  
* \param h    
* \param uFlags  ,    0
* \returns STATUS_SUCCESS
*/
DWORD cputls_shutdown_gost (
    utls_gost_handle h,
    unsigned uFlags
);
#endif



