#ifndef _SERIALNUMBERPOOL_H_INCLUDED
#define _SERIALNUMBERPOOL_H_INCLUDED

namespace CryptoPro { namespace PKI
{
    template <typename BigIntT, int snLength = 20, int seedLen = 4, int seedOff = 8>
    class ISerialNumberPoolT
    {
    public:
	typedef BigIntT bigIntType;

	virtual const bigIntType& top() const = 0;
	virtual void allocateRange() = 0;
	virtual void lock() = 0;
	virtual void unlock() = 0;

	virtual ~ISerialNumberPoolT() {}

	enum
	{
	    serialNumberLength = snLength,
	    seedLength = seedLen,
	    seedOffset = seedOff
	};
    };

    template <typename IPoolT>
    class CSerialNumberPoolT: public IPoolT
    {
	typedef IPoolT base;
    public:
	inline CSerialNumberPoolT();
	inline CSerialNumberPoolT(
	    const typename base::bigIntType& old,
	    const typename base::bigIntType& seed,
	    const typename base::bigIntType& rangeSize);
	inline void initialize(
	    const typename base::bigIntType& old,
	    const typename base::bigIntType& seed,
	    const typename base::bigIntType& rangeSize);
	inline const typename base::bigIntType& top() const;
	inline void allocateRange();
	virtual inline void lock();
	virtual inline void unlock();
	inline void swap( CSerialNumberPoolT& obj) throw();
    private:
	//         
	CSerialNumberPoolT( const CSerialNumberPoolT&);
	CSerialNumberPoolT& operator=( const CSerialNumberPoolT&);

	typename base::bigIntType top_;
	typename base::bigIntType rangeSize_;
    };

    //   SerialNumberRange -   
    //       .
    //  :      
    //         .  
    //  ,      
    //      . ,   
    //     ,   
    //   .
    // --------------------------------------------------------------
    // SerialNumberRange (  CTSPIsapiWorker)   
    // ISerialNumberPool ( TSPSrvContext). CTSPIsapiWorker 
    //   ISAPIExtension,   [TSPSrvContext]   - 
    // .    ,  SerialNumberRange
    //    ISerialNumberPool   .
    //   ""    :),    
    //      (. jira: CADES-596)
    // ---------------------------------------------------------------
    //    :
    // SerialNumberPool   TSPIsapiExtension,      -
    //     (   EventLog  SrvContext).
    //     ,    ISAPI.
    //     SerialNumberRange   
    // (CIsapiWorker::Initialize      IIsapiExtension)
    //
    template <typename IPoolT>
    class CSerialNumberRangeT
    {
    public:
	inline CSerialNumberRangeT( IPoolT* pool = 0);

	inline void initialize( IPoolT* pool );
	//inline bool ready();
	inline typename IPoolT::bigIntType next();
    private:
	inline void nextRange();

	IPoolT* pool_;
	typename IPoolT::bigIntType nextFreeSerialNumber_;
	typename IPoolT::bigIntType rangeEnd_;
    };
} /* namespace PKI */ } /* namespace CryptoPro */

#include "SerialNumberPool.inl"

#endif // _SERIALNUMBERPOOL_H_INCLUDED
