/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 5.63.
 */
#ifndef PKIXOCSP_H
#define PKIXOCSP_H

#include <stdio.h>
#include <stdlib.h>
#include "asn1BerCppTypes.h"
#include "rtTable.h"
#include "ASN1CGeneralizedTime.h"
#include "ASN1CSeqOfList.h"
#include "CertificateExtensions.h"
#include "PKIX1Explicit88.h"
#include "PKIXCMP.h"
#include "AuthenticationFramework.h"
#include "CryptographicMessageSyntax.h"
#include "PKIX1Explicit88BaseTypes.h"
namespace asn1data {

/**************************************************************/
/*                                                            */
/*  OCSPVersion                                               */
/*                                                            */
/**************************************************************/

struct EXTERN OCSPVersion {
   enum Root {
      v1 = 0,
      v2 = 1
   } ;
} ;

typedef ASN1UINT ASN1T_OCSPVersion;

class EXTERN ASN1C_OCSPVersion :
   public ASN1CType
{
protected:
   ASN1T_OCSPVersion& msgData;
public:
   ASN1C_OCSPVersion (ASN1T_OCSPVersion& data);
   ASN1C_OCSPVersion (
      ASN1MessageBufferIF& msgBuf, ASN1T_OCSPVersion& data);
   ASN1C_OCSPVersion (ASN1C_OCSPVersion& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_OCSPVersion& getCopy (ASN1T_OCSPVersion* pDstData = 0);
   ASN1T_OCSPVersion* newCopy ();

   inline ASN1C_OCSPVersion& operator= (ASN1C_OCSPVersion& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_OCSPVersion (ASN1CTXT* pctxt,
   ASN1T_OCSPVersion *pvalue, ASN1TagType tagging);

EXTERN int asn1D_OCSPVersion (ASN1CTXT* pctxt,
   ASN1T_OCSPVersion *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_OCSPVersion (ASN1CTXT *pctxt, ASN1T_OCSPVersion* pSrcValue, ASN1T_OCSPVersion* pDstValue);

/**************************************************************/
/*                                                            */
/*  OCSPResponseStatus                                        */
/*                                                            */
/**************************************************************/

struct EXTERN OCSPResponseStatus {
   enum Root {
      successful = 0,
      malformedRequest = 1,
      internalError = 2,
      tryLater = 3,
      sigRequired = 5,
      unauthorized = 6,
      badCRL = 8
   } ;
} ;

typedef ASN1UINT ASN1T_OCSPResponseStatus;

class EXTERN ASN1C_OCSPResponseStatus :
   public ASN1CType
{
protected:
   ASN1T_OCSPResponseStatus& msgData;
public:
   ASN1C_OCSPResponseStatus (ASN1T_OCSPResponseStatus& data);
   ASN1C_OCSPResponseStatus (
      ASN1MessageBufferIF& msgBuf, ASN1T_OCSPResponseStatus& data);
   ASN1C_OCSPResponseStatus (ASN1C_OCSPResponseStatus& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_OCSPResponseStatus& getCopy (ASN1T_OCSPResponseStatus* pDstData = 0);
   ASN1T_OCSPResponseStatus* newCopy ();

   inline ASN1C_OCSPResponseStatus& operator= (ASN1C_OCSPResponseStatus& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_OCSPResponseStatus (ASN1CTXT* pctxt,
   ASN1T_OCSPResponseStatus *pvalue, ASN1TagType tagging);

EXTERN int asn1D_OCSPResponseStatus (ASN1CTXT* pctxt,
   ASN1T_OCSPResponseStatus *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_OCSPResponseStatus (ASN1CTXT *pctxt, ASN1T_OCSPResponseStatus* pSrcValue, ASN1T_OCSPResponseStatus* pDstValue);

/**************************************************************/
/*                                                            */
/*  KeyHash                                                   */
/*                                                            */
/**************************************************************/

typedef ASN1TDynOctStr ASN1T_KeyHash;

class EXTERN ASN1C_KeyHash :
   public ASN1CType
{
protected:
   ASN1T_KeyHash& msgData;
public:
   ASN1C_KeyHash (ASN1T_KeyHash& data);
   ASN1C_KeyHash (
      ASN1MessageBufferIF& msgBuf, ASN1T_KeyHash& data);
   ASN1C_KeyHash (ASN1C_KeyHash& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_KeyHash& getCopy (ASN1T_KeyHash* pDstData = 0);
   ASN1T_KeyHash* newCopy ();

   inline ASN1C_KeyHash& operator= (ASN1C_KeyHash& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_KeyHash (ASN1CTXT* pctxt,
   ASN1T_KeyHash *pvalue, ASN1TagType tagging);

EXTERN int asn1D_KeyHash (ASN1CTXT* pctxt,
   ASN1T_KeyHash *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_KeyHash (ASN1CTXT *pctxt, ASN1T_KeyHash* pSrcValue, ASN1T_KeyHash* pDstValue);

EXTERN void asn1Free_KeyHash (ASN1CTXT *pctxt, ASN1T_KeyHash* pvalue);

/**************************************************************/
/*                                                            */
/*  UnknownInfo                                               */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_UnknownInfo :
   public ASN1CType
{
protected:
public:
   ASN1C_UnknownInfo ();
   ASN1C_UnknownInfo (
      ASN1MessageBufferIF& msgBuf);
   ASN1C_UnknownInfo (ASN1C_UnknownInfo& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);


   inline ASN1C_UnknownInfo& operator= (ASN1C_UnknownInfo& srcData) {
      return *this;
   }
} ;

EXTERN int asn1E_UnknownInfo_ (ASN1CTXT* pctxt,
   void *pvalue, ASN1TagType tagging);
#define asn1E_UnknownInfo(pctxt, tagging) \
asn1E_UnknownInfo_(pctxt, NULL, tagging)

EXTERN int asn1D_UnknownInfo_ (ASN1CTXT* pctxt,
   void* pvalue, ASN1TagType tagging, int length);
#define asn1D_UnknownInfo(pctxt, tagging, length) \
asn1D_UnknownInfo_(pctxt, NULL, tagging, length)

EXTERN void asn1Copy_UnknownInfo_ (ASN1CTXT *pctxt, void* pSrcValue, void* pDstValue);
#define asn1Copy_UnknownInfo(name) \
asn1Copy_UnknownInfo_(name, NULL, NULL)

/**************************************************************/
/*                                                            */
/*  ArchiveCutoff                                             */
/*                                                            */
/**************************************************************/

typedef ASN1GeneralizedTime ASN1T_ArchiveCutoff;

class EXTERN ASN1C_ArchiveCutoff :
   public ASN1CGeneralizedTime
{
protected:
   ASN1T_ArchiveCutoff& msgData;
public:
   ASN1C_ArchiveCutoff (ASN1T_ArchiveCutoff& data);
   ASN1C_ArchiveCutoff (
      ASN1MessageBufferIF& msgBuf, ASN1T_ArchiveCutoff& data);
   ASN1C_ArchiveCutoff (ASN1C_ArchiveCutoff& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_ArchiveCutoff& getCopy (ASN1T_ArchiveCutoff* pDstData = 0);
   ASN1T_ArchiveCutoff* newCopy ();

   ASN1C_ArchiveCutoff& operator= (ASN1C_ArchiveCutoff& srcData);
} ;

EXTERN int asn1E_ArchiveCutoff (ASN1CTXT* pctxt,
   ASN1T_ArchiveCutoff *pvalue, ASN1TagType tagging);

EXTERN int asn1D_ArchiveCutoff (ASN1CTXT* pctxt,
   ASN1T_ArchiveCutoff *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_ArchiveCutoff (ASN1CTXT *pctxt, ASN1T_ArchiveCutoff* pSrcValue, ASN1T_ArchiveCutoff* pDstValue);

EXTERN void asn1Free_ArchiveCutoff (ASN1CTXT *pctxt, ASN1T_ArchiveCutoff* pvalue);

/**************************************************************/
/*                                                            */
/*  ResponderID                                               */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_ResponderID_byName            1
#define T_ResponderID_byKey             2

class EXTERN ASN1C_ResponderID;

typedef struct EXTERN ASN1T_ResponderID : public ASN1TPDU {
   int t;
   union {
      /* t = 1 */
      ASN1T_Name *byName;
      /* t = 2 */
      ASN1T_KeyHash *byKey;
   } u;
   ASN1T_ResponderID () {}
   ASN1T_ResponderID (ASN1C_ResponderID& srcData);
   ~ASN1T_ResponderID ();
} ASN1T_ResponderID;

class EXTERN ASN1C_ResponderID :
   public ASN1CType
{
protected:
   ASN1T_ResponderID& msgData;
public:
   ASN1C_ResponderID (ASN1T_ResponderID& data);
   ASN1C_ResponderID (
      ASN1MessageBufferIF& msgBuf, ASN1T_ResponderID& data);
   ASN1C_ResponderID (ASN1C_ResponderID& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_ResponderID& getCopy (ASN1T_ResponderID* pDstData = 0);
   ASN1T_ResponderID* newCopy ();

   inline ASN1C_ResponderID& operator= (ASN1C_ResponderID& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_ResponderID (ASN1CTXT* pctxt,
   ASN1T_ResponderID *pvalue, ASN1TagType tagging);

EXTERN int asn1D_ResponderID (ASN1CTXT* pctxt,
   ASN1T_ResponderID *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_ResponderID (ASN1CTXT *pctxt, ASN1T_ResponderID* pSrcValue, ASN1T_ResponderID* pDstValue);

EXTERN void asn1Free_ResponderID (ASN1CTXT *pctxt, ASN1T_ResponderID* pvalue);

/**************************************************************/
/*                                                            */
/*  CrlID                                                     */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_CrlID;

typedef struct EXTERN ASN1T_CrlID : public ASN1TPDU {
   struct {
      unsigned crlUrlPresent : 1;
      unsigned crlNumPresent : 1;
      unsigned crlTimePresent : 1;
   } m;
   ASN1IA5String crlUrl;
   ASN1INT crlNum;
   ASN1GeneralizedTime crlTime;
   ASN1T_CrlID ();
   ASN1T_CrlID (ASN1C_CrlID& srcData);
   ~ASN1T_CrlID ();
} ASN1T_CrlID;

class EXTERN ASN1C_CrlID :
   public ASN1CType
{
protected:
   ASN1T_CrlID& msgData;
public:
   ASN1C_CrlID (ASN1T_CrlID& data);
   ASN1C_CrlID (
      ASN1MessageBufferIF& msgBuf, ASN1T_CrlID& data);
   ASN1C_CrlID (ASN1C_CrlID& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_CrlID& getCopy (ASN1T_CrlID* pDstData = 0);
   ASN1T_CrlID* newCopy ();

   inline ASN1C_CrlID& operator= (ASN1C_CrlID& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_CrlID (ASN1CTXT* pctxt,
   ASN1T_CrlID *pvalue, ASN1TagType tagging);

EXTERN int asn1D_CrlID (ASN1CTXT* pctxt,
   ASN1T_CrlID *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_CrlID (ASN1CTXT *pctxt, ASN1T_CrlID* pSrcValue, ASN1T_CrlID* pDstValue);

EXTERN void asn1Free_CrlID (ASN1CTXT *pctxt, ASN1T_CrlID* pvalue);

/**************************************************************/
/*                                                            */
/*  AcceptableResponses                                       */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_AcceptableResponses;

typedef struct EXTERN ASN1T_AcceptableResponses : public ASN1TPDU {
   ASN1UINT n;
   ASN1TObjId *elem;
   ASN1T_AcceptableResponses () : n (0), elem(NULL) {} // FIXED for PVS
   ASN1T_AcceptableResponses (ASN1C_AcceptableResponses& srcData);
   ~ASN1T_AcceptableResponses ();
} ASN1T_AcceptableResponses;

class EXTERN ASN1C_AcceptableResponses :
   public ASN1CType
{
protected:
   ASN1T_AcceptableResponses& msgData;
public:
   ASN1C_AcceptableResponses (ASN1T_AcceptableResponses& data);
   ASN1C_AcceptableResponses (
      ASN1MessageBufferIF& msgBuf, ASN1T_AcceptableResponses& data);
   ASN1C_AcceptableResponses (ASN1C_AcceptableResponses& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_AcceptableResponses& getCopy (ASN1T_AcceptableResponses* pDstData = 0);
   ASN1T_AcceptableResponses* newCopy ();

   ASN1C_AcceptableResponses& operator= (ASN1C_AcceptableResponses& srcData);
} ;

EXTERN int asn1E_AcceptableResponses (ASN1CTXT* pctxt,
   ASN1T_AcceptableResponses *pvalue, ASN1TagType tagging);

EXTERN int asn1D_AcceptableResponses (ASN1CTXT* pctxt,
   ASN1T_AcceptableResponses *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_AcceptableResponses (ASN1CTXT *pctxt, ASN1T_AcceptableResponses* pSrcValue, ASN1T_AcceptableResponses* pDstValue);

EXTERN void asn1Free_AcceptableResponses (ASN1CTXT *pctxt, ASN1T_AcceptableResponses* pvalue);

/**************************************************************/
/*                                                            */
/*  ServiceLocator                                            */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_ServiceLocator;

typedef struct EXTERN ASN1T_ServiceLocator : public ASN1TPDU {
   struct {
      unsigned locatorPresent : 1;
   } m;
   ASN1T_Name issuer;
   ASN1T_AuthorityInfoAccessSyntax locator;
   ASN1T_ServiceLocator ();
   ASN1T_ServiceLocator (ASN1C_ServiceLocator& srcData);
   ~ASN1T_ServiceLocator ();
} ASN1T_ServiceLocator;

class EXTERN ASN1C_ServiceLocator :
   public ASN1CType
{
protected:
   ASN1T_ServiceLocator& msgData;
public:
   ASN1C_ServiceLocator (ASN1T_ServiceLocator& data);
   ASN1C_ServiceLocator (
      ASN1MessageBufferIF& msgBuf, ASN1T_ServiceLocator& data);
   ASN1C_ServiceLocator (ASN1C_ServiceLocator& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_ServiceLocator& getCopy (ASN1T_ServiceLocator* pDstData = 0);
   ASN1T_ServiceLocator* newCopy ();

   inline ASN1C_ServiceLocator& operator= (ASN1C_ServiceLocator& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_ServiceLocator (ASN1CTXT* pctxt,
   ASN1T_ServiceLocator *pvalue, ASN1TagType tagging);

EXTERN int asn1D_ServiceLocator (ASN1CTXT* pctxt,
   ASN1T_ServiceLocator *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_ServiceLocator (ASN1CTXT *pctxt, ASN1T_ServiceLocator* pSrcValue, ASN1T_ServiceLocator* pDstValue);

EXTERN void asn1Free_ServiceLocator (ASN1CTXT *pctxt, ASN1T_ServiceLocator* pvalue);

/**************************************************************/
/*                                                            */
/*  CertID                                                    */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_CertID;

typedef struct EXTERN ASN1T_CertID : public ASN1TPDU {
   ASN1T_AlgorithmIdentifier hashAlgorithm;
   ASN1TDynOctStr issuerNameHash;
   ASN1TDynOctStr issuerKeyHash;
   ASN1T_CertificateSerialNumber serialNumber;
   ASN1T_CertID ();
   ASN1T_CertID (ASN1C_CertID& srcData);
   ~ASN1T_CertID ();
} ASN1T_CertID;

class EXTERN ASN1C_CertID :
   public ASN1CType
{
protected:
   ASN1T_CertID& msgData;
public:
   ASN1C_CertID (ASN1T_CertID& data);
   ASN1C_CertID (
      ASN1MessageBufferIF& msgBuf, ASN1T_CertID& data);
   ASN1C_CertID (ASN1C_CertID& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_CertID& getCopy (ASN1T_CertID* pDstData = 0);
   ASN1T_CertID* newCopy ();

   inline ASN1C_CertID& operator= (ASN1C_CertID& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_CertID (ASN1CTXT* pctxt,
   ASN1T_CertID *pvalue, ASN1TagType tagging);

EXTERN int asn1D_CertID (ASN1CTXT* pctxt,
   ASN1T_CertID *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_CertID (ASN1CTXT *pctxt, ASN1T_CertID* pSrcValue, ASN1T_CertID* pDstValue);

EXTERN void asn1Free_CertID (ASN1CTXT *pctxt, ASN1T_CertID* pvalue);

/**************************************************************/
/*                                                            */
/*  FullCertificate                                           */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_FullCertificate_certificate   1
#define T_FullCertificate_attributeCert 2

class EXTERN ASN1C_FullCertificate;

typedef struct EXTERN ASN1T_FullCertificate : public ASN1TPDU {
   int t;
   union {
      /* t = 1 */
      ASN1T_Certificate *certificate;
      /* t = 2 */
      ASN1T_AttributeCertificate *attributeCert;
   } u;
   ASN1T_FullCertificate () {}
   ASN1T_FullCertificate (ASN1C_FullCertificate& srcData);
   ~ASN1T_FullCertificate ();
} ASN1T_FullCertificate;

class EXTERN ASN1C_FullCertificate :
   public ASN1CType
{
protected:
   ASN1T_FullCertificate& msgData;
public:
   ASN1C_FullCertificate (ASN1T_FullCertificate& data);
   ASN1C_FullCertificate (
      ASN1MessageBufferIF& msgBuf, ASN1T_FullCertificate& data);
   ASN1C_FullCertificate (ASN1C_FullCertificate& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_FullCertificate& getCopy (ASN1T_FullCertificate* pDstData = 0);
   ASN1T_FullCertificate* newCopy ();

   inline ASN1C_FullCertificate& operator= (ASN1C_FullCertificate& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_FullCertificate (ASN1CTXT* pctxt,
   ASN1T_FullCertificate *pvalue, ASN1TagType tagging);

EXTERN int asn1D_FullCertificate (ASN1CTXT* pctxt,
   ASN1T_FullCertificate *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_FullCertificate (ASN1CTXT *pctxt, ASN1T_FullCertificate* pSrcValue, ASN1T_FullCertificate* pDstValue);

EXTERN void asn1Free_FullCertificate (ASN1CTXT *pctxt, ASN1T_FullCertificate* pvalue);

/**************************************************************/
/*                                                            */
/*  CertSignature                                             */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_CertSignature;

typedef struct EXTERN ASN1T_CertSignature : public ASN1TPDU {
   ASN1T_AlgorithmIdentifier signatureAlgorithm;
   ASN1TDynBitStr signatureValue;
   ASN1T_CertSignature ();
   ASN1T_CertSignature (ASN1C_CertSignature& srcData);
   ~ASN1T_CertSignature ();
} ASN1T_CertSignature;

class EXTERN ASN1C_CertSignature :
   public ASN1CType
{
protected:
   ASN1T_CertSignature& msgData;
public:
   ASN1C_CertSignature (ASN1T_CertSignature& data);
   ASN1C_CertSignature (
      ASN1MessageBufferIF& msgBuf, ASN1T_CertSignature& data);
   ASN1C_CertSignature (ASN1C_CertSignature& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_CertSignature& getCopy (ASN1T_CertSignature* pDstData = 0);
   ASN1T_CertSignature* newCopy ();

   inline ASN1C_CertSignature& operator= (ASN1C_CertSignature& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_CertSignature (ASN1CTXT* pctxt,
   ASN1T_CertSignature *pvalue, ASN1TagType tagging);

EXTERN int asn1D_CertSignature (ASN1CTXT* pctxt,
   ASN1T_CertSignature *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_CertSignature (ASN1CTXT *pctxt, ASN1T_CertSignature* pSrcValue, ASN1T_CertSignature* pDstValue);

EXTERN void asn1Free_CertSignature (ASN1CTXT *pctxt, ASN1T_CertSignature* pvalue);

/**************************************************************/
/*                                                            */
/*  CertIdWithSignature                                       */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_CertIdWithSignature;

typedef struct EXTERN ASN1T_CertIdWithSignature : public ASN1TPDU {
   ASN1T_IssuerAndSerialNumber issuerandSerialNumber;
   ASN1TDynBitStr tbsCertificateHash;
   ASN1T_CertSignature certsignature;
   ASN1T_CertIdWithSignature ();
   ASN1T_CertIdWithSignature (ASN1C_CertIdWithSignature& srcData);
   ~ASN1T_CertIdWithSignature ();
} ASN1T_CertIdWithSignature;

class EXTERN ASN1C_CertIdWithSignature :
   public ASN1CType
{
protected:
   ASN1T_CertIdWithSignature& msgData;
public:
   ASN1C_CertIdWithSignature (ASN1T_CertIdWithSignature& data);
   ASN1C_CertIdWithSignature (
      ASN1MessageBufferIF& msgBuf, ASN1T_CertIdWithSignature& data);
   ASN1C_CertIdWithSignature (ASN1C_CertIdWithSignature& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_CertIdWithSignature& getCopy (ASN1T_CertIdWithSignature* pDstData = 0);
   ASN1T_CertIdWithSignature* newCopy ();

   inline ASN1C_CertIdWithSignature& operator= (ASN1C_CertIdWithSignature& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_CertIdWithSignature (ASN1CTXT* pctxt,
   ASN1T_CertIdWithSignature *pvalue, ASN1TagType tagging);

EXTERN int asn1D_CertIdWithSignature (ASN1CTXT* pctxt,
   ASN1T_CertIdWithSignature *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_CertIdWithSignature (ASN1CTXT *pctxt, ASN1T_CertIdWithSignature* pSrcValue, ASN1T_CertIdWithSignature* pDstValue);

EXTERN void asn1Free_CertIdWithSignature (ASN1CTXT *pctxt, ASN1T_CertIdWithSignature* pvalue);

/**************************************************************/
/*                                                            */
/*  ReqCert                                                   */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_ReqCert_certID                1
#define T_ReqCert_fullCert              2
#define T_ReqCert_certIdWithSignature   3

class EXTERN ASN1C_ReqCert;

typedef struct EXTERN ASN1T_ReqCert : public ASN1TPDU {
   int t;
   union {
      /* t = 1 */
      ASN1T_CertID *certID;
      /* t = 2 */
      ASN1T_FullCertificate *fullCert;
      /* t = 3 */
      ASN1T_CertIdWithSignature *certIdWithSignature;
   } u;
   ASN1T_ReqCert () {}
   ASN1T_ReqCert (ASN1C_ReqCert& srcData);
   ~ASN1T_ReqCert ();
} ASN1T_ReqCert;

class EXTERN ASN1C_ReqCert :
   public ASN1CType
{
protected:
   ASN1T_ReqCert& msgData;
public:
   ASN1C_ReqCert (ASN1T_ReqCert& data);
   ASN1C_ReqCert (
      ASN1MessageBufferIF& msgBuf, ASN1T_ReqCert& data);
   ASN1C_ReqCert (ASN1C_ReqCert& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_ReqCert& getCopy (ASN1T_ReqCert* pDstData = 0);
   ASN1T_ReqCert* newCopy ();

   inline ASN1C_ReqCert& operator= (ASN1C_ReqCert& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_ReqCert (ASN1CTXT* pctxt,
   ASN1T_ReqCert *pvalue, ASN1TagType tagging);

EXTERN int asn1D_ReqCert (ASN1CTXT* pctxt,
   ASN1T_ReqCert *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_ReqCert (ASN1CTXT *pctxt, ASN1T_ReqCert* pSrcValue, ASN1T_ReqCert* pDstValue);

EXTERN void asn1Free_ReqCert (ASN1CTXT *pctxt, ASN1T_ReqCert* pvalue);

/**************************************************************/
/*                                                            */
/*  RevokedInfo                                               */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_RevokedInfo;

typedef struct EXTERN ASN1T_RevokedInfo : public ASN1TPDU {
   struct {
      unsigned revocationReasonPresent : 1;
   } m;
   ASN1GeneralizedTime revocationTime;
   ASN1T_CRLReason revocationReason;
   ASN1T_RevokedInfo ();
   ASN1T_RevokedInfo (ASN1C_RevokedInfo& srcData);
   ~ASN1T_RevokedInfo ();
} ASN1T_RevokedInfo;

class EXTERN ASN1C_RevokedInfo :
   public ASN1CType
{
protected:
   ASN1T_RevokedInfo& msgData;
public:
   ASN1C_RevokedInfo (ASN1T_RevokedInfo& data);
   ASN1C_RevokedInfo (
      ASN1MessageBufferIF& msgBuf, ASN1T_RevokedInfo& data);
   ASN1C_RevokedInfo (ASN1C_RevokedInfo& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_RevokedInfo& getCopy (ASN1T_RevokedInfo* pDstData = 0);
   ASN1T_RevokedInfo* newCopy ();

   inline ASN1C_RevokedInfo& operator= (ASN1C_RevokedInfo& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_RevokedInfo (ASN1CTXT* pctxt,
   ASN1T_RevokedInfo *pvalue, ASN1TagType tagging);

EXTERN int asn1D_RevokedInfo (ASN1CTXT* pctxt,
   ASN1T_RevokedInfo *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_RevokedInfo (ASN1CTXT *pctxt, ASN1T_RevokedInfo* pSrcValue, ASN1T_RevokedInfo* pDstValue);

EXTERN void asn1Free_RevokedInfo (ASN1CTXT *pctxt, ASN1T_RevokedInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  CertStatus                                                */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_CertStatus_good               1
#define T_CertStatus_revoked            2
#define T_CertStatus_unknown            3

class EXTERN ASN1C_CertStatus;

typedef struct EXTERN ASN1T_CertStatus : public ASN1TPDU {
   int t;
   union {
      /* t = 1 */
      /* t = 2 */
      ASN1T_RevokedInfo *revoked;
      /* t = 3 */
   } u;
   ASN1T_CertStatus () {}
   ASN1T_CertStatus (ASN1C_CertStatus& srcData);
   ~ASN1T_CertStatus ();
} ASN1T_CertStatus;

class EXTERN ASN1C_CertStatus :
   public ASN1CType
{
protected:
   ASN1T_CertStatus& msgData;
public:
   ASN1C_CertStatus (ASN1T_CertStatus& data);
   ASN1C_CertStatus (
      ASN1MessageBufferIF& msgBuf, ASN1T_CertStatus& data);
   ASN1C_CertStatus (ASN1C_CertStatus& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_CertStatus& getCopy (ASN1T_CertStatus* pDstData = 0);
   ASN1T_CertStatus* newCopy ();

   inline ASN1C_CertStatus& operator= (ASN1C_CertStatus& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_CertStatus (ASN1CTXT* pctxt,
   ASN1T_CertStatus *pvalue, ASN1TagType tagging);

EXTERN int asn1D_CertStatus (ASN1CTXT* pctxt,
   ASN1T_CertStatus *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_CertStatus (ASN1CTXT *pctxt, ASN1T_CertStatus* pSrcValue, ASN1T_CertStatus* pDstValue);

EXTERN void asn1Free_CertStatus (ASN1CTXT *pctxt, ASN1T_CertStatus* pvalue);

/**************************************************************/
/*                                                            */
/*  SingleResponse                                            */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_SingleResponse;

typedef struct EXTERN ASN1T_SingleResponse : public ASN1TPDU {
   struct {
      unsigned nextUpdatePresent : 1;
      unsigned singleExtensionsPresent : 1;
   } m;
   ASN1T_ReqCert reqCert;
   ASN1T_CertStatus certStatus;
   ASN1GeneralizedTime thisUpdate;
   ASN1GeneralizedTime nextUpdate;
   ASN1T_Extensions singleExtensions;
   ASN1T_SingleResponse ();
   ASN1T_SingleResponse (ASN1C_SingleResponse& srcData);
   ~ASN1T_SingleResponse ();
} ASN1T_SingleResponse;

class EXTERN ASN1C_SingleResponse :
   public ASN1CType
{
protected:
   ASN1T_SingleResponse& msgData;
public:
   ASN1C_SingleResponse (ASN1T_SingleResponse& data);
   ASN1C_SingleResponse (
      ASN1MessageBufferIF& msgBuf, ASN1T_SingleResponse& data);
   ASN1C_SingleResponse (ASN1C_SingleResponse& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_SingleResponse& getCopy (ASN1T_SingleResponse* pDstData = 0);
   ASN1T_SingleResponse* newCopy ();

   inline ASN1C_SingleResponse& operator= (ASN1C_SingleResponse& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_SingleResponse (ASN1CTXT* pctxt,
   ASN1T_SingleResponse *pvalue, ASN1TagType tagging);

EXTERN int asn1D_SingleResponse (ASN1CTXT* pctxt,
   ASN1T_SingleResponse *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_SingleResponse (ASN1CTXT *pctxt, ASN1T_SingleResponse* pSrcValue, ASN1T_SingleResponse* pDstValue);

EXTERN void asn1Free_SingleResponse (ASN1CTXT *pctxt, ASN1T_SingleResponse* pvalue);

/**************************************************************/
/*                                                            */
/*  _SeqOfSingleResponse                                      */
/*                                                            */
/**************************************************************/

/* List of ASN1T_SingleResponse */
typedef struct EXTERN ASN1T__SeqOfSingleResponse : public ASN1TPDUSeqOfList {
   ~ASN1T__SeqOfSingleResponse();
} ASN1T__SeqOfSingleResponse;

class EXTERN ASN1C__SeqOfSingleResponse :
   public ASN1CSeqOfList
{
protected:
   ASN1T__SeqOfSingleResponse& msgData;
public:
   ASN1C__SeqOfSingleResponse (ASN1T__SeqOfSingleResponse& data);
   ASN1C__SeqOfSingleResponse (
      ASN1MessageBufferIF& msgBuf, ASN1T__SeqOfSingleResponse& data);
   ASN1C__SeqOfSingleResponse (ASN1C__SeqOfSingleResponse& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T__SeqOfSingleResponse& getCopy (ASN1T__SeqOfSingleResponse* pDstData = 0);
   ASN1T__SeqOfSingleResponse* newCopy ();

   ASN1C__SeqOfSingleResponse& operator= (ASN1C__SeqOfSingleResponse& srcData);
   void Append (ASN1T_SingleResponse * elem) {
      append ((void*)elem);
   }
} ;

EXTERN int asn1E__SeqOfSingleResponse (ASN1CTXT* pctxt,
   ASN1T__SeqOfSingleResponse *pvalue, ASN1TagType tagging);

EXTERN int asn1D__SeqOfSingleResponse (ASN1CTXT* pctxt,
   ASN1T__SeqOfSingleResponse *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy__SeqOfSingleResponse (ASN1CTXT *pctxt, ASN1T__SeqOfSingleResponse* pSrcValue, ASN1T__SeqOfSingleResponse* pDstValue);

EXTERN void asn1Free__SeqOfSingleResponse (ASN1CTXT *pctxt, ASN1T__SeqOfSingleResponse* pvalue);

/**************************************************************/
/*                                                            */
/*  ResponseData                                              */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_ResponseData;

typedef struct EXTERN ASN1T_ResponseData : public ASN1TPDU {
   struct {
      unsigned versionPresent : 1;
      unsigned responseExtensionsPresent : 1;
   } m;
   ASN1T_OCSPVersion version;
   ASN1T_ResponderID responderID;
   ASN1GeneralizedTime producedAt;
   ASN1T__SeqOfSingleResponse responses;
   ASN1T_Extensions responseExtensions;
   ASN1T_ResponseData ();
   ASN1T_ResponseData (ASN1C_ResponseData& srcData);
   ~ASN1T_ResponseData ();
} ASN1T_ResponseData;

class EXTERN ASN1C_ResponseData :
   public ASN1CType
{
protected:
   ASN1T_ResponseData& msgData;
public:
   ASN1C_ResponseData (ASN1T_ResponseData& data);
   ASN1C_ResponseData (
      ASN1MessageBufferIF& msgBuf, ASN1T_ResponseData& data);
   ASN1C_ResponseData (ASN1C_ResponseData& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_ResponseData& getCopy (ASN1T_ResponseData* pDstData = 0);
   ASN1T_ResponseData* newCopy ();

   inline ASN1C_ResponseData& operator= (ASN1C_ResponseData& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_ResponseData (ASN1CTXT* pctxt,
   ASN1T_ResponseData *pvalue, ASN1TagType tagging);

EXTERN int asn1D_ResponseData (ASN1CTXT* pctxt,
   ASN1T_ResponseData *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_ResponseData (ASN1CTXT *pctxt, ASN1T_ResponseData* pSrcValue, ASN1T_ResponseData* pDstValue);

EXTERN void asn1Free_ResponseData (ASN1CTXT *pctxt, ASN1T_ResponseData* pvalue);

/**************************************************************/
/*                                                            */
/*  Certificates                                              */
/*                                                            */
/**************************************************************/

/* List of ASN1T_Certificate */
typedef struct EXTERN ASN1T_Certificates : public ASN1TPDUSeqOfList {
   ~ASN1T_Certificates();
} ASN1T_Certificates;

class EXTERN ASN1C_Certificates :
   public ASN1CSeqOfList
{
protected:
   ASN1T_Certificates& msgData;
public:
   ASN1C_Certificates (ASN1T_Certificates& data);
   ASN1C_Certificates (
      ASN1MessageBufferIF& msgBuf, ASN1T_Certificates& data);
   ASN1C_Certificates (ASN1C_Certificates& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_Certificates& getCopy (ASN1T_Certificates* pDstData = 0);
   ASN1T_Certificates* newCopy ();

   ASN1C_Certificates& operator= (ASN1C_Certificates& srcData);
   void Append (ASN1T_Certificate * elem) {
      append ((void*)elem);
   }
} ;

EXTERN int asn1E_Certificates (ASN1CTXT* pctxt,
   ASN1T_Certificates *pvalue, ASN1TagType tagging);

EXTERN int asn1D_Certificates (ASN1CTXT* pctxt,
   ASN1T_Certificates *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_Certificates (ASN1CTXT *pctxt, ASN1T_Certificates* pSrcValue, ASN1T_Certificates* pDstValue);

EXTERN void asn1Free_Certificates (ASN1CTXT *pctxt, ASN1T_Certificates* pvalue);

/**************************************************************/
/*                                                            */
/*  BasicOCSPResponse                                         */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_BasicOCSPResponse;

typedef struct EXTERN ASN1T_BasicOCSPResponse : public ASN1TPDU {
   struct {
      unsigned certsPresent : 1;
   } m;
   ASN1T_ResponseData tbsResponseData;
   ASN1T_AlgorithmIdentifier signatureAlgorithm;
   ASN1TDynBitStr signature;
   ASN1T_Certificates certs;
   ASN1T_BasicOCSPResponse ();
   ASN1T_BasicOCSPResponse (ASN1C_BasicOCSPResponse& srcData);
   ~ASN1T_BasicOCSPResponse ();
} ASN1T_BasicOCSPResponse;

class EXTERN ASN1C_BasicOCSPResponse :
   public ASN1CType
{
protected:
   ASN1T_BasicOCSPResponse& msgData;
public:
   ASN1C_BasicOCSPResponse (ASN1T_BasicOCSPResponse& data);
   ASN1C_BasicOCSPResponse (
      ASN1MessageBufferIF& msgBuf, ASN1T_BasicOCSPResponse& data);
   ASN1C_BasicOCSPResponse (ASN1C_BasicOCSPResponse& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_BasicOCSPResponse& getCopy (ASN1T_BasicOCSPResponse* pDstData = 0);
   ASN1T_BasicOCSPResponse* newCopy ();

   inline ASN1C_BasicOCSPResponse& operator= (ASN1C_BasicOCSPResponse& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_BasicOCSPResponse (ASN1CTXT* pctxt,
   ASN1T_BasicOCSPResponse *pvalue, ASN1TagType tagging);

EXTERN int asn1D_BasicOCSPResponse (ASN1CTXT* pctxt,
   ASN1T_BasicOCSPResponse *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_BasicOCSPResponse (ASN1CTXT *pctxt, ASN1T_BasicOCSPResponse* pSrcValue, ASN1T_BasicOCSPResponse* pDstValue);

EXTERN void asn1Free_BasicOCSPResponse (ASN1CTXT *pctxt, ASN1T_BasicOCSPResponse* pvalue);

/**************************************************************/
/*                                                            */
/*  ResponseBytes                                             */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_ResponseBytes;

typedef struct EXTERN ASN1T_ResponseBytes : public ASN1TPDU {
   ASN1TObjId responseType;
   ASN1TDynOctStr response;
   Asn1TObject value;
   ASN1T_ResponseBytes ();
   ASN1T_ResponseBytes (ASN1C_ResponseBytes& srcData);
   ~ASN1T_ResponseBytes ();
} ASN1T_ResponseBytes;

class EXTERN ASN1C_ResponseBytes :
   public ASN1CType
{
protected:
   ASN1T_ResponseBytes& msgData;
public:
   ASN1C_ResponseBytes (ASN1T_ResponseBytes& data);
   ASN1C_ResponseBytes (
      ASN1MessageBufferIF& msgBuf, ASN1T_ResponseBytes& data);
   ASN1C_ResponseBytes (ASN1C_ResponseBytes& original);
   ~ASN1C_ResponseBytes();

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_ResponseBytes& getCopy (ASN1T_ResponseBytes* pDstData = 0);
   ASN1T_ResponseBytes* newCopy ();

   inline ASN1C_ResponseBytes& operator= (ASN1C_ResponseBytes& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_ResponseBytes (ASN1CTXT* pctxt,
   ASN1T_ResponseBytes *pvalue, ASN1TagType tagging);

EXTERN int asn1D_ResponseBytes (ASN1CTXT* pctxt,
   ASN1T_ResponseBytes *pvalue, ASN1TagType tagging, int length);

EXTERN int asn1XETC_ResponseBytes (ASN1CTXT* pctxt,
    ASN1T_ResponseBytes *pvalue);

EXTERN int asn1XDTC_ResponseBytes (ASN1CtxtPtr& pctxt,
    ASN1T_ResponseBytes *pvalue);

EXTERN int asn1ETC_ResponseBytes (ASN1CTXT* pctxt,
   ASN1T_ResponseBytes *pvalue);

EXTERN int asn1DTC_ResponseBytes (ASN1CTXT* pctxt,
   ASN1T_ResponseBytes *pvalue);

EXTERN void asn1Copy_ResponseBytes (ASN1CTXT *pctxt, ASN1T_ResponseBytes* pSrcValue, ASN1T_ResponseBytes* pDstValue);

EXTERN void asn1Free_ResponseBytes (ASN1CTXT *pctxt, ASN1T_ResponseBytes* pvalue);

/**************************************************************/
/*                                                            */
/*  OCSPResponse                                              */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_OCSPResponse;

typedef struct EXTERN ASN1T_OCSPResponse : public ASN1TPDU {
   struct {
      unsigned responseBytesPresent : 1;
   } m;
   ASN1T_OCSPResponseStatus responseStatus;
   ASN1T_ResponseBytes responseBytes;
   ASN1T_OCSPResponse ();
   ASN1T_OCSPResponse (ASN1C_OCSPResponse& srcData);
   ~ASN1T_OCSPResponse ();
} ASN1T_OCSPResponse;

class EXTERN ASN1C_OCSPResponse :
   public ASN1CType
{
protected:
   ASN1T_OCSPResponse& msgData;
public:
   ASN1C_OCSPResponse (ASN1T_OCSPResponse& data);
   ASN1C_OCSPResponse (
      ASN1MessageBufferIF& msgBuf, ASN1T_OCSPResponse& data);
   ASN1C_OCSPResponse (ASN1C_OCSPResponse& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_OCSPResponse& getCopy (ASN1T_OCSPResponse* pDstData = 0);
   ASN1T_OCSPResponse* newCopy ();

   inline ASN1C_OCSPResponse& operator= (ASN1C_OCSPResponse& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_OCSPResponse (ASN1CTXT* pctxt,
   ASN1T_OCSPResponse *pvalue, ASN1TagType tagging);

EXTERN int asn1D_OCSPResponse (ASN1CTXT* pctxt,
   ASN1T_OCSPResponse *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_OCSPResponse (ASN1CTXT *pctxt, ASN1T_OCSPResponse* pSrcValue, ASN1T_OCSPResponse* pDstValue);

EXTERN void asn1Free_OCSPResponse (ASN1CTXT *pctxt, ASN1T_OCSPResponse* pvalue);

/**************************************************************/
/*                                                            */
/*  CrlLocator                                                */
/*                                                            */
/**************************************************************/

typedef ASN1T_CRLDistPointsSyntax ASN1T_CrlLocator;

class EXTERN ASN1C_CrlLocator :
   public ASN1C_CRLDistPointsSyntax
{
protected:
public:
   ASN1C_CrlLocator (ASN1T_CrlLocator& data);
   ASN1C_CrlLocator (
      ASN1MessageBufferIF& msgBuf, ASN1T_CrlLocator& data);
   ASN1C_CrlLocator (ASN1C_CrlLocator& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_CrlLocator& getCopy (ASN1T_CrlLocator* pDstData = 0);
   ASN1T_CrlLocator* newCopy ();

   inline ASN1C_CrlLocator& operator= (ASN1C_CrlLocator& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_CrlLocator (ASN1CTXT* pctxt,
   ASN1T_CrlLocator *pvalue, ASN1TagType tagging);

EXTERN int asn1D_CrlLocator (ASN1CTXT* pctxt,
   ASN1T_CrlLocator *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_CrlLocator (ASN1CTXT *pctxt, ASN1T_CrlLocator* pSrcValue, ASN1T_CrlLocator* pDstValue);

EXTERN void asn1Free_CrlLocator (ASN1CTXT *pctxt, ASN1T_CrlLocator* pvalue);

/**************************************************************/
/*                                                            */
/*  Request                                                   */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_Request;

typedef struct EXTERN ASN1T_Request : public ASN1TPDU {
   struct {
      unsigned singleRequestExtensionsPresent : 1;
   } m;
   ASN1T_ReqCert reqCert;
   ASN1T_Extensions singleRequestExtensions;
   ASN1T_Request ();
   ASN1T_Request (ASN1C_Request& srcData);
   ~ASN1T_Request ();
} ASN1T_Request;

class EXTERN ASN1C_Request :
   public ASN1CType
{
protected:
   ASN1T_Request& msgData;
public:
   ASN1C_Request (ASN1T_Request& data);
   ASN1C_Request (
      ASN1MessageBufferIF& msgBuf, ASN1T_Request& data);
   ASN1C_Request (ASN1C_Request& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_Request& getCopy (ASN1T_Request* pDstData = 0);
   ASN1T_Request* newCopy ();

   inline ASN1C_Request& operator= (ASN1C_Request& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_Request (ASN1CTXT* pctxt,
   ASN1T_Request *pvalue, ASN1TagType tagging);

EXTERN int asn1D_Request (ASN1CTXT* pctxt,
   ASN1T_Request *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_Request (ASN1CTXT *pctxt, ASN1T_Request* pSrcValue, ASN1T_Request* pDstValue);

EXTERN void asn1Free_Request (ASN1CTXT *pctxt, ASN1T_Request* pvalue);

/**************************************************************/
/*                                                            */
/*  _SeqOfRequest                                             */
/*                                                            */
/**************************************************************/

/* List of ASN1T_Request */
typedef struct EXTERN ASN1T__SeqOfRequest : public ASN1TPDUSeqOfList {
   ~ASN1T__SeqOfRequest();
} ASN1T__SeqOfRequest;

class EXTERN ASN1C__SeqOfRequest :
   public ASN1CSeqOfList
{
protected:
   ASN1T__SeqOfRequest& msgData;
public:
   ASN1C__SeqOfRequest (ASN1T__SeqOfRequest& data);
   ASN1C__SeqOfRequest (
      ASN1MessageBufferIF& msgBuf, ASN1T__SeqOfRequest& data);
   ASN1C__SeqOfRequest (ASN1C__SeqOfRequest& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T__SeqOfRequest& getCopy (ASN1T__SeqOfRequest* pDstData = 0);
   ASN1T__SeqOfRequest* newCopy ();

   ASN1C__SeqOfRequest& operator= (ASN1C__SeqOfRequest& srcData);
   void Append (ASN1T_Request * elem) {
      append ((void*)elem);
   }
} ;

EXTERN int asn1E__SeqOfRequest (ASN1CTXT* pctxt,
   ASN1T__SeqOfRequest *pvalue, ASN1TagType tagging);

EXTERN int asn1D__SeqOfRequest (ASN1CTXT* pctxt,
   ASN1T__SeqOfRequest *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy__SeqOfRequest (ASN1CTXT *pctxt, ASN1T__SeqOfRequest* pSrcValue, ASN1T__SeqOfRequest* pDstValue);

EXTERN void asn1Free__SeqOfRequest (ASN1CTXT *pctxt, ASN1T__SeqOfRequest* pvalue);

/**************************************************************/
/*                                                            */
/*  TBSRequest                                                */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_TBSRequest;

typedef struct EXTERN ASN1T_TBSRequest : public ASN1TPDU {
   struct {
      unsigned versionPresent : 1;
      unsigned requestorNamePresent : 1;
      unsigned requestExtensionsPresent : 1;
   } m;
   ASN1T_OCSPVersion version;
   ASN1T_GeneralName requestorName;
   ASN1T__SeqOfRequest requestList;
   ASN1T_Extensions requestExtensions;
   ASN1T_TBSRequest ();
   ASN1T_TBSRequest (ASN1C_TBSRequest& srcData);
   ~ASN1T_TBSRequest ();
} ASN1T_TBSRequest;

class EXTERN ASN1C_TBSRequest :
   public ASN1CType
{
protected:
   ASN1T_TBSRequest& msgData;
public:
   ASN1C_TBSRequest (ASN1T_TBSRequest& data);
   ASN1C_TBSRequest (
      ASN1MessageBufferIF& msgBuf, ASN1T_TBSRequest& data);
   ASN1C_TBSRequest (ASN1C_TBSRequest& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_TBSRequest& getCopy (ASN1T_TBSRequest* pDstData = 0);
   ASN1T_TBSRequest* newCopy ();

   inline ASN1C_TBSRequest& operator= (ASN1C_TBSRequest& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_TBSRequest (ASN1CTXT* pctxt,
   ASN1T_TBSRequest *pvalue, ASN1TagType tagging);

EXTERN int asn1D_TBSRequest (ASN1CTXT* pctxt,
   ASN1T_TBSRequest *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_TBSRequest (ASN1CTXT *pctxt, ASN1T_TBSRequest* pSrcValue, ASN1T_TBSRequest* pDstValue);

EXTERN void asn1Free_TBSRequest (ASN1CTXT *pctxt, ASN1T_TBSRequest* pvalue);

/**************************************************************/
/*                                                            */
/*  OCSPSignature                                             */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_OCSPSignature;

typedef struct EXTERN ASN1T_OCSPSignature : public ASN1TPDU {
   struct {
      unsigned certsPresent : 1;
   } m;
   ASN1T_AlgorithmIdentifier signatureAlgorithm;
   ASN1TDynBitStr signature;
   ASN1T_Certificates certs;
   ASN1T_OCSPSignature ();
   ASN1T_OCSPSignature (ASN1C_OCSPSignature& srcData);
   ~ASN1T_OCSPSignature ();
} ASN1T_OCSPSignature;

class EXTERN ASN1C_OCSPSignature :
   public ASN1CType
{
protected:
   ASN1T_OCSPSignature& msgData;
public:
   ASN1C_OCSPSignature (ASN1T_OCSPSignature& data);
   ASN1C_OCSPSignature (
      ASN1MessageBufferIF& msgBuf, ASN1T_OCSPSignature& data);
   ASN1C_OCSPSignature (ASN1C_OCSPSignature& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_OCSPSignature& getCopy (ASN1T_OCSPSignature* pDstData = 0);
   ASN1T_OCSPSignature* newCopy ();

   inline ASN1C_OCSPSignature& operator= (ASN1C_OCSPSignature& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_OCSPSignature (ASN1CTXT* pctxt,
   ASN1T_OCSPSignature *pvalue, ASN1TagType tagging);

EXTERN int asn1D_OCSPSignature (ASN1CTXT* pctxt,
   ASN1T_OCSPSignature *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_OCSPSignature (ASN1CTXT *pctxt, ASN1T_OCSPSignature* pSrcValue, ASN1T_OCSPSignature* pDstValue);

EXTERN void asn1Free_OCSPSignature (ASN1CTXT *pctxt, ASN1T_OCSPSignature* pvalue);

/**************************************************************/
/*                                                            */
/*  OCSPRequest                                               */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_OCSPRequest;

typedef struct EXTERN ASN1T_OCSPRequest : public ASN1TPDU {
   struct {
      unsigned optionalSignaturePresent : 1;
   } m;
   ASN1T_TBSRequest tbsRequest;
   ASN1T_OCSPSignature optionalSignature;
   ASN1T_OCSPRequest ();
   ASN1T_OCSPRequest (ASN1C_OCSPRequest& srcData);
   ~ASN1T_OCSPRequest ();
} ASN1T_OCSPRequest;

class EXTERN ASN1C_OCSPRequest :
   public ASN1CType
{
protected:
   ASN1T_OCSPRequest& msgData;
public:
   ASN1C_OCSPRequest (ASN1T_OCSPRequest& data);
   ASN1C_OCSPRequest (
      ASN1MessageBufferIF& msgBuf, ASN1T_OCSPRequest& data);
   ASN1C_OCSPRequest (ASN1C_OCSPRequest& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_OCSPRequest& getCopy (ASN1T_OCSPRequest* pDstData = 0);
   ASN1T_OCSPRequest* newCopy ();

   inline ASN1C_OCSPRequest& operator= (ASN1C_OCSPRequest& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_OCSPRequest (ASN1CTXT* pctxt,
   ASN1T_OCSPRequest *pvalue, ASN1TagType tagging);

EXTERN int asn1D_OCSPRequest (ASN1CTXT* pctxt,
   ASN1T_OCSPRequest *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_OCSPRequest (ASN1CTXT *pctxt, ASN1T_OCSPRequest* pSrcValue, ASN1T_OCSPRequest* pDstValue);

EXTERN void asn1Free_OCSPRequest (ASN1CTXT *pctxt, ASN1T_OCSPRequest* pvalue);

/* Value definitions */

extern EXTERN ASN1OBJID id_kp_OCSPSigning;
extern EXTERN ASN1OBJID id_pkix_ocsp;
extern EXTERN ASN1OBJID id_pkix_ocsp_basic;
extern EXTERN ASN1OBJID id_pkix_ocsp_nonce;
extern EXTERN ASN1OBJID id_pkix_ocsp_crl;
extern EXTERN ASN1OBJID id_pkix_ocsp_response;
extern EXTERN ASN1OBJID id_pkix_ocsp_nocheck;
extern EXTERN ASN1OBJID id_pkix_ocsp_archive_cutoff;
extern EXTERN ASN1OBJID id_pkix_ocsp_service_locator;
extern EXTERN ASN1OBJID id_CryptoPro_ocsp_treats_exp_key_or_exp_cert_rev;
extern EXTERN ASN1OBJID id_CryptoPro_ocsp_crl_locator;
extern EXTERN ASN1OBJID id_CryptoPro_ocsp_instant_revocation_indicator;
extern EXTERN ASN1OBJID id_CryptoPro_ocsp_revocation_announcement_reference;
extern EXTERN ASN1OBJID id_CryptoPro_ocsp_historical_request;

}
#endif
