/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 5.63.
 */
#ifndef CRYPTOGRAPHICMESSAGESYNTAX_H
#define CRYPTOGRAPHICMESSAGESYNTAX_H

#include <stdio.h>
#include <stdlib.h>
#include "asn1BerCppTypes.h"
#include "rtTable.h"
#include "ASN1CSeqOfList.h"
#include "ASN1CBitStr.h"
#include "PKIX1Explicit88.h"
#include "CertificateExtensions.h"
#include "AuthenticationFramework.h"
#include "PKIX1Explicit88BaseTypes.h"
namespace asn1data {

/**************************************************************/
/*                                                            */
/*  ContentType                                               */
/*                                                            */
/**************************************************************/

typedef ASN1TObjId ASN1T_ContentType;

class EXTERN ASN1C_ContentType :
   public ASN1CType
{
protected:
   ASN1T_ContentType& msgData;
public:
   ASN1C_ContentType (ASN1T_ContentType& data);
   ASN1C_ContentType (
      ASN1MessageBufferIF& msgBuf, ASN1T_ContentType& data);
   ASN1C_ContentType (ASN1C_ContentType& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_ContentType& getCopy (ASN1T_ContentType* pDstData = 0);
   ASN1T_ContentType* newCopy ();

   inline ASN1C_ContentType& operator= (ASN1C_ContentType& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_ContentType (ASN1CTXT* pctxt,
   ASN1T_ContentType *pvalue, ASN1TagType tagging);

EXTERN int asn1D_ContentType (ASN1CTXT* pctxt,
   ASN1T_ContentType *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_ContentType (ASN1CTXT *pctxt, ASN1T_ContentType* pSrcValue, ASN1T_ContentType* pDstValue);

/**************************************************************/
/*                                                            */
/*  SignatureValue                                            */
/*                                                            */
/**************************************************************/

typedef ASN1TDynOctStr ASN1T_SignatureValue;

class EXTERN ASN1C_SignatureValue :
   public ASN1CType
{
protected:
   ASN1T_SignatureValue& msgData;
public:
   ASN1C_SignatureValue (ASN1T_SignatureValue& data);
   ASN1C_SignatureValue (
      ASN1MessageBufferIF& msgBuf, ASN1T_SignatureValue& data);
   ASN1C_SignatureValue (ASN1C_SignatureValue& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_SignatureValue& getCopy (ASN1T_SignatureValue* pDstData = 0);
   ASN1T_SignatureValue* newCopy ();

   inline ASN1C_SignatureValue& operator= (ASN1C_SignatureValue& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_SignatureValue (ASN1CTXT* pctxt,
   ASN1T_SignatureValue *pvalue, ASN1TagType tagging);

EXTERN int asn1D_SignatureValue (ASN1CTXT* pctxt,
   ASN1T_SignatureValue *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_SignatureValue (ASN1CTXT *pctxt, ASN1T_SignatureValue* pSrcValue, ASN1T_SignatureValue* pDstValue);

EXTERN void asn1Free_SignatureValue (ASN1CTXT *pctxt, ASN1T_SignatureValue* pvalue);

/**************************************************************/
/*                                                            */
/*  EncryptedContent                                          */
/*                                                            */
/**************************************************************/

typedef ASN1TDynOctStr ASN1T_EncryptedContent;

class EXTERN ASN1C_EncryptedContent :
   public ASN1CType
{
protected:
   ASN1T_EncryptedContent& msgData;
public:
   ASN1C_EncryptedContent (ASN1T_EncryptedContent& data);
   ASN1C_EncryptedContent (
      ASN1MessageBufferIF& msgBuf, ASN1T_EncryptedContent& data);
   ASN1C_EncryptedContent (ASN1C_EncryptedContent& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_EncryptedContent& getCopy (ASN1T_EncryptedContent* pDstData = 0);
   ASN1T_EncryptedContent* newCopy ();

   inline ASN1C_EncryptedContent& operator= (ASN1C_EncryptedContent& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_EncryptedContent (ASN1CTXT* pctxt,
   ASN1T_EncryptedContent *pvalue, ASN1TagType tagging);

EXTERN int asn1D_EncryptedContent (ASN1CTXT* pctxt,
   ASN1T_EncryptedContent *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_EncryptedContent (ASN1CTXT *pctxt, ASN1T_EncryptedContent* pSrcValue, ASN1T_EncryptedContent* pDstValue);

EXTERN void asn1Free_EncryptedContent (ASN1CTXT *pctxt, ASN1T_EncryptedContent* pvalue);

/**************************************************************/
/*                                                            */
/*  EncryptedKey                                              */
/*                                                            */
/**************************************************************/

typedef ASN1TDynOctStr ASN1T_EncryptedKey;

class EXTERN ASN1C_EncryptedKey :
   public ASN1CType
{
protected:
   ASN1T_EncryptedKey& msgData;
public:
   ASN1C_EncryptedKey (ASN1T_EncryptedKey& data);
   ASN1C_EncryptedKey (
      ASN1MessageBufferIF& msgBuf, ASN1T_EncryptedKey& data);
   ASN1C_EncryptedKey (ASN1C_EncryptedKey& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_EncryptedKey& getCopy (ASN1T_EncryptedKey* pDstData = 0);
   ASN1T_EncryptedKey* newCopy ();

   inline ASN1C_EncryptedKey& operator= (ASN1C_EncryptedKey& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_EncryptedKey (ASN1CTXT* pctxt,
   ASN1T_EncryptedKey *pvalue, ASN1TagType tagging);

EXTERN int asn1D_EncryptedKey (ASN1CTXT* pctxt,
   ASN1T_EncryptedKey *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_EncryptedKey (ASN1CTXT *pctxt, ASN1T_EncryptedKey* pSrcValue, ASN1T_EncryptedKey* pDstValue);

EXTERN void asn1Free_EncryptedKey (ASN1CTXT *pctxt, ASN1T_EncryptedKey* pvalue);

/**************************************************************/
/*                                                            */
/*  Digest                                                    */
/*                                                            */
/**************************************************************/

typedef ASN1TDynOctStr ASN1T_Digest;

class EXTERN ASN1C_Digest :
   public ASN1CType
{
protected:
   ASN1T_Digest& msgData;
public:
   ASN1C_Digest (ASN1T_Digest& data);
   ASN1C_Digest (
      ASN1MessageBufferIF& msgBuf, ASN1T_Digest& data);
   ASN1C_Digest (ASN1C_Digest& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_Digest& getCopy (ASN1T_Digest* pDstData = 0);
   ASN1T_Digest* newCopy ();

   inline ASN1C_Digest& operator= (ASN1C_Digest& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_Digest (ASN1CTXT* pctxt,
   ASN1T_Digest *pvalue, ASN1TagType tagging);

EXTERN int asn1D_Digest (ASN1CTXT* pctxt,
   ASN1T_Digest *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_Digest (ASN1CTXT *pctxt, ASN1T_Digest* pSrcValue, ASN1T_Digest* pDstValue);

EXTERN void asn1Free_Digest (ASN1CTXT *pctxt, ASN1T_Digest* pvalue);

/**************************************************************/
/*                                                            */
/*  MessageAuthenticationCode                                 */
/*                                                            */
/**************************************************************/

typedef ASN1TDynOctStr ASN1T_MessageAuthenticationCode;

class EXTERN ASN1C_MessageAuthenticationCode :
   public ASN1CType
{
protected:
   ASN1T_MessageAuthenticationCode& msgData;
public:
   ASN1C_MessageAuthenticationCode (ASN1T_MessageAuthenticationCode& data);
   ASN1C_MessageAuthenticationCode (
      ASN1MessageBufferIF& msgBuf, ASN1T_MessageAuthenticationCode& data);
   ASN1C_MessageAuthenticationCode (ASN1C_MessageAuthenticationCode& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_MessageAuthenticationCode& getCopy (ASN1T_MessageAuthenticationCode* pDstData = 0);
   ASN1T_MessageAuthenticationCode* newCopy ();

   inline ASN1C_MessageAuthenticationCode& operator= (ASN1C_MessageAuthenticationCode& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_MessageAuthenticationCode (ASN1CTXT* pctxt,
   ASN1T_MessageAuthenticationCode *pvalue, ASN1TagType tagging);

EXTERN int asn1D_MessageAuthenticationCode (ASN1CTXT* pctxt,
   ASN1T_MessageAuthenticationCode *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_MessageAuthenticationCode (ASN1CTXT *pctxt, ASN1T_MessageAuthenticationCode* pSrcValue, ASN1T_MessageAuthenticationCode* pDstValue);

EXTERN void asn1Free_MessageAuthenticationCode (ASN1CTXT *pctxt, ASN1T_MessageAuthenticationCode* pvalue);

/**************************************************************/
/*                                                            */
/*  SignatureAlgorithmIdentifier                              */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_SignatureAlgorithmIdentifier;

typedef ASN1T_AlgorithmIdentifier ASN1T_SignatureAlgorithmIdentifier;

class EXTERN ASN1C_SignatureAlgorithmIdentifier :
   public ASN1C_AlgorithmIdentifier
{
protected:
public:
   ASN1C_SignatureAlgorithmIdentifier (ASN1T_SignatureAlgorithmIdentifier& data);
   ASN1C_SignatureAlgorithmIdentifier (
      ASN1MessageBufferIF& msgBuf, ASN1T_SignatureAlgorithmIdentifier& data);
   ASN1C_SignatureAlgorithmIdentifier (ASN1C_SignatureAlgorithmIdentifier& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_SignatureAlgorithmIdentifier& getCopy (ASN1T_SignatureAlgorithmIdentifier* pDstData = 0);
   ASN1T_SignatureAlgorithmIdentifier* newCopy ();

   inline ASN1C_SignatureAlgorithmIdentifier& operator= (ASN1C_SignatureAlgorithmIdentifier& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_SignatureAlgorithmIdentifier (ASN1CTXT* pctxt,
   ASN1T_SignatureAlgorithmIdentifier *pvalue, ASN1TagType tagging);

EXTERN int asn1D_SignatureAlgorithmIdentifier (ASN1CTXT* pctxt,
   ASN1T_SignatureAlgorithmIdentifier *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_SignatureAlgorithmIdentifier (ASN1CTXT *pctxt, ASN1T_SignatureAlgorithmIdentifier* pSrcValue, ASN1T_SignatureAlgorithmIdentifier* pDstValue);

EXTERN void asn1Free_SignatureAlgorithmIdentifier (ASN1CTXT *pctxt, ASN1T_SignatureAlgorithmIdentifier* pvalue);

/**************************************************************/
/*                                                            */
/*  KeyEncryptionAlgorithmIdentifier                          */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_KeyEncryptionAlgorithmIdentifier;

typedef ASN1T_AlgorithmIdentifier ASN1T_KeyEncryptionAlgorithmIdentifier;

class EXTERN ASN1C_KeyEncryptionAlgorithmIdentifier :
   public ASN1C_AlgorithmIdentifier
{
protected:
public:
   ASN1C_KeyEncryptionAlgorithmIdentifier (ASN1T_KeyEncryptionAlgorithmIdentifier& data);
   ASN1C_KeyEncryptionAlgorithmIdentifier (
      ASN1MessageBufferIF& msgBuf, ASN1T_KeyEncryptionAlgorithmIdentifier& data);
   ASN1C_KeyEncryptionAlgorithmIdentifier (ASN1C_KeyEncryptionAlgorithmIdentifier& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_KeyEncryptionAlgorithmIdentifier& getCopy (ASN1T_KeyEncryptionAlgorithmIdentifier* pDstData = 0);
   ASN1T_KeyEncryptionAlgorithmIdentifier* newCopy ();

   inline ASN1C_KeyEncryptionAlgorithmIdentifier& operator= (ASN1C_KeyEncryptionAlgorithmIdentifier& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_KeyEncryptionAlgorithmIdentifier (ASN1CTXT* pctxt,
   ASN1T_KeyEncryptionAlgorithmIdentifier *pvalue, ASN1TagType tagging);

EXTERN int asn1D_KeyEncryptionAlgorithmIdentifier (ASN1CTXT* pctxt,
   ASN1T_KeyEncryptionAlgorithmIdentifier *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_KeyEncryptionAlgorithmIdentifier (ASN1CTXT *pctxt, ASN1T_KeyEncryptionAlgorithmIdentifier* pSrcValue, ASN1T_KeyEncryptionAlgorithmIdentifier* pDstValue);

EXTERN void asn1Free_KeyEncryptionAlgorithmIdentifier (ASN1CTXT *pctxt, ASN1T_KeyEncryptionAlgorithmIdentifier* pvalue);

/**************************************************************/
/*                                                            */
/*  ContentEncryptionAlgorithmIdentifier                      */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_ContentEncryptionAlgorithmIdentifier;

typedef ASN1T_AlgorithmIdentifier ASN1T_ContentEncryptionAlgorithmIdentifier;

class EXTERN ASN1C_ContentEncryptionAlgorithmIdentifier :
   public ASN1C_AlgorithmIdentifier
{
protected:
public:
   ASN1C_ContentEncryptionAlgorithmIdentifier (ASN1T_ContentEncryptionAlgorithmIdentifier& data);
   ASN1C_ContentEncryptionAlgorithmIdentifier (
      ASN1MessageBufferIF& msgBuf, ASN1T_ContentEncryptionAlgorithmIdentifier& data);
   ASN1C_ContentEncryptionAlgorithmIdentifier (ASN1C_ContentEncryptionAlgorithmIdentifier& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_ContentEncryptionAlgorithmIdentifier& getCopy (ASN1T_ContentEncryptionAlgorithmIdentifier* pDstData = 0);
   ASN1T_ContentEncryptionAlgorithmIdentifier* newCopy ();

   inline ASN1C_ContentEncryptionAlgorithmIdentifier& operator= (ASN1C_ContentEncryptionAlgorithmIdentifier& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_ContentEncryptionAlgorithmIdentifier (ASN1CTXT* pctxt,
   ASN1T_ContentEncryptionAlgorithmIdentifier *pvalue, ASN1TagType tagging);

EXTERN int asn1D_ContentEncryptionAlgorithmIdentifier (ASN1CTXT* pctxt,
   ASN1T_ContentEncryptionAlgorithmIdentifier *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_ContentEncryptionAlgorithmIdentifier (ASN1CTXT *pctxt, ASN1T_ContentEncryptionAlgorithmIdentifier* pSrcValue, ASN1T_ContentEncryptionAlgorithmIdentifier* pDstValue);

EXTERN void asn1Free_ContentEncryptionAlgorithmIdentifier (ASN1CTXT *pctxt, ASN1T_ContentEncryptionAlgorithmIdentifier* pvalue);

/**************************************************************/
/*                                                            */
/*  MessageAuthenticationCodeAlgorithm                        */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_MessageAuthenticationCodeAlgorithm;

typedef ASN1T_AlgorithmIdentifier ASN1T_MessageAuthenticationCodeAlgorithm;

class EXTERN ASN1C_MessageAuthenticationCodeAlgorithm :
   public ASN1C_AlgorithmIdentifier
{
protected:
public:
   ASN1C_MessageAuthenticationCodeAlgorithm (ASN1T_MessageAuthenticationCodeAlgorithm& data);
   ASN1C_MessageAuthenticationCodeAlgorithm (
      ASN1MessageBufferIF& msgBuf, ASN1T_MessageAuthenticationCodeAlgorithm& data);
   ASN1C_MessageAuthenticationCodeAlgorithm (ASN1C_MessageAuthenticationCodeAlgorithm& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_MessageAuthenticationCodeAlgorithm& getCopy (ASN1T_MessageAuthenticationCodeAlgorithm* pDstData = 0);
   ASN1T_MessageAuthenticationCodeAlgorithm* newCopy ();

   inline ASN1C_MessageAuthenticationCodeAlgorithm& operator= (ASN1C_MessageAuthenticationCodeAlgorithm& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_MessageAuthenticationCodeAlgorithm (ASN1CTXT* pctxt,
   ASN1T_MessageAuthenticationCodeAlgorithm *pvalue, ASN1TagType tagging);

EXTERN int asn1D_MessageAuthenticationCodeAlgorithm (ASN1CTXT* pctxt,
   ASN1T_MessageAuthenticationCodeAlgorithm *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_MessageAuthenticationCodeAlgorithm (ASN1CTXT *pctxt, ASN1T_MessageAuthenticationCodeAlgorithm* pSrcValue, ASN1T_MessageAuthenticationCodeAlgorithm* pDstValue);

EXTERN void asn1Free_MessageAuthenticationCodeAlgorithm (ASN1CTXT *pctxt, ASN1T_MessageAuthenticationCodeAlgorithm* pvalue);

/**************************************************************/
/*                                                            */
/*  KeyDerivationAlgorithmIdentifier                          */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_KeyDerivationAlgorithmIdentifier;

typedef ASN1T_AlgorithmIdentifier ASN1T_KeyDerivationAlgorithmIdentifier;

class EXTERN ASN1C_KeyDerivationAlgorithmIdentifier :
   public ASN1C_AlgorithmIdentifier
{
protected:
public:
   ASN1C_KeyDerivationAlgorithmIdentifier (ASN1T_KeyDerivationAlgorithmIdentifier& data);
   ASN1C_KeyDerivationAlgorithmIdentifier (
      ASN1MessageBufferIF& msgBuf, ASN1T_KeyDerivationAlgorithmIdentifier& data);
   ASN1C_KeyDerivationAlgorithmIdentifier (ASN1C_KeyDerivationAlgorithmIdentifier& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_KeyDerivationAlgorithmIdentifier& getCopy (ASN1T_KeyDerivationAlgorithmIdentifier* pDstData = 0);
   ASN1T_KeyDerivationAlgorithmIdentifier* newCopy ();

   inline ASN1C_KeyDerivationAlgorithmIdentifier& operator= (ASN1C_KeyDerivationAlgorithmIdentifier& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_KeyDerivationAlgorithmIdentifier (ASN1CTXT* pctxt,
   ASN1T_KeyDerivationAlgorithmIdentifier *pvalue, ASN1TagType tagging);

EXTERN int asn1D_KeyDerivationAlgorithmIdentifier (ASN1CTXT* pctxt,
   ASN1T_KeyDerivationAlgorithmIdentifier *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_KeyDerivationAlgorithmIdentifier (ASN1CTXT *pctxt, ASN1T_KeyDerivationAlgorithmIdentifier* pSrcValue, ASN1T_KeyDerivationAlgorithmIdentifier* pDstValue);

EXTERN void asn1Free_KeyDerivationAlgorithmIdentifier (ASN1CTXT *pctxt, ASN1T_KeyDerivationAlgorithmIdentifier* pvalue);

/**************************************************************/
/*                                                            */
/*  CMSVersion                                                */
/*                                                            */
/**************************************************************/

struct EXTERN CMSVersion {
   enum Root {
      cms_v0 = 0,
      cms_v1 = 1,
      cms_v2 = 2,
      cms_v3 = 3,
      cms_v4 = 4
   } ;
} ;

typedef ASN1UINT ASN1T_CMSVersion;

class EXTERN ASN1C_CMSVersion :
   public ASN1CType
{
protected:
   ASN1T_CMSVersion& msgData;
public:
   ASN1C_CMSVersion (ASN1T_CMSVersion& data);
   ASN1C_CMSVersion (
      ASN1MessageBufferIF& msgBuf, ASN1T_CMSVersion& data);
   ASN1C_CMSVersion (ASN1C_CMSVersion& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_CMSVersion& getCopy (ASN1T_CMSVersion* pDstData = 0);
   ASN1T_CMSVersion* newCopy ();

   inline ASN1C_CMSVersion& operator= (ASN1C_CMSVersion& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_CMSVersion (ASN1CTXT* pctxt,
   ASN1T_CMSVersion *pvalue, ASN1TagType tagging);

EXTERN int asn1D_CMSVersion (ASN1CTXT* pctxt,
   ASN1T_CMSVersion *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_CMSVersion (ASN1CTXT *pctxt, ASN1T_CMSVersion* pSrcValue, ASN1T_CMSVersion* pDstValue);

/**************************************************************/
/*                                                            */
/*  UserKeyingMaterial                                        */
/*                                                            */
/**************************************************************/

typedef ASN1TDynOctStr ASN1T_UserKeyingMaterial;

class EXTERN ASN1C_UserKeyingMaterial :
   public ASN1CType
{
protected:
   ASN1T_UserKeyingMaterial& msgData;
public:
   ASN1C_UserKeyingMaterial (ASN1T_UserKeyingMaterial& data);
   ASN1C_UserKeyingMaterial (
      ASN1MessageBufferIF& msgBuf, ASN1T_UserKeyingMaterial& data);
   ASN1C_UserKeyingMaterial (ASN1C_UserKeyingMaterial& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_UserKeyingMaterial& getCopy (ASN1T_UserKeyingMaterial* pDstData = 0);
   ASN1T_UserKeyingMaterial* newCopy ();

   inline ASN1C_UserKeyingMaterial& operator= (ASN1C_UserKeyingMaterial& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_UserKeyingMaterial (ASN1CTXT* pctxt,
   ASN1T_UserKeyingMaterial *pvalue, ASN1TagType tagging);

EXTERN int asn1D_UserKeyingMaterial (ASN1CTXT* pctxt,
   ASN1T_UserKeyingMaterial *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_UserKeyingMaterial (ASN1CTXT *pctxt, ASN1T_UserKeyingMaterial* pSrcValue, ASN1T_UserKeyingMaterial* pDstValue);

EXTERN void asn1Free_UserKeyingMaterial (ASN1CTXT *pctxt, ASN1T_UserKeyingMaterial* pvalue);

/**************************************************************/
/*                                                            */
/*  MessageDigest                                             */
/*                                                            */
/**************************************************************/

typedef ASN1TDynOctStr ASN1T_MessageDigest;

class EXTERN ASN1C_MessageDigest :
   public ASN1CType
{
protected:
   ASN1T_MessageDigest& msgData;
public:
   ASN1C_MessageDigest (ASN1T_MessageDigest& data);
   ASN1C_MessageDigest (
      ASN1MessageBufferIF& msgBuf, ASN1T_MessageDigest& data);
   ASN1C_MessageDigest (ASN1C_MessageDigest& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_MessageDigest& getCopy (ASN1T_MessageDigest* pDstData = 0);
   ASN1T_MessageDigest* newCopy ();

   inline ASN1C_MessageDigest& operator= (ASN1C_MessageDigest& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_MessageDigest (ASN1CTXT* pctxt,
   ASN1T_MessageDigest *pvalue, ASN1TagType tagging);

EXTERN int asn1D_MessageDigest (ASN1CTXT* pctxt,
   ASN1T_MessageDigest *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_MessageDigest (ASN1CTXT *pctxt, ASN1T_MessageDigest* pSrcValue, ASN1T_MessageDigest* pDstValue);

EXTERN void asn1Free_MessageDigest (ASN1CTXT *pctxt, ASN1T_MessageDigest* pvalue);

/**************************************************************/
/*                                                            */
/*  SigningTime                                               */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_SigningTime;

typedef ASN1T_Time ASN1T_SigningTime;

class EXTERN ASN1C_SigningTime :
   public ASN1C_Time
{
protected:
public:
   ASN1C_SigningTime (ASN1T_SigningTime& data);
   ASN1C_SigningTime (
      ASN1MessageBufferIF& msgBuf, ASN1T_SigningTime& data);
   ASN1C_SigningTime (ASN1C_SigningTime& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_SigningTime& getCopy (ASN1T_SigningTime* pDstData = 0);
   ASN1T_SigningTime* newCopy ();

   inline ASN1C_SigningTime& operator= (ASN1C_SigningTime& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_SigningTime (ASN1CTXT* pctxt,
   ASN1T_SigningTime *pvalue, ASN1TagType tagging);

EXTERN int asn1D_SigningTime (ASN1CTXT* pctxt,
   ASN1T_SigningTime *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_SigningTime (ASN1CTXT *pctxt, ASN1T_SigningTime* pSrcValue, ASN1T_SigningTime* pDstValue);

EXTERN void asn1Free_SigningTime (ASN1CTXT *pctxt, ASN1T_SigningTime* pvalue);

/**************************************************************/
/*                                                            */
/*  IssuerAndSerialNumber                                     */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_IssuerAndSerialNumber;

typedef struct EXTERN ASN1T_IssuerAndSerialNumber : public ASN1TPDU {
   ASN1TOpenType rawissuer;
   ASN1T_CertificateSerialNumber serialNumber;
   ASN1T_IssuerAndSerialNumber ();
   ASN1T_IssuerAndSerialNumber (ASN1C_IssuerAndSerialNumber& srcData);
   ~ASN1T_IssuerAndSerialNumber ();
} ASN1T_IssuerAndSerialNumber;

class EXTERN ASN1C_IssuerAndSerialNumber :
   public ASN1CType
{
protected:
   ASN1T_IssuerAndSerialNumber& msgData;
public:
   ASN1C_IssuerAndSerialNumber (ASN1T_IssuerAndSerialNumber& data);
   ASN1C_IssuerAndSerialNumber (
      ASN1MessageBufferIF& msgBuf, ASN1T_IssuerAndSerialNumber& data);
   ASN1C_IssuerAndSerialNumber (ASN1C_IssuerAndSerialNumber& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_IssuerAndSerialNumber& getCopy (ASN1T_IssuerAndSerialNumber* pDstData = 0);
   ASN1T_IssuerAndSerialNumber* newCopy ();

   inline ASN1C_IssuerAndSerialNumber& operator= (ASN1C_IssuerAndSerialNumber& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_IssuerAndSerialNumber (ASN1CTXT* pctxt,
   ASN1T_IssuerAndSerialNumber *pvalue, ASN1TagType tagging);

EXTERN int asn1D_IssuerAndSerialNumber (ASN1CTXT* pctxt,
   ASN1T_IssuerAndSerialNumber *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_IssuerAndSerialNumber (ASN1CTXT *pctxt, ASN1T_IssuerAndSerialNumber* pSrcValue, ASN1T_IssuerAndSerialNumber* pDstValue);

EXTERN void asn1Free_IssuerAndSerialNumber (ASN1CTXT *pctxt, ASN1T_IssuerAndSerialNumber* pvalue);

/**************************************************************/
/*                                                            */
/*  SignerIdentifier                                          */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_SignerIdentifier_issuerAndSerialNumber 1
#define T_SignerIdentifier_subjectKeyIdentifier 2

class EXTERN ASN1C_SignerIdentifier;

typedef struct EXTERN ASN1T_SignerIdentifier : public ASN1TPDU {
   int t;
   union {
      /* t = 1 */
      ASN1T_IssuerAndSerialNumber *issuerAndSerialNumber;
      /* t = 2 */
      ASN1T_SubjectKeyIdentifier *subjectKeyIdentifier;
   } u;
   ASN1T_SignerIdentifier () {}
   ASN1T_SignerIdentifier (ASN1C_SignerIdentifier& srcData);
   ~ASN1T_SignerIdentifier ();
} ASN1T_SignerIdentifier;

class EXTERN ASN1C_SignerIdentifier :
   public ASN1CType
{
protected:
   ASN1T_SignerIdentifier& msgData;
public:
   ASN1C_SignerIdentifier (ASN1T_SignerIdentifier& data);
   ASN1C_SignerIdentifier (
      ASN1MessageBufferIF& msgBuf, ASN1T_SignerIdentifier& data);
   ASN1C_SignerIdentifier (ASN1C_SignerIdentifier& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_SignerIdentifier& getCopy (ASN1T_SignerIdentifier* pDstData = 0);
   ASN1T_SignerIdentifier* newCopy ();

   inline ASN1C_SignerIdentifier& operator= (ASN1C_SignerIdentifier& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_SignerIdentifier (ASN1CTXT* pctxt,
   ASN1T_SignerIdentifier *pvalue, ASN1TagType tagging);

EXTERN int asn1D_SignerIdentifier (ASN1CTXT* pctxt,
   ASN1T_SignerIdentifier *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_SignerIdentifier (ASN1CTXT *pctxt, ASN1T_SignerIdentifier* pSrcValue, ASN1T_SignerIdentifier* pDstValue);

EXTERN void asn1Free_SignerIdentifier (ASN1CTXT *pctxt, ASN1T_SignerIdentifier* pvalue);

/**************************************************************/
/*                                                            */
/*  _simpleData_Type                                          */
/*                                                            */
/**************************************************************/

typedef ASN1TDynOctStr ASN1T__simpleData_Type;

class EXTERN ASN1C__simpleData_Type :
   public ASN1CType
{
protected:
   ASN1T__simpleData_Type& msgData;
public:
   ASN1C__simpleData_Type (ASN1T__simpleData_Type& data);
   ASN1C__simpleData_Type (
      ASN1MessageBufferIF& msgBuf, ASN1T__simpleData_Type& data);
   ASN1C__simpleData_Type (ASN1C__simpleData_Type& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T__simpleData_Type& getCopy (ASN1T__simpleData_Type* pDstData = 0);
   ASN1T__simpleData_Type* newCopy ();

   inline ASN1C__simpleData_Type& operator= (ASN1C__simpleData_Type& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E__simpleData_Type (ASN1CTXT* pctxt,
   ASN1T__simpleData_Type *pvalue, ASN1TagType tagging);

EXTERN int asn1D__simpleData_Type (ASN1CTXT* pctxt,
   ASN1T__simpleData_Type *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy__simpleData_Type (ASN1CTXT *pctxt, ASN1T__simpleData_Type* pSrcValue, ASN1T__simpleData_Type* pDstValue);

EXTERN void asn1Free__simpleData_Type (ASN1CTXT *pctxt, ASN1T__simpleData_Type* pvalue);

/**************************************************************/
/*                                                            */
/*  DigestAlgorithmIdentifiers                                */
/*                                                            */
/**************************************************************/

/* List of ASN1T_DigestAlgorithmIdentifier */
typedef struct EXTERN ASN1T_DigestAlgorithmIdentifiers : public ASN1TPDUSeqOfList {
   ~ASN1T_DigestAlgorithmIdentifiers();
} ASN1T_DigestAlgorithmIdentifiers;

class EXTERN ASN1C_DigestAlgorithmIdentifiers :
   public ASN1CSeqOfList
{
protected:
   ASN1T_DigestAlgorithmIdentifiers& msgData;
public:
   ASN1C_DigestAlgorithmIdentifiers (ASN1T_DigestAlgorithmIdentifiers& data);
   ASN1C_DigestAlgorithmIdentifiers (
      ASN1MessageBufferIF& msgBuf, ASN1T_DigestAlgorithmIdentifiers& data);
   ASN1C_DigestAlgorithmIdentifiers (ASN1C_DigestAlgorithmIdentifiers& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_DigestAlgorithmIdentifiers& getCopy (ASN1T_DigestAlgorithmIdentifiers* pDstData = 0);
   ASN1T_DigestAlgorithmIdentifiers* newCopy ();

   ASN1C_DigestAlgorithmIdentifiers& operator= (ASN1C_DigestAlgorithmIdentifiers& srcData);
   void Append (ASN1T_DigestAlgorithmIdentifier * elem) {
      append ((void*)elem);
   }
} ;

EXTERN int asn1E_DigestAlgorithmIdentifiers (ASN1CTXT* pctxt,
   ASN1T_DigestAlgorithmIdentifiers *pvalue, ASN1TagType tagging);

EXTERN int asn1D_DigestAlgorithmIdentifiers (ASN1CTXT* pctxt,
   ASN1T_DigestAlgorithmIdentifiers *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_DigestAlgorithmIdentifiers (ASN1CTXT *pctxt, ASN1T_DigestAlgorithmIdentifiers* pSrcValue, ASN1T_DigestAlgorithmIdentifiers* pDstValue);

EXTERN void asn1Free_DigestAlgorithmIdentifiers (ASN1CTXT *pctxt, ASN1T_DigestAlgorithmIdentifiers* pvalue);

/**************************************************************/
/*                                                            */
/*  UnauthAttributes                                          */
/*                                                            */
/**************************************************************/

/* List of ASN1T_Attribute */
typedef struct EXTERN ASN1T_UnauthAttributes : public ASN1TPDUSeqOfList {
   ~ASN1T_UnauthAttributes();
} ASN1T_UnauthAttributes;

class EXTERN ASN1C_UnauthAttributes :
   public ASN1CSeqOfList
{
protected:
   ASN1T_UnauthAttributes& msgData;
public:
   ASN1C_UnauthAttributes (ASN1T_UnauthAttributes& data);
   ASN1C_UnauthAttributes (
      ASN1MessageBufferIF& msgBuf, ASN1T_UnauthAttributes& data);
   ASN1C_UnauthAttributes (ASN1C_UnauthAttributes& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_UnauthAttributes& getCopy (ASN1T_UnauthAttributes* pDstData = 0);
   ASN1T_UnauthAttributes* newCopy ();

   ASN1C_UnauthAttributes& operator= (ASN1C_UnauthAttributes& srcData);
   void Append (ASN1T_Attribute * elem) {
      append ((void*)elem);
   }
} ;

EXTERN int asn1E_UnauthAttributes (ASN1CTXT* pctxt,
   ASN1T_UnauthAttributes *pvalue, ASN1TagType tagging);

EXTERN int asn1D_UnauthAttributes (ASN1CTXT* pctxt,
   ASN1T_UnauthAttributes *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_UnauthAttributes (ASN1CTXT *pctxt, ASN1T_UnauthAttributes* pSrcValue, ASN1T_UnauthAttributes* pDstValue);

EXTERN void asn1Free_UnauthAttributes (ASN1CTXT *pctxt, ASN1T_UnauthAttributes* pvalue);

/**************************************************************/
/*                                                            */
/*  ExtendedCertificateInfo                                   */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_ExtendedCertificateInfo;

typedef struct EXTERN ASN1T_ExtendedCertificateInfo : public ASN1TPDU {
   ASN1T_CMSVersion version;
   ASN1T_Certificate certificate;
   ASN1T_UnauthAttributes attributes;
   ASN1T_ExtendedCertificateInfo ();
   ASN1T_ExtendedCertificateInfo (ASN1C_ExtendedCertificateInfo& srcData);
   ~ASN1T_ExtendedCertificateInfo ();
} ASN1T_ExtendedCertificateInfo;

class EXTERN ASN1C_ExtendedCertificateInfo :
   public ASN1CType
{
protected:
   ASN1T_ExtendedCertificateInfo& msgData;
public:
   ASN1C_ExtendedCertificateInfo (ASN1T_ExtendedCertificateInfo& data);
   ASN1C_ExtendedCertificateInfo (
      ASN1MessageBufferIF& msgBuf, ASN1T_ExtendedCertificateInfo& data);
   ASN1C_ExtendedCertificateInfo (ASN1C_ExtendedCertificateInfo& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_ExtendedCertificateInfo& getCopy (ASN1T_ExtendedCertificateInfo* pDstData = 0);
   ASN1T_ExtendedCertificateInfo* newCopy ();

   inline ASN1C_ExtendedCertificateInfo& operator= (ASN1C_ExtendedCertificateInfo& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_ExtendedCertificateInfo (ASN1CTXT* pctxt,
   ASN1T_ExtendedCertificateInfo *pvalue, ASN1TagType tagging);

EXTERN int asn1D_ExtendedCertificateInfo (ASN1CTXT* pctxt,
   ASN1T_ExtendedCertificateInfo *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_ExtendedCertificateInfo (ASN1CTXT *pctxt, ASN1T_ExtendedCertificateInfo* pSrcValue, ASN1T_ExtendedCertificateInfo* pDstValue);

EXTERN void asn1Free_ExtendedCertificateInfo (ASN1CTXT *pctxt, ASN1T_ExtendedCertificateInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  Signature                                                 */
/*                                                            */
/**************************************************************/

typedef ASN1TDynBitStr ASN1T_Signature;

class EXTERN ASN1C_Signature :
   public ASN1CBitStr
{
protected:
   ASN1T_Signature& msgData;
public:
   ASN1C_Signature (ASN1T_Signature& data);
   ASN1C_Signature (
      ASN1MessageBufferIF& msgBuf, ASN1T_Signature& data);
   ASN1C_Signature (ASN1C_Signature& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_Signature& getCopy (ASN1T_Signature* pDstData = 0);
   ASN1T_Signature* newCopy ();

   ASN1C_Signature& operator= (ASN1C_Signature& srcData);
} ;

EXTERN int asn1E_Signature (ASN1CTXT* pctxt,
   ASN1T_Signature *pvalue, ASN1TagType tagging);

EXTERN int asn1D_Signature (ASN1CTXT* pctxt,
   ASN1T_Signature *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_Signature (ASN1CTXT *pctxt, ASN1T_Signature* pSrcValue, ASN1T_Signature* pDstValue);

EXTERN void asn1Free_Signature (ASN1CTXT *pctxt, ASN1T_Signature* pvalue);

/**************************************************************/
/*                                                            */
/*  ExtendedCertificate                                       */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_ExtendedCertificate;

typedef struct EXTERN ASN1T_ExtendedCertificate : public ASN1TPDU {
   ASN1T_ExtendedCertificateInfo extendedCertificateInfo;
   ASN1T_SignatureAlgorithmIdentifier signatureAlgorithm;
   ASN1T_Signature signature;
   ASN1T_ExtendedCertificate ();
   ASN1T_ExtendedCertificate (ASN1C_ExtendedCertificate& srcData);
   ~ASN1T_ExtendedCertificate ();
} ASN1T_ExtendedCertificate;

class EXTERN ASN1C_ExtendedCertificate :
   public ASN1CType
{
protected:
   ASN1T_ExtendedCertificate& msgData;
public:
   ASN1C_ExtendedCertificate (ASN1T_ExtendedCertificate& data);
   ASN1C_ExtendedCertificate (
      ASN1MessageBufferIF& msgBuf, ASN1T_ExtendedCertificate& data);
   ASN1C_ExtendedCertificate (ASN1C_ExtendedCertificate& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_ExtendedCertificate& getCopy (ASN1T_ExtendedCertificate* pDstData = 0);
   ASN1T_ExtendedCertificate* newCopy ();

   inline ASN1C_ExtendedCertificate& operator= (ASN1C_ExtendedCertificate& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_ExtendedCertificate (ASN1CTXT* pctxt,
   ASN1T_ExtendedCertificate *pvalue, ASN1TagType tagging);

EXTERN int asn1D_ExtendedCertificate (ASN1CTXT* pctxt,
   ASN1T_ExtendedCertificate *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_ExtendedCertificate (ASN1CTXT *pctxt, ASN1T_ExtendedCertificate* pSrcValue, ASN1T_ExtendedCertificate* pDstValue);

EXTERN void asn1Free_ExtendedCertificate (ASN1CTXT *pctxt, ASN1T_ExtendedCertificate* pvalue);

/**************************************************************/
/*                                                            */
/*  CertificateChoices                                        */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_CertificateChoices_certificate 1
#define T_CertificateChoices_extendedCertificate 2
#define T_CertificateChoices_attrCert   3

class EXTERN ASN1C_CertificateChoices;

typedef struct EXTERN ASN1T_CertificateChoices : public ASN1TPDU {
   int t;
   union {
      /* t = 1 */
      ASN1T_Certificate *certificate;
      /* t = 2 */
      ASN1T_ExtendedCertificate *extendedCertificate;
      /* t = 3 */
      ASN1T_AttributeCertificate *attrCert;
   } u;
   ASN1T_CertificateChoices () {}
   ASN1T_CertificateChoices (ASN1C_CertificateChoices& srcData);
   ~ASN1T_CertificateChoices ();
} ASN1T_CertificateChoices;

class EXTERN ASN1C_CertificateChoices :
   public ASN1CType
{
protected:
   ASN1T_CertificateChoices& msgData;
public:
   ASN1C_CertificateChoices (ASN1T_CertificateChoices& data);
   ASN1C_CertificateChoices (
      ASN1MessageBufferIF& msgBuf, ASN1T_CertificateChoices& data);
   ASN1C_CertificateChoices (ASN1C_CertificateChoices& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_CertificateChoices& getCopy (ASN1T_CertificateChoices* pDstData = 0);
   ASN1T_CertificateChoices* newCopy ();

   inline ASN1C_CertificateChoices& operator= (ASN1C_CertificateChoices& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_CertificateChoices (ASN1CTXT* pctxt,
   ASN1T_CertificateChoices *pvalue, ASN1TagType tagging);

EXTERN int asn1D_CertificateChoices (ASN1CTXT* pctxt,
   ASN1T_CertificateChoices *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_CertificateChoices (ASN1CTXT *pctxt, ASN1T_CertificateChoices* pSrcValue, ASN1T_CertificateChoices* pDstValue);

EXTERN void asn1Free_CertificateChoices (ASN1CTXT *pctxt, ASN1T_CertificateChoices* pvalue);

/**************************************************************/
/*                                                            */
/*  CertificateSet                                            */
/*                                                            */
/**************************************************************/

/* List of ASN1T_CertificateChoices */
typedef struct EXTERN ASN1T_CertificateSet : public ASN1TPDUSeqOfList {
   ~ASN1T_CertificateSet();
} ASN1T_CertificateSet;

class EXTERN ASN1C_CertificateSet :
   public ASN1CSeqOfList
{
protected:
   ASN1T_CertificateSet& msgData;
public:
   ASN1C_CertificateSet (ASN1T_CertificateSet& data);
   ASN1C_CertificateSet (
      ASN1MessageBufferIF& msgBuf, ASN1T_CertificateSet& data);
   ASN1C_CertificateSet (ASN1C_CertificateSet& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_CertificateSet& getCopy (ASN1T_CertificateSet* pDstData = 0);
   ASN1T_CertificateSet* newCopy ();

   ASN1C_CertificateSet& operator= (ASN1C_CertificateSet& srcData);
   void Append (ASN1T_CertificateChoices * elem) {
      append ((void*)elem);
   }
} ;

EXTERN int asn1E_CertificateSet (ASN1CTXT* pctxt,
   ASN1T_CertificateSet *pvalue, ASN1TagType tagging);

EXTERN int asn1D_CertificateSet (ASN1CTXT* pctxt,
   ASN1T_CertificateSet *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_CertificateSet (ASN1CTXT *pctxt, ASN1T_CertificateSet* pSrcValue, ASN1T_CertificateSet* pDstValue);

EXTERN void asn1Free_CertificateSet (ASN1CTXT *pctxt, ASN1T_CertificateSet* pvalue);

/**************************************************************/
/*                                                            */
/*  CertificateRevocationLists                                */
/*                                                            */
/**************************************************************/

/* List of ASN1T_CertificateList */
typedef struct EXTERN ASN1T_CertificateRevocationLists : public ASN1TPDUSeqOfList {
   ~ASN1T_CertificateRevocationLists();
} ASN1T_CertificateRevocationLists;

class EXTERN ASN1C_CertificateRevocationLists :
   public ASN1CSeqOfList
{
protected:
   ASN1T_CertificateRevocationLists& msgData;
public:
   ASN1C_CertificateRevocationLists (ASN1T_CertificateRevocationLists& data);
   ASN1C_CertificateRevocationLists (
      ASN1MessageBufferIF& msgBuf, ASN1T_CertificateRevocationLists& data);
   ASN1C_CertificateRevocationLists (ASN1C_CertificateRevocationLists& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_CertificateRevocationLists& getCopy (ASN1T_CertificateRevocationLists* pDstData = 0);
   ASN1T_CertificateRevocationLists* newCopy ();

   ASN1C_CertificateRevocationLists& operator= (ASN1C_CertificateRevocationLists& srcData);
   void Append (ASN1T_CertificateList * elem) {
      append ((void*)elem);
   }
} ;

EXTERN int asn1E_CertificateRevocationLists (ASN1CTXT* pctxt,
   ASN1T_CertificateRevocationLists *pvalue, ASN1TagType tagging);

EXTERN int asn1D_CertificateRevocationLists (ASN1CTXT* pctxt,
   ASN1T_CertificateRevocationLists *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_CertificateRevocationLists (ASN1CTXT *pctxt, ASN1T_CertificateRevocationLists* pSrcValue, ASN1T_CertificateRevocationLists* pDstValue);

EXTERN void asn1Free_CertificateRevocationLists (ASN1CTXT *pctxt, ASN1T_CertificateRevocationLists* pvalue);

/**************************************************************/
/*                                                            */
/*  OriginatorInfo                                            */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_OriginatorInfo;

typedef struct EXTERN ASN1T_OriginatorInfo : public ASN1TPDU {
   struct {
      unsigned certsPresent : 1;
      unsigned crlsPresent : 1;
   } m;
   ASN1T_CertificateSet certs;
   ASN1T_CertificateRevocationLists crls;
   ASN1T_OriginatorInfo ();
   ASN1T_OriginatorInfo (ASN1C_OriginatorInfo& srcData);
   ~ASN1T_OriginatorInfo ();
} ASN1T_OriginatorInfo;

class EXTERN ASN1C_OriginatorInfo :
   public ASN1CType
{
protected:
   ASN1T_OriginatorInfo& msgData;
public:
   ASN1C_OriginatorInfo (ASN1T_OriginatorInfo& data);
   ASN1C_OriginatorInfo (
      ASN1MessageBufferIF& msgBuf, ASN1T_OriginatorInfo& data);
   ASN1C_OriginatorInfo (ASN1C_OriginatorInfo& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_OriginatorInfo& getCopy (ASN1T_OriginatorInfo* pDstData = 0);
   ASN1T_OriginatorInfo* newCopy ();

   inline ASN1C_OriginatorInfo& operator= (ASN1C_OriginatorInfo& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_OriginatorInfo (ASN1CTXT* pctxt,
   ASN1T_OriginatorInfo *pvalue, ASN1TagType tagging);

EXTERN int asn1D_OriginatorInfo (ASN1CTXT* pctxt,
   ASN1T_OriginatorInfo *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_OriginatorInfo (ASN1CTXT *pctxt, ASN1T_OriginatorInfo* pSrcValue, ASN1T_OriginatorInfo* pDstValue);

EXTERN void asn1Free_OriginatorInfo (ASN1CTXT *pctxt, ASN1T_OriginatorInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  RecipientIdentifier                                       */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_RecipientIdentifier_issuerAndSerialNumber 1
#define T_RecipientIdentifier_subjectKeyIdentifier 2

class EXTERN ASN1C_RecipientIdentifier;

typedef struct EXTERN ASN1T_RecipientIdentifier : public ASN1TPDU {
   int t;
   union {
      /* t = 1 */
      ASN1T_IssuerAndSerialNumber *issuerAndSerialNumber;
      /* t = 2 */
      ASN1T_SubjectKeyIdentifier *subjectKeyIdentifier;
   } u;
   ASN1T_RecipientIdentifier () {}
   ASN1T_RecipientIdentifier (ASN1C_RecipientIdentifier& srcData);
   ~ASN1T_RecipientIdentifier ();
} ASN1T_RecipientIdentifier;

class EXTERN ASN1C_RecipientIdentifier :
   public ASN1CType
{
protected:
   ASN1T_RecipientIdentifier& msgData;
public:
   ASN1C_RecipientIdentifier (ASN1T_RecipientIdentifier& data);
   ASN1C_RecipientIdentifier (
      ASN1MessageBufferIF& msgBuf, ASN1T_RecipientIdentifier& data);
   ASN1C_RecipientIdentifier (ASN1C_RecipientIdentifier& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_RecipientIdentifier& getCopy (ASN1T_RecipientIdentifier* pDstData = 0);
   ASN1T_RecipientIdentifier* newCopy ();

   inline ASN1C_RecipientIdentifier& operator= (ASN1C_RecipientIdentifier& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_RecipientIdentifier (ASN1CTXT* pctxt,
   ASN1T_RecipientIdentifier *pvalue, ASN1TagType tagging);

EXTERN int asn1D_RecipientIdentifier (ASN1CTXT* pctxt,
   ASN1T_RecipientIdentifier *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_RecipientIdentifier (ASN1CTXT *pctxt, ASN1T_RecipientIdentifier* pSrcValue, ASN1T_RecipientIdentifier* pDstValue);

EXTERN void asn1Free_RecipientIdentifier (ASN1CTXT *pctxt, ASN1T_RecipientIdentifier* pvalue);

/**************************************************************/
/*                                                            */
/*  KeyTransRecipientInfo                                     */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_KeyTransRecipientInfo;

typedef struct EXTERN ASN1T_KeyTransRecipientInfo : public ASN1TPDU {
   ASN1T_CMSVersion version;
   ASN1T_RecipientIdentifier rid;
   ASN1T_KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm;
   ASN1T_EncryptedKey encryptedKey;
   ASN1T_KeyTransRecipientInfo ();
   ASN1T_KeyTransRecipientInfo (ASN1C_KeyTransRecipientInfo& srcData);
   ~ASN1T_KeyTransRecipientInfo ();
} ASN1T_KeyTransRecipientInfo;

class EXTERN ASN1C_KeyTransRecipientInfo :
   public ASN1CType
{
protected:
   ASN1T_KeyTransRecipientInfo& msgData;
public:
   ASN1C_KeyTransRecipientInfo (ASN1T_KeyTransRecipientInfo& data);
   ASN1C_KeyTransRecipientInfo (
      ASN1MessageBufferIF& msgBuf, ASN1T_KeyTransRecipientInfo& data);
   ASN1C_KeyTransRecipientInfo (ASN1C_KeyTransRecipientInfo& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_KeyTransRecipientInfo& getCopy (ASN1T_KeyTransRecipientInfo* pDstData = 0);
   ASN1T_KeyTransRecipientInfo* newCopy ();

   inline ASN1C_KeyTransRecipientInfo& operator= (ASN1C_KeyTransRecipientInfo& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_KeyTransRecipientInfo (ASN1CTXT* pctxt,
   ASN1T_KeyTransRecipientInfo *pvalue, ASN1TagType tagging);

EXTERN int asn1D_KeyTransRecipientInfo (ASN1CTXT* pctxt,
   ASN1T_KeyTransRecipientInfo *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_KeyTransRecipientInfo (ASN1CTXT *pctxt, ASN1T_KeyTransRecipientInfo* pSrcValue, ASN1T_KeyTransRecipientInfo* pDstValue);

EXTERN void asn1Free_KeyTransRecipientInfo (ASN1CTXT *pctxt, ASN1T_KeyTransRecipientInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  OriginatorPublicKey                                       */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_OriginatorPublicKey;

typedef struct EXTERN ASN1T_OriginatorPublicKey : public ASN1TPDU {
   ASN1T_AlgorithmIdentifier algorithm;
   ASN1TDynBitStr publicKey;
   ASN1T_OriginatorPublicKey ();
   ASN1T_OriginatorPublicKey (ASN1C_OriginatorPublicKey& srcData);
   ~ASN1T_OriginatorPublicKey ();
} ASN1T_OriginatorPublicKey;

class EXTERN ASN1C_OriginatorPublicKey :
   public ASN1CType
{
protected:
   ASN1T_OriginatorPublicKey& msgData;
public:
   ASN1C_OriginatorPublicKey (ASN1T_OriginatorPublicKey& data);
   ASN1C_OriginatorPublicKey (
      ASN1MessageBufferIF& msgBuf, ASN1T_OriginatorPublicKey& data);
   ASN1C_OriginatorPublicKey (ASN1C_OriginatorPublicKey& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_OriginatorPublicKey& getCopy (ASN1T_OriginatorPublicKey* pDstData = 0);
   ASN1T_OriginatorPublicKey* newCopy ();

   inline ASN1C_OriginatorPublicKey& operator= (ASN1C_OriginatorPublicKey& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_OriginatorPublicKey (ASN1CTXT* pctxt,
   ASN1T_OriginatorPublicKey *pvalue, ASN1TagType tagging);

EXTERN int asn1D_OriginatorPublicKey (ASN1CTXT* pctxt,
   ASN1T_OriginatorPublicKey *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_OriginatorPublicKey (ASN1CTXT *pctxt, ASN1T_OriginatorPublicKey* pSrcValue, ASN1T_OriginatorPublicKey* pDstValue);

EXTERN void asn1Free_OriginatorPublicKey (ASN1CTXT *pctxt, ASN1T_OriginatorPublicKey* pvalue);

/**************************************************************/
/*                                                            */
/*  OriginatorIdentifierOrKey                                 */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_OriginatorIdentifierOrKey_issuerAndSerialNumber 1
#define T_OriginatorIdentifierOrKey_subjectKeyIdentifier 2
#define T_OriginatorIdentifierOrKey_originatorKey 3

class EXTERN ASN1C_OriginatorIdentifierOrKey;

typedef struct EXTERN ASN1T_OriginatorIdentifierOrKey : public ASN1TPDU {
   int t;
   union {
      /* t = 1 */
      ASN1T_IssuerAndSerialNumber *issuerAndSerialNumber;
      /* t = 2 */
      ASN1T_SubjectKeyIdentifier *subjectKeyIdentifier;
      /* t = 3 */
      ASN1T_OriginatorPublicKey *originatorKey;
   } u;
   ASN1T_OriginatorIdentifierOrKey () {}
   ASN1T_OriginatorIdentifierOrKey (ASN1C_OriginatorIdentifierOrKey& srcData);
   ~ASN1T_OriginatorIdentifierOrKey ();
} ASN1T_OriginatorIdentifierOrKey;

class EXTERN ASN1C_OriginatorIdentifierOrKey :
   public ASN1CType
{
protected:
   ASN1T_OriginatorIdentifierOrKey& msgData;
public:
   ASN1C_OriginatorIdentifierOrKey (ASN1T_OriginatorIdentifierOrKey& data);
   ASN1C_OriginatorIdentifierOrKey (
      ASN1MessageBufferIF& msgBuf, ASN1T_OriginatorIdentifierOrKey& data);
   ASN1C_OriginatorIdentifierOrKey (ASN1C_OriginatorIdentifierOrKey& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_OriginatorIdentifierOrKey& getCopy (ASN1T_OriginatorIdentifierOrKey* pDstData = 0);
   ASN1T_OriginatorIdentifierOrKey* newCopy ();

   inline ASN1C_OriginatorIdentifierOrKey& operator= (ASN1C_OriginatorIdentifierOrKey& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_OriginatorIdentifierOrKey (ASN1CTXT* pctxt,
   ASN1T_OriginatorIdentifierOrKey *pvalue, ASN1TagType tagging);

EXTERN int asn1D_OriginatorIdentifierOrKey (ASN1CTXT* pctxt,
   ASN1T_OriginatorIdentifierOrKey *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_OriginatorIdentifierOrKey (ASN1CTXT *pctxt, ASN1T_OriginatorIdentifierOrKey* pSrcValue, ASN1T_OriginatorIdentifierOrKey* pDstValue);

EXTERN void asn1Free_OriginatorIdentifierOrKey (ASN1CTXT *pctxt, ASN1T_OriginatorIdentifierOrKey* pvalue);

/**************************************************************/
/*                                                            */
/*  OtherKeyAttribute                                         */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_OtherKeyAttribute;

typedef struct EXTERN ASN1T_OtherKeyAttribute : public ASN1TPDU {
   struct {
      unsigned keyAttrPresent : 1;
   } m;
   ASN1TObjId keyAttrId;
   ASN1TOpenType keyAttr;
   ASN1T_OtherKeyAttribute ();
   ASN1T_OtherKeyAttribute (ASN1C_OtherKeyAttribute& srcData);
   ~ASN1T_OtherKeyAttribute ();
} ASN1T_OtherKeyAttribute;

class EXTERN ASN1C_OtherKeyAttribute :
   public ASN1CType
{
protected:
   ASN1T_OtherKeyAttribute& msgData;
public:
   ASN1C_OtherKeyAttribute (ASN1T_OtherKeyAttribute& data);
   ASN1C_OtherKeyAttribute (
      ASN1MessageBufferIF& msgBuf, ASN1T_OtherKeyAttribute& data);
   ASN1C_OtherKeyAttribute (ASN1C_OtherKeyAttribute& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_OtherKeyAttribute& getCopy (ASN1T_OtherKeyAttribute* pDstData = 0);
   ASN1T_OtherKeyAttribute* newCopy ();

   inline ASN1C_OtherKeyAttribute& operator= (ASN1C_OtherKeyAttribute& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_OtherKeyAttribute (ASN1CTXT* pctxt,
   ASN1T_OtherKeyAttribute *pvalue, ASN1TagType tagging);

EXTERN int asn1D_OtherKeyAttribute (ASN1CTXT* pctxt,
   ASN1T_OtherKeyAttribute *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_OtherKeyAttribute (ASN1CTXT *pctxt, ASN1T_OtherKeyAttribute* pSrcValue, ASN1T_OtherKeyAttribute* pDstValue);

EXTERN void asn1Free_OtherKeyAttribute (ASN1CTXT *pctxt, ASN1T_OtherKeyAttribute* pvalue);

/**************************************************************/
/*                                                            */
/*  RecipientKeyIdentifier                                    */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_RecipientKeyIdentifier;

typedef struct EXTERN ASN1T_RecipientKeyIdentifier : public ASN1TPDU {
   struct {
      unsigned datePresent : 1;
      unsigned otherPresent : 1;
   } m;
   ASN1T_SubjectKeyIdentifier subjectKeyIdentifier;
   ASN1GeneralizedTime date;
   ASN1T_OtherKeyAttribute other;
   ASN1T_RecipientKeyIdentifier ();
   ASN1T_RecipientKeyIdentifier (ASN1C_RecipientKeyIdentifier& srcData);
   ~ASN1T_RecipientKeyIdentifier ();
} ASN1T_RecipientKeyIdentifier;

class EXTERN ASN1C_RecipientKeyIdentifier :
   public ASN1CType
{
protected:
   ASN1T_RecipientKeyIdentifier& msgData;
public:
   ASN1C_RecipientKeyIdentifier (ASN1T_RecipientKeyIdentifier& data);
   ASN1C_RecipientKeyIdentifier (
      ASN1MessageBufferIF& msgBuf, ASN1T_RecipientKeyIdentifier& data);
   ASN1C_RecipientKeyIdentifier (ASN1C_RecipientKeyIdentifier& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_RecipientKeyIdentifier& getCopy (ASN1T_RecipientKeyIdentifier* pDstData = 0);
   ASN1T_RecipientKeyIdentifier* newCopy ();

   inline ASN1C_RecipientKeyIdentifier& operator= (ASN1C_RecipientKeyIdentifier& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_RecipientKeyIdentifier (ASN1CTXT* pctxt,
   ASN1T_RecipientKeyIdentifier *pvalue, ASN1TagType tagging);

EXTERN int asn1D_RecipientKeyIdentifier (ASN1CTXT* pctxt,
   ASN1T_RecipientKeyIdentifier *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_RecipientKeyIdentifier (ASN1CTXT *pctxt, ASN1T_RecipientKeyIdentifier* pSrcValue, ASN1T_RecipientKeyIdentifier* pDstValue);

EXTERN void asn1Free_RecipientKeyIdentifier (ASN1CTXT *pctxt, ASN1T_RecipientKeyIdentifier* pvalue);

/**************************************************************/
/*                                                            */
/*  KeyAgreeRecipientIdentifier                               */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_KeyAgreeRecipientIdentifier_issuerAndSerialNumber 1
#define T_KeyAgreeRecipientIdentifier_rKeyId 2

class EXTERN ASN1C_KeyAgreeRecipientIdentifier;

typedef struct EXTERN ASN1T_KeyAgreeRecipientIdentifier : public ASN1TPDU {
   int t;
   union {
      /* t = 1 */
      ASN1T_IssuerAndSerialNumber *issuerAndSerialNumber;
      /* t = 2 */
      ASN1T_RecipientKeyIdentifier *rKeyId;
   } u;
   ASN1T_KeyAgreeRecipientIdentifier () {}
   ASN1T_KeyAgreeRecipientIdentifier (ASN1C_KeyAgreeRecipientIdentifier& srcData);
   ~ASN1T_KeyAgreeRecipientIdentifier ();
} ASN1T_KeyAgreeRecipientIdentifier;

class EXTERN ASN1C_KeyAgreeRecipientIdentifier :
   public ASN1CType
{
protected:
   ASN1T_KeyAgreeRecipientIdentifier& msgData;
public:
   ASN1C_KeyAgreeRecipientIdentifier (ASN1T_KeyAgreeRecipientIdentifier& data);
   ASN1C_KeyAgreeRecipientIdentifier (
      ASN1MessageBufferIF& msgBuf, ASN1T_KeyAgreeRecipientIdentifier& data);
   ASN1C_KeyAgreeRecipientIdentifier (ASN1C_KeyAgreeRecipientIdentifier& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_KeyAgreeRecipientIdentifier& getCopy (ASN1T_KeyAgreeRecipientIdentifier* pDstData = 0);
   ASN1T_KeyAgreeRecipientIdentifier* newCopy ();

   inline ASN1C_KeyAgreeRecipientIdentifier& operator= (ASN1C_KeyAgreeRecipientIdentifier& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_KeyAgreeRecipientIdentifier (ASN1CTXT* pctxt,
   ASN1T_KeyAgreeRecipientIdentifier *pvalue, ASN1TagType tagging);

EXTERN int asn1D_KeyAgreeRecipientIdentifier (ASN1CTXT* pctxt,
   ASN1T_KeyAgreeRecipientIdentifier *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_KeyAgreeRecipientIdentifier (ASN1CTXT *pctxt, ASN1T_KeyAgreeRecipientIdentifier* pSrcValue, ASN1T_KeyAgreeRecipientIdentifier* pDstValue);

EXTERN void asn1Free_KeyAgreeRecipientIdentifier (ASN1CTXT *pctxt, ASN1T_KeyAgreeRecipientIdentifier* pvalue);

/**************************************************************/
/*                                                            */
/*  RecipientEncryptedKey                                     */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_RecipientEncryptedKey;

typedef struct EXTERN ASN1T_RecipientEncryptedKey : public ASN1TPDU {
   ASN1T_KeyAgreeRecipientIdentifier rid;
   ASN1T_EncryptedKey encryptedKey;
   ASN1T_RecipientEncryptedKey ();
   ASN1T_RecipientEncryptedKey (ASN1C_RecipientEncryptedKey& srcData);
   ~ASN1T_RecipientEncryptedKey ();
} ASN1T_RecipientEncryptedKey;

class EXTERN ASN1C_RecipientEncryptedKey :
   public ASN1CType
{
protected:
   ASN1T_RecipientEncryptedKey& msgData;
public:
   ASN1C_RecipientEncryptedKey (ASN1T_RecipientEncryptedKey& data);
   ASN1C_RecipientEncryptedKey (
      ASN1MessageBufferIF& msgBuf, ASN1T_RecipientEncryptedKey& data);
   ASN1C_RecipientEncryptedKey (ASN1C_RecipientEncryptedKey& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_RecipientEncryptedKey& getCopy (ASN1T_RecipientEncryptedKey* pDstData = 0);
   ASN1T_RecipientEncryptedKey* newCopy ();

   inline ASN1C_RecipientEncryptedKey& operator= (ASN1C_RecipientEncryptedKey& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_RecipientEncryptedKey (ASN1CTXT* pctxt,
   ASN1T_RecipientEncryptedKey *pvalue, ASN1TagType tagging);

EXTERN int asn1D_RecipientEncryptedKey (ASN1CTXT* pctxt,
   ASN1T_RecipientEncryptedKey *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_RecipientEncryptedKey (ASN1CTXT *pctxt, ASN1T_RecipientEncryptedKey* pSrcValue, ASN1T_RecipientEncryptedKey* pDstValue);

EXTERN void asn1Free_RecipientEncryptedKey (ASN1CTXT *pctxt, ASN1T_RecipientEncryptedKey* pvalue);

/**************************************************************/
/*                                                            */
/*  RecipientEncryptedKeys                                    */
/*                                                            */
/**************************************************************/

/* List of ASN1T_RecipientEncryptedKey */
typedef struct EXTERN ASN1T_RecipientEncryptedKeys : public ASN1TPDUSeqOfList {
   ~ASN1T_RecipientEncryptedKeys();
} ASN1T_RecipientEncryptedKeys;

class EXTERN ASN1C_RecipientEncryptedKeys :
   public ASN1CSeqOfList
{
protected:
   ASN1T_RecipientEncryptedKeys& msgData;
public:
   ASN1C_RecipientEncryptedKeys (ASN1T_RecipientEncryptedKeys& data);
   ASN1C_RecipientEncryptedKeys (
      ASN1MessageBufferIF& msgBuf, ASN1T_RecipientEncryptedKeys& data);
   ASN1C_RecipientEncryptedKeys (ASN1C_RecipientEncryptedKeys& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_RecipientEncryptedKeys& getCopy (ASN1T_RecipientEncryptedKeys* pDstData = 0);
   ASN1T_RecipientEncryptedKeys* newCopy ();

   ASN1C_RecipientEncryptedKeys& operator= (ASN1C_RecipientEncryptedKeys& srcData);
   void Append (ASN1T_RecipientEncryptedKey * elem) {
      append ((void*)elem);
   }
} ;

EXTERN int asn1E_RecipientEncryptedKeys (ASN1CTXT* pctxt,
   ASN1T_RecipientEncryptedKeys *pvalue, ASN1TagType tagging);

EXTERN int asn1D_RecipientEncryptedKeys (ASN1CTXT* pctxt,
   ASN1T_RecipientEncryptedKeys *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_RecipientEncryptedKeys (ASN1CTXT *pctxt, ASN1T_RecipientEncryptedKeys* pSrcValue, ASN1T_RecipientEncryptedKeys* pDstValue);

EXTERN void asn1Free_RecipientEncryptedKeys (ASN1CTXT *pctxt, ASN1T_RecipientEncryptedKeys* pvalue);

/**************************************************************/
/*                                                            */
/*  KeyAgreeRecipientInfo                                     */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_KeyAgreeRecipientInfo;

typedef struct EXTERN ASN1T_KeyAgreeRecipientInfo : public ASN1TPDU {
   struct {
      unsigned ukmPresent : 1;
   } m;
   ASN1T_CMSVersion version;
   ASN1T_OriginatorIdentifierOrKey originator;
   ASN1T_UserKeyingMaterial ukm;
   ASN1T_KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm;
   ASN1T_RecipientEncryptedKeys recipientEncryptedKeys;
   ASN1T_KeyAgreeRecipientInfo ();
   ASN1T_KeyAgreeRecipientInfo (ASN1C_KeyAgreeRecipientInfo& srcData);
   ~ASN1T_KeyAgreeRecipientInfo ();
} ASN1T_KeyAgreeRecipientInfo;

class EXTERN ASN1C_KeyAgreeRecipientInfo :
   public ASN1CType
{
protected:
   ASN1T_KeyAgreeRecipientInfo& msgData;
public:
   ASN1C_KeyAgreeRecipientInfo (ASN1T_KeyAgreeRecipientInfo& data);
   ASN1C_KeyAgreeRecipientInfo (
      ASN1MessageBufferIF& msgBuf, ASN1T_KeyAgreeRecipientInfo& data);
   ASN1C_KeyAgreeRecipientInfo (ASN1C_KeyAgreeRecipientInfo& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_KeyAgreeRecipientInfo& getCopy (ASN1T_KeyAgreeRecipientInfo* pDstData = 0);
   ASN1T_KeyAgreeRecipientInfo* newCopy ();

   inline ASN1C_KeyAgreeRecipientInfo& operator= (ASN1C_KeyAgreeRecipientInfo& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_KeyAgreeRecipientInfo (ASN1CTXT* pctxt,
   ASN1T_KeyAgreeRecipientInfo *pvalue, ASN1TagType tagging);

EXTERN int asn1D_KeyAgreeRecipientInfo (ASN1CTXT* pctxt,
   ASN1T_KeyAgreeRecipientInfo *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_KeyAgreeRecipientInfo (ASN1CTXT *pctxt, ASN1T_KeyAgreeRecipientInfo* pSrcValue, ASN1T_KeyAgreeRecipientInfo* pDstValue);

EXTERN void asn1Free_KeyAgreeRecipientInfo (ASN1CTXT *pctxt, ASN1T_KeyAgreeRecipientInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  KEKIdentifier                                             */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_KEKIdentifier;

typedef struct EXTERN ASN1T_KEKIdentifier : public ASN1TPDU {
   struct {
      unsigned datePresent : 1;
      unsigned otherPresent : 1;
   } m;
   ASN1TDynOctStr keyIdentifier;
   ASN1GeneralizedTime date;
   ASN1T_OtherKeyAttribute other;
   ASN1T_KEKIdentifier ();
   ASN1T_KEKIdentifier (ASN1C_KEKIdentifier& srcData);
   ~ASN1T_KEKIdentifier ();
} ASN1T_KEKIdentifier;

class EXTERN ASN1C_KEKIdentifier :
   public ASN1CType
{
protected:
   ASN1T_KEKIdentifier& msgData;
public:
   ASN1C_KEKIdentifier (ASN1T_KEKIdentifier& data);
   ASN1C_KEKIdentifier (
      ASN1MessageBufferIF& msgBuf, ASN1T_KEKIdentifier& data);
   ASN1C_KEKIdentifier (ASN1C_KEKIdentifier& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_KEKIdentifier& getCopy (ASN1T_KEKIdentifier* pDstData = 0);
   ASN1T_KEKIdentifier* newCopy ();

   inline ASN1C_KEKIdentifier& operator= (ASN1C_KEKIdentifier& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_KEKIdentifier (ASN1CTXT* pctxt,
   ASN1T_KEKIdentifier *pvalue, ASN1TagType tagging);

EXTERN int asn1D_KEKIdentifier (ASN1CTXT* pctxt,
   ASN1T_KEKIdentifier *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_KEKIdentifier (ASN1CTXT *pctxt, ASN1T_KEKIdentifier* pSrcValue, ASN1T_KEKIdentifier* pDstValue);

EXTERN void asn1Free_KEKIdentifier (ASN1CTXT *pctxt, ASN1T_KEKIdentifier* pvalue);

/**************************************************************/
/*                                                            */
/*  KEKRecipientInfo                                          */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_KEKRecipientInfo;

typedef struct EXTERN ASN1T_KEKRecipientInfo : public ASN1TPDU {
   ASN1T_CMSVersion version;
   ASN1T_KEKIdentifier kekid;
   ASN1T_KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm;
   ASN1T_EncryptedKey encryptedKey;
   ASN1T_KEKRecipientInfo ();
   ASN1T_KEKRecipientInfo (ASN1C_KEKRecipientInfo& srcData);
   ~ASN1T_KEKRecipientInfo ();
} ASN1T_KEKRecipientInfo;

class EXTERN ASN1C_KEKRecipientInfo :
   public ASN1CType
{
protected:
   ASN1T_KEKRecipientInfo& msgData;
public:
   ASN1C_KEKRecipientInfo (ASN1T_KEKRecipientInfo& data);
   ASN1C_KEKRecipientInfo (
      ASN1MessageBufferIF& msgBuf, ASN1T_KEKRecipientInfo& data);
   ASN1C_KEKRecipientInfo (ASN1C_KEKRecipientInfo& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_KEKRecipientInfo& getCopy (ASN1T_KEKRecipientInfo* pDstData = 0);
   ASN1T_KEKRecipientInfo* newCopy ();

   inline ASN1C_KEKRecipientInfo& operator= (ASN1C_KEKRecipientInfo& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_KEKRecipientInfo (ASN1CTXT* pctxt,
   ASN1T_KEKRecipientInfo *pvalue, ASN1TagType tagging);

EXTERN int asn1D_KEKRecipientInfo (ASN1CTXT* pctxt,
   ASN1T_KEKRecipientInfo *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_KEKRecipientInfo (ASN1CTXT *pctxt, ASN1T_KEKRecipientInfo* pSrcValue, ASN1T_KEKRecipientInfo* pDstValue);

EXTERN void asn1Free_KEKRecipientInfo (ASN1CTXT *pctxt, ASN1T_KEKRecipientInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  PasswordRecipientInfo                                     */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_PasswordRecipientInfo;

typedef struct EXTERN ASN1T_PasswordRecipientInfo : public ASN1TPDU {
   struct {
      unsigned keyDerivationAlgorithmPresent : 1;
   } m;
   ASN1T_CMSVersion version;
   ASN1T_KeyDerivationAlgorithmIdentifier keyDerivationAlgorithm;
   ASN1T_KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm;
   ASN1T_EncryptedKey encryptedKey;
   ASN1T_PasswordRecipientInfo ();
   ASN1T_PasswordRecipientInfo (ASN1C_PasswordRecipientInfo& srcData);
   ~ASN1T_PasswordRecipientInfo ();
} ASN1T_PasswordRecipientInfo;

class EXTERN ASN1C_PasswordRecipientInfo :
   public ASN1CType
{
protected:
   ASN1T_PasswordRecipientInfo& msgData;
public:
   ASN1C_PasswordRecipientInfo (ASN1T_PasswordRecipientInfo& data);
   ASN1C_PasswordRecipientInfo (
      ASN1MessageBufferIF& msgBuf, ASN1T_PasswordRecipientInfo& data);
   ASN1C_PasswordRecipientInfo (ASN1C_PasswordRecipientInfo& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_PasswordRecipientInfo& getCopy (ASN1T_PasswordRecipientInfo* pDstData = 0);
   ASN1T_PasswordRecipientInfo* newCopy ();

   inline ASN1C_PasswordRecipientInfo& operator= (ASN1C_PasswordRecipientInfo& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_PasswordRecipientInfo (ASN1CTXT* pctxt,
   ASN1T_PasswordRecipientInfo *pvalue, ASN1TagType tagging);

EXTERN int asn1D_PasswordRecipientInfo (ASN1CTXT* pctxt,
   ASN1T_PasswordRecipientInfo *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_PasswordRecipientInfo (ASN1CTXT *pctxt, ASN1T_PasswordRecipientInfo* pSrcValue, ASN1T_PasswordRecipientInfo* pDstValue);

EXTERN void asn1Free_PasswordRecipientInfo (ASN1CTXT *pctxt, ASN1T_PasswordRecipientInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  OtherRecipientInfo                                        */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_OtherRecipientInfo;

typedef struct EXTERN ASN1T_OtherRecipientInfo : public ASN1TPDU {
   ASN1TObjId oriType;
   ASN1TOpenType oriValue;
   ASN1T_OtherRecipientInfo ();
   ASN1T_OtherRecipientInfo (ASN1C_OtherRecipientInfo& srcData);
   ~ASN1T_OtherRecipientInfo ();
} ASN1T_OtherRecipientInfo;

class EXTERN ASN1C_OtherRecipientInfo :
   public ASN1CType
{
protected:
   ASN1T_OtherRecipientInfo& msgData;
public:
   ASN1C_OtherRecipientInfo (ASN1T_OtherRecipientInfo& data);
   ASN1C_OtherRecipientInfo (
      ASN1MessageBufferIF& msgBuf, ASN1T_OtherRecipientInfo& data);
   ASN1C_OtherRecipientInfo (ASN1C_OtherRecipientInfo& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_OtherRecipientInfo& getCopy (ASN1T_OtherRecipientInfo* pDstData = 0);
   ASN1T_OtherRecipientInfo* newCopy ();

   inline ASN1C_OtherRecipientInfo& operator= (ASN1C_OtherRecipientInfo& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_OtherRecipientInfo (ASN1CTXT* pctxt,
   ASN1T_OtherRecipientInfo *pvalue, ASN1TagType tagging);

EXTERN int asn1D_OtherRecipientInfo (ASN1CTXT* pctxt,
   ASN1T_OtherRecipientInfo *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_OtherRecipientInfo (ASN1CTXT *pctxt, ASN1T_OtherRecipientInfo* pSrcValue, ASN1T_OtherRecipientInfo* pDstValue);

EXTERN void asn1Free_OtherRecipientInfo (ASN1CTXT *pctxt, ASN1T_OtherRecipientInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  RecipientInfo                                             */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_RecipientInfo_ktri            1
#define T_RecipientInfo_kari            2
#define T_RecipientInfo_kekri           3
#define T_RecipientInfo_pwri            4
#define T_RecipientInfo_ori             5

class EXTERN ASN1C_RecipientInfo;

typedef struct EXTERN ASN1T_RecipientInfo : public ASN1TPDU {
   int t;
   union {
      /* t = 1 */
      ASN1T_KeyTransRecipientInfo *ktri;
      /* t = 2 */
      ASN1T_KeyAgreeRecipientInfo *kari;
      /* t = 3 */
      ASN1T_KEKRecipientInfo *kekri;
      /* t = 4 */
      ASN1T_PasswordRecipientInfo *pwri;
      /* t = 5 */
      ASN1T_OtherRecipientInfo *ori;
   } u;
   ASN1T_RecipientInfo () {}
   ASN1T_RecipientInfo (ASN1C_RecipientInfo& srcData);
   ~ASN1T_RecipientInfo ();
} ASN1T_RecipientInfo;

class EXTERN ASN1C_RecipientInfo :
   public ASN1CType
{
protected:
   ASN1T_RecipientInfo& msgData;
public:
   ASN1C_RecipientInfo (ASN1T_RecipientInfo& data);
   ASN1C_RecipientInfo (
      ASN1MessageBufferIF& msgBuf, ASN1T_RecipientInfo& data);
   ASN1C_RecipientInfo (ASN1C_RecipientInfo& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_RecipientInfo& getCopy (ASN1T_RecipientInfo* pDstData = 0);
   ASN1T_RecipientInfo* newCopy ();

   inline ASN1C_RecipientInfo& operator= (ASN1C_RecipientInfo& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_RecipientInfo (ASN1CTXT* pctxt,
   ASN1T_RecipientInfo *pvalue, ASN1TagType tagging);

EXTERN int asn1D_RecipientInfo (ASN1CTXT* pctxt,
   ASN1T_RecipientInfo *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_RecipientInfo (ASN1CTXT *pctxt, ASN1T_RecipientInfo* pSrcValue, ASN1T_RecipientInfo* pDstValue);

EXTERN void asn1Free_RecipientInfo (ASN1CTXT *pctxt, ASN1T_RecipientInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  RecipientInfos                                            */
/*                                                            */
/**************************************************************/

/* List of ASN1T_RecipientInfo */
typedef struct EXTERN ASN1T_RecipientInfos : public ASN1TPDUSeqOfList {
   ~ASN1T_RecipientInfos();
} ASN1T_RecipientInfos;

class EXTERN ASN1C_RecipientInfos :
   public ASN1CSeqOfList
{
protected:
   ASN1T_RecipientInfos& msgData;
public:
   ASN1C_RecipientInfos (ASN1T_RecipientInfos& data);
   ASN1C_RecipientInfos (
      ASN1MessageBufferIF& msgBuf, ASN1T_RecipientInfos& data);
   ASN1C_RecipientInfos (ASN1C_RecipientInfos& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_RecipientInfos& getCopy (ASN1T_RecipientInfos* pDstData = 0);
   ASN1T_RecipientInfos* newCopy ();

   ASN1C_RecipientInfos& operator= (ASN1C_RecipientInfos& srcData);
   void Append (ASN1T_RecipientInfo * elem) {
      append ((void*)elem);
   }
} ;

EXTERN int asn1E_RecipientInfos (ASN1CTXT* pctxt,
   ASN1T_RecipientInfos *pvalue, ASN1TagType tagging);

EXTERN int asn1D_RecipientInfos (ASN1CTXT* pctxt,
   ASN1T_RecipientInfos *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_RecipientInfos (ASN1CTXT *pctxt, ASN1T_RecipientInfos* pSrcValue, ASN1T_RecipientInfos* pDstValue);

EXTERN void asn1Free_RecipientInfos (ASN1CTXT *pctxt, ASN1T_RecipientInfos* pvalue);

/**************************************************************/
/*                                                            */
/*  EncryptedContentInfo                                      */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_EncryptedContentInfo;

typedef struct EXTERN ASN1T_EncryptedContentInfo : public ASN1TPDU {
   struct {
      unsigned encryptedContentPresent : 1;
   } m;
   ASN1T_ContentType contentType;
   ASN1T_ContentEncryptionAlgorithmIdentifier contentEncryptionAlgorithm;
   ASN1T_EncryptedContent encryptedContent;
   ASN1T_EncryptedContentInfo ();
   ASN1T_EncryptedContentInfo (ASN1C_EncryptedContentInfo& srcData);
   ~ASN1T_EncryptedContentInfo ();
} ASN1T_EncryptedContentInfo;

class EXTERN ASN1C_EncryptedContentInfo :
   public ASN1CType
{
protected:
   ASN1T_EncryptedContentInfo& msgData;
public:
   ASN1C_EncryptedContentInfo (ASN1T_EncryptedContentInfo& data);
   ASN1C_EncryptedContentInfo (
      ASN1MessageBufferIF& msgBuf, ASN1T_EncryptedContentInfo& data);
   ASN1C_EncryptedContentInfo (ASN1C_EncryptedContentInfo& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_EncryptedContentInfo& getCopy (ASN1T_EncryptedContentInfo* pDstData = 0);
   ASN1T_EncryptedContentInfo* newCopy ();

   inline ASN1C_EncryptedContentInfo& operator= (ASN1C_EncryptedContentInfo& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_EncryptedContentInfo (ASN1CTXT* pctxt,
   ASN1T_EncryptedContentInfo *pvalue, ASN1TagType tagging);

EXTERN int asn1D_EncryptedContentInfo (ASN1CTXT* pctxt,
   ASN1T_EncryptedContentInfo *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_EncryptedContentInfo (ASN1CTXT *pctxt, ASN1T_EncryptedContentInfo* pSrcValue, ASN1T_EncryptedContentInfo* pDstValue);

EXTERN void asn1Free_EncryptedContentInfo (ASN1CTXT *pctxt, ASN1T_EncryptedContentInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  UnprotectedAttributes                                     */
/*                                                            */
/**************************************************************/

/* List of ASN1T_Attribute */
typedef struct EXTERN ASN1T_UnprotectedAttributes : public ASN1TPDUSeqOfList {
   ~ASN1T_UnprotectedAttributes();
} ASN1T_UnprotectedAttributes;

class EXTERN ASN1C_UnprotectedAttributes :
   public ASN1CSeqOfList
{
protected:
   ASN1T_UnprotectedAttributes& msgData;
public:
   ASN1C_UnprotectedAttributes (ASN1T_UnprotectedAttributes& data);
   ASN1C_UnprotectedAttributes (
      ASN1MessageBufferIF& msgBuf, ASN1T_UnprotectedAttributes& data);
   ASN1C_UnprotectedAttributes (ASN1C_UnprotectedAttributes& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_UnprotectedAttributes& getCopy (ASN1T_UnprotectedAttributes* pDstData = 0);
   ASN1T_UnprotectedAttributes* newCopy ();

   ASN1C_UnprotectedAttributes& operator= (ASN1C_UnprotectedAttributes& srcData);
   void Append (ASN1T_Attribute * elem) {
      append ((void*)elem);
   }
} ;

EXTERN int asn1E_UnprotectedAttributes (ASN1CTXT* pctxt,
   ASN1T_UnprotectedAttributes *pvalue, ASN1TagType tagging);

EXTERN int asn1D_UnprotectedAttributes (ASN1CTXT* pctxt,
   ASN1T_UnprotectedAttributes *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_UnprotectedAttributes (ASN1CTXT *pctxt, ASN1T_UnprotectedAttributes* pSrcValue, ASN1T_UnprotectedAttributes* pDstValue);

EXTERN void asn1Free_UnprotectedAttributes (ASN1CTXT *pctxt, ASN1T_UnprotectedAttributes* pvalue);

/**************************************************************/
/*                                                            */
/*  EnvelopedData                                             */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_EnvelopedData;

typedef struct EXTERN ASN1T_EnvelopedData : public ASN1TPDU {
   struct {
      unsigned originatorInfoPresent : 1;
      unsigned unprotectedAttrsPresent : 1;
   } m;
   ASN1T_CMSVersion version;
   ASN1T_OriginatorInfo originatorInfo;
   ASN1T_RecipientInfos recipientInfos;
   ASN1T_EncryptedContentInfo encryptedContentInfo;
   ASN1T_UnprotectedAttributes unprotectedAttrs;
   ASN1T_EnvelopedData ();
   ASN1T_EnvelopedData (ASN1C_EnvelopedData& srcData);
   ~ASN1T_EnvelopedData ();
} ASN1T_EnvelopedData;

class EXTERN ASN1C_EnvelopedData :
   public ASN1CType
{
protected:
   ASN1T_EnvelopedData& msgData;
public:
   ASN1C_EnvelopedData (ASN1T_EnvelopedData& data);
   ASN1C_EnvelopedData (
      ASN1MessageBufferIF& msgBuf, ASN1T_EnvelopedData& data);
   ASN1C_EnvelopedData (ASN1C_EnvelopedData& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_EnvelopedData& getCopy (ASN1T_EnvelopedData* pDstData = 0);
   ASN1T_EnvelopedData* newCopy ();

   inline ASN1C_EnvelopedData& operator= (ASN1C_EnvelopedData& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_EnvelopedData (ASN1CTXT* pctxt,
   ASN1T_EnvelopedData *pvalue, ASN1TagType tagging);

EXTERN int asn1D_EnvelopedData (ASN1CTXT* pctxt,
   ASN1T_EnvelopedData *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_EnvelopedData (ASN1CTXT *pctxt, ASN1T_EnvelopedData* pSrcValue, ASN1T_EnvelopedData* pDstValue);

EXTERN void asn1Free_EnvelopedData (ASN1CTXT *pctxt, ASN1T_EnvelopedData* pvalue);

/**************************************************************/
/*                                                            */
/*  DigestedData                                              */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_DigestedData;

typedef struct EXTERN ASN1T_DigestedData : public ASN1TPDU {
   ASN1T_CMSVersion version;
   ASN1T_DigestAlgorithmIdentifier digestAlgorithm;
   struct ASN1T_EncapsulatedContentInfo *encapContentInfo;
   ASN1T_Digest digest;
   ASN1T_DigestedData ();
   ASN1T_DigestedData (ASN1C_DigestedData& srcData);
   ~ASN1T_DigestedData ();
} ASN1T_DigestedData;

class EXTERN ASN1C_DigestedData :
   public ASN1CType
{
protected:
   ASN1T_DigestedData& msgData;
public:
   ASN1C_DigestedData (ASN1T_DigestedData& data);
   ASN1C_DigestedData (
      ASN1MessageBufferIF& msgBuf, ASN1T_DigestedData& data);
   ASN1C_DigestedData (ASN1C_DigestedData& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_DigestedData& getCopy (ASN1T_DigestedData* pDstData = 0);
   ASN1T_DigestedData* newCopy ();

   inline ASN1C_DigestedData& operator= (ASN1C_DigestedData& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_DigestedData (ASN1CTXT* pctxt,
   ASN1T_DigestedData *pvalue, ASN1TagType tagging);

EXTERN int asn1D_DigestedData (ASN1CTXT* pctxt,
   ASN1T_DigestedData *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_DigestedData (ASN1CTXT *pctxt, ASN1T_DigestedData* pSrcValue, ASN1T_DigestedData* pDstValue);

EXTERN void asn1Free_DigestedData (ASN1CTXT *pctxt, ASN1T_DigestedData* pvalue);

/**************************************************************/
/*                                                            */
/*  EncryptedData                                             */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_EncryptedData;

typedef struct EXTERN ASN1T_EncryptedData : public ASN1TPDU {
   struct {
      unsigned unprotectedAttrsPresent : 1;
   } m;
   ASN1T_CMSVersion version;
   ASN1T_EncryptedContentInfo encryptedContentInfo;
   ASN1T_UnprotectedAttributes unprotectedAttrs;
   ASN1T_EncryptedData ();
   ASN1T_EncryptedData (ASN1C_EncryptedData& srcData);
   ~ASN1T_EncryptedData ();
} ASN1T_EncryptedData;

class EXTERN ASN1C_EncryptedData :
   public ASN1CType
{
protected:
   ASN1T_EncryptedData& msgData;
public:
   ASN1C_EncryptedData (ASN1T_EncryptedData& data);
   ASN1C_EncryptedData (
      ASN1MessageBufferIF& msgBuf, ASN1T_EncryptedData& data);
   ASN1C_EncryptedData (ASN1C_EncryptedData& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_EncryptedData& getCopy (ASN1T_EncryptedData* pDstData = 0);
   ASN1T_EncryptedData* newCopy ();

   inline ASN1C_EncryptedData& operator= (ASN1C_EncryptedData& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_EncryptedData (ASN1CTXT* pctxt,
   ASN1T_EncryptedData *pvalue, ASN1TagType tagging);

EXTERN int asn1D_EncryptedData (ASN1CTXT* pctxt,
   ASN1T_EncryptedData *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_EncryptedData (ASN1CTXT *pctxt, ASN1T_EncryptedData* pSrcValue, ASN1T_EncryptedData* pDstValue);

EXTERN void asn1Free_EncryptedData (ASN1CTXT *pctxt, ASN1T_EncryptedData* pvalue);

/**************************************************************/
/*                                                            */
/*  AuthAttributes                                            */
/*                                                            */
/**************************************************************/

/* List of ASN1T_Attribute */
typedef struct EXTERN ASN1T_AuthAttributes : public ASN1TPDUSeqOfList {
   ~ASN1T_AuthAttributes();
} ASN1T_AuthAttributes;

class EXTERN ASN1C_AuthAttributes :
   public ASN1CSeqOfList
{
protected:
   ASN1T_AuthAttributes& msgData;
public:
   ASN1C_AuthAttributes (ASN1T_AuthAttributes& data);
   ASN1C_AuthAttributes (
      ASN1MessageBufferIF& msgBuf, ASN1T_AuthAttributes& data);
   ASN1C_AuthAttributes (ASN1C_AuthAttributes& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_AuthAttributes& getCopy (ASN1T_AuthAttributes* pDstData = 0);
   ASN1T_AuthAttributes* newCopy ();

   ASN1C_AuthAttributes& operator= (ASN1C_AuthAttributes& srcData);
   void Append (ASN1T_Attribute * elem) {
      append ((void*)elem);
   }
} ;

EXTERN int asn1E_AuthAttributes (ASN1CTXT* pctxt,
   ASN1T_AuthAttributes *pvalue, ASN1TagType tagging);

EXTERN int asn1D_AuthAttributes (ASN1CTXT* pctxt,
   ASN1T_AuthAttributes *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_AuthAttributes (ASN1CTXT *pctxt, ASN1T_AuthAttributes* pSrcValue, ASN1T_AuthAttributes* pDstValue);

EXTERN void asn1Free_AuthAttributes (ASN1CTXT *pctxt, ASN1T_AuthAttributes* pvalue);

/**************************************************************/
/*                                                            */
/*  AuthenticatedData                                         */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_AuthenticatedData;

typedef struct EXTERN ASN1T_AuthenticatedData : public ASN1TPDU {
   struct {
      unsigned originatorInfoPresent : 1;
      unsigned digestAlgorithmPresent : 1;
      unsigned authenticatedAttributesPresent : 1;
      unsigned unauthenticatedAttributesPresent : 1;
   } m;
   ASN1T_CMSVersion version;
   ASN1T_OriginatorInfo originatorInfo;
   ASN1T_RecipientInfos recipientInfos;
   ASN1T_MessageAuthenticationCodeAlgorithm macAlgorithm;
   ASN1T_DigestAlgorithmIdentifier digestAlgorithm;
   struct ASN1T_EncapsulatedContentInfo *encapContentInfo;
   ASN1T_AuthAttributes authenticatedAttributes;
   ASN1T_MessageAuthenticationCode mac;
   ASN1T_UnauthAttributes unauthenticatedAttributes;
   ASN1T_AuthenticatedData ();
   ASN1T_AuthenticatedData (ASN1C_AuthenticatedData& srcData);
   ~ASN1T_AuthenticatedData ();
} ASN1T_AuthenticatedData;

class EXTERN ASN1C_AuthenticatedData :
   public ASN1CType
{
protected:
   ASN1T_AuthenticatedData& msgData;
public:
   ASN1C_AuthenticatedData (ASN1T_AuthenticatedData& data);
   ASN1C_AuthenticatedData (
      ASN1MessageBufferIF& msgBuf, ASN1T_AuthenticatedData& data);
   ASN1C_AuthenticatedData (ASN1C_AuthenticatedData& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_AuthenticatedData& getCopy (ASN1T_AuthenticatedData* pDstData = 0);
   ASN1T_AuthenticatedData* newCopy ();

   inline ASN1C_AuthenticatedData& operator= (ASN1C_AuthenticatedData& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_AuthenticatedData (ASN1CTXT* pctxt,
   ASN1T_AuthenticatedData *pvalue, ASN1TagType tagging);

EXTERN int asn1D_AuthenticatedData (ASN1CTXT* pctxt,
   ASN1T_AuthenticatedData *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_AuthenticatedData (ASN1CTXT *pctxt, ASN1T_AuthenticatedData* pSrcValue, ASN1T_AuthenticatedData* pDstValue);

EXTERN void asn1Free_AuthenticatedData (ASN1CTXT *pctxt, ASN1T_AuthenticatedData* pvalue);

/**************************************************************/
/*                                                            */
/*  SignerInfos                                               */
/*                                                            */
/**************************************************************/

/* List of ASN1T_SignerInfo */
typedef struct EXTERN ASN1T_SignerInfos : public ASN1TPDUSeqOfList {
   ~ASN1T_SignerInfos();
} ASN1T_SignerInfos;

class EXTERN ASN1C_SignerInfos :
   public ASN1CSeqOfList
{
protected:
   ASN1T_SignerInfos& msgData;
public:
   ASN1C_SignerInfos (ASN1T_SignerInfos& data);
   ASN1C_SignerInfos (
      ASN1MessageBufferIF& msgBuf, ASN1T_SignerInfos& data);
   ASN1C_SignerInfos (ASN1C_SignerInfos& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_SignerInfos& getCopy (ASN1T_SignerInfos* pDstData = 0);
   ASN1T_SignerInfos* newCopy ();

   ASN1C_SignerInfos& operator= (ASN1C_SignerInfos& srcData);
   void Append (struct ASN1T_SignerInfo * elem) {
      append ((void*)elem);
   }
} ;

EXTERN int asn1E_SignerInfos (ASN1CTXT* pctxt,
   ASN1T_SignerInfos *pvalue, ASN1TagType tagging);

EXTERN int asn1D_SignerInfos (ASN1CTXT* pctxt,
   ASN1T_SignerInfos *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_SignerInfos (ASN1CTXT *pctxt, ASN1T_SignerInfos* pSrcValue, ASN1T_SignerInfos* pDstValue);

EXTERN void asn1Free_SignerInfos (ASN1CTXT *pctxt, ASN1T_SignerInfos* pvalue);

/**************************************************************/
/*                                                            */
/*  EncapsulatedContentInfo                                   */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_EncapsulatedContentInfo;

typedef struct EXTERN ASN1T_EncapsulatedContentInfo : public ASN1TPDU {
   struct {
      unsigned eContentPresent : 1;
   } m;
   ASN1TObjId eContentType;
   ASN1TDynOctStr eContent;
   Asn1TObject value;
   ASN1T_EncapsulatedContentInfo ();
   ASN1T_EncapsulatedContentInfo (ASN1C_EncapsulatedContentInfo& srcData);
   ~ASN1T_EncapsulatedContentInfo ();
} ASN1T_EncapsulatedContentInfo;

class EXTERN ASN1C_EncapsulatedContentInfo :
   public ASN1CType
{
protected:
   ASN1T_EncapsulatedContentInfo& msgData;
public:
   ASN1C_EncapsulatedContentInfo (ASN1T_EncapsulatedContentInfo& data);
   ASN1C_EncapsulatedContentInfo (
      ASN1MessageBufferIF& msgBuf, ASN1T_EncapsulatedContentInfo& data);
   ASN1C_EncapsulatedContentInfo (ASN1C_EncapsulatedContentInfo& original);
   ~ASN1C_EncapsulatedContentInfo();

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_EncapsulatedContentInfo& getCopy (ASN1T_EncapsulatedContentInfo* pDstData = 0);
   ASN1T_EncapsulatedContentInfo* newCopy ();

   inline ASN1C_EncapsulatedContentInfo& operator= (ASN1C_EncapsulatedContentInfo& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_EncapsulatedContentInfo (ASN1CTXT* pctxt,
   ASN1T_EncapsulatedContentInfo *pvalue, ASN1TagType tagging);

EXTERN int asn1D_EncapsulatedContentInfo (ASN1CTXT* pctxt,
   ASN1T_EncapsulatedContentInfo *pvalue, ASN1TagType tagging, int length);

EXTERN int asn1XETC_EncapsulatedContentInfo (ASN1CTXT* pctxt,
    ASN1T_EncapsulatedContentInfo *pvalue);

EXTERN int asn1XDTC_EncapsulatedContentInfo (ASN1CtxtPtr& pctxt,
    ASN1T_EncapsulatedContentInfo *pvalue);

EXTERN int asn1ETC_EncapsulatedContentInfo (ASN1CTXT* pctxt,
   ASN1T_EncapsulatedContentInfo *pvalue);

EXTERN int asn1DTC_EncapsulatedContentInfo (ASN1CTXT* pctxt,
   ASN1T_EncapsulatedContentInfo *pvalue);

EXTERN void asn1Copy_EncapsulatedContentInfo (ASN1CTXT *pctxt, ASN1T_EncapsulatedContentInfo* pSrcValue, ASN1T_EncapsulatedContentInfo* pDstValue);

EXTERN void asn1Free_EncapsulatedContentInfo (ASN1CTXT *pctxt, ASN1T_EncapsulatedContentInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  CertificateChoicesRaw                                     */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_CertificateChoicesRaw_certRaw 1
#define T_CertificateChoicesRaw_extendedCertificate 2
#define T_CertificateChoicesRaw_attrCert 3

class EXTERN ASN1C_CertificateChoicesRaw;

typedef struct EXTERN ASN1T_CertificateChoicesRaw : public ASN1TPDU {
   int t;
   union {
      /* t = 1 */
      ASN1T_SignedOpenType *certRaw;
      /* t = 2 */
      ASN1T_ExtendedCertificate *extendedCertificate;
      /* t = 3 */
      ASN1T_AttributeCertificate *attrCert;
   } u;
   ASN1T_CertificateChoicesRaw () {}
   ASN1T_CertificateChoicesRaw (ASN1C_CertificateChoicesRaw& srcData);
   ~ASN1T_CertificateChoicesRaw ();
} ASN1T_CertificateChoicesRaw;

class EXTERN ASN1C_CertificateChoicesRaw :
   public ASN1CType
{
protected:
   ASN1T_CertificateChoicesRaw& msgData;
public:
   ASN1C_CertificateChoicesRaw (ASN1T_CertificateChoicesRaw& data);
   ASN1C_CertificateChoicesRaw (
      ASN1MessageBufferIF& msgBuf, ASN1T_CertificateChoicesRaw& data);
   ASN1C_CertificateChoicesRaw (ASN1C_CertificateChoicesRaw& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_CertificateChoicesRaw& getCopy (ASN1T_CertificateChoicesRaw* pDstData = 0);
   ASN1T_CertificateChoicesRaw* newCopy ();

   inline ASN1C_CertificateChoicesRaw& operator= (ASN1C_CertificateChoicesRaw& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_CertificateChoicesRaw (ASN1CTXT* pctxt,
   ASN1T_CertificateChoicesRaw *pvalue, ASN1TagType tagging);

EXTERN int asn1D_CertificateChoicesRaw (ASN1CTXT* pctxt,
   ASN1T_CertificateChoicesRaw *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_CertificateChoicesRaw (ASN1CTXT *pctxt, ASN1T_CertificateChoicesRaw* pSrcValue, ASN1T_CertificateChoicesRaw* pDstValue);

EXTERN void asn1Free_CertificateChoicesRaw (ASN1CTXT *pctxt, ASN1T_CertificateChoicesRaw* pvalue);

/**************************************************************/
/*                                                            */
/*  CertificateSetRaw                                         */
/*                                                            */
/**************************************************************/

/* List of ASN1T_CertificateChoicesRaw */
typedef struct EXTERN ASN1T_CertificateSetRaw : public ASN1TPDUSeqOfList {
   ~ASN1T_CertificateSetRaw();
} ASN1T_CertificateSetRaw;

class EXTERN ASN1C_CertificateSetRaw :
   public ASN1CSeqOfList
{
protected:
   ASN1T_CertificateSetRaw& msgData;
public:
   ASN1C_CertificateSetRaw (ASN1T_CertificateSetRaw& data);
   ASN1C_CertificateSetRaw (
      ASN1MessageBufferIF& msgBuf, ASN1T_CertificateSetRaw& data);
   ASN1C_CertificateSetRaw (ASN1C_CertificateSetRaw& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_CertificateSetRaw& getCopy (ASN1T_CertificateSetRaw* pDstData = 0);
   ASN1T_CertificateSetRaw* newCopy ();

   ASN1C_CertificateSetRaw& operator= (ASN1C_CertificateSetRaw& srcData);
   void Append (ASN1T_CertificateChoicesRaw * elem) {
      append ((void*)elem);
   }
} ;

EXTERN int asn1E_CertificateSetRaw (ASN1CTXT* pctxt,
   ASN1T_CertificateSetRaw *pvalue, ASN1TagType tagging);

EXTERN int asn1D_CertificateSetRaw (ASN1CTXT* pctxt,
   ASN1T_CertificateSetRaw *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_CertificateSetRaw (ASN1CTXT *pctxt, ASN1T_CertificateSetRaw* pSrcValue, ASN1T_CertificateSetRaw* pDstValue);

EXTERN void asn1Free_CertificateSetRaw (ASN1CTXT *pctxt, ASN1T_CertificateSetRaw* pvalue);

/**************************************************************/
/*                                                            */
/*  OtherRevocationInfoFormat                                 */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_OtherRevocationInfoFormat;

typedef struct EXTERN ASN1T_OtherRevocationInfoFormat : public ASN1TPDU {
   ASN1TObjId otherRevInfoFormat;
   ASN1TOpenType otherRevInfo;
   ASN1T_OtherRevocationInfoFormat ();
   ASN1T_OtherRevocationInfoFormat (ASN1C_OtherRevocationInfoFormat& srcData);
   ~ASN1T_OtherRevocationInfoFormat ();
} ASN1T_OtherRevocationInfoFormat;

class EXTERN ASN1C_OtherRevocationInfoFormat :
   public ASN1CType
{
protected:
   ASN1T_OtherRevocationInfoFormat& msgData;
public:
   ASN1C_OtherRevocationInfoFormat (ASN1T_OtherRevocationInfoFormat& data);
   ASN1C_OtherRevocationInfoFormat (
      ASN1MessageBufferIF& msgBuf, ASN1T_OtherRevocationInfoFormat& data);
   ASN1C_OtherRevocationInfoFormat (ASN1C_OtherRevocationInfoFormat& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_OtherRevocationInfoFormat& getCopy (ASN1T_OtherRevocationInfoFormat* pDstData = 0);
   ASN1T_OtherRevocationInfoFormat* newCopy ();

   inline ASN1C_OtherRevocationInfoFormat& operator= (ASN1C_OtherRevocationInfoFormat& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_OtherRevocationInfoFormat (ASN1CTXT* pctxt,
   ASN1T_OtherRevocationInfoFormat *pvalue, ASN1TagType tagging);

EXTERN int asn1D_OtherRevocationInfoFormat (ASN1CTXT* pctxt,
   ASN1T_OtherRevocationInfoFormat *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_OtherRevocationInfoFormat (ASN1CTXT *pctxt, ASN1T_OtherRevocationInfoFormat* pSrcValue, ASN1T_OtherRevocationInfoFormat* pDstValue);

EXTERN void asn1Free_OtherRevocationInfoFormat (ASN1CTXT *pctxt, ASN1T_OtherRevocationInfoFormat* pvalue);

/**************************************************************/
/*                                                            */
/*  RevocationInfoChoice                                      */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_RevocationInfoChoice_crl      1
#define T_RevocationInfoChoice_other    2

class EXTERN ASN1C_RevocationInfoChoice;

typedef struct EXTERN ASN1T_RevocationInfoChoice : public ASN1TPDU {
   int t;
   union {
      /* t = 1 */
      ASN1T_CertificateList *crl;
      /* t = 2 */
      ASN1T_OtherRevocationInfoFormat *other;
   } u;
   ASN1T_RevocationInfoChoice () {}
   ASN1T_RevocationInfoChoice (ASN1C_RevocationInfoChoice& srcData);
   ~ASN1T_RevocationInfoChoice ();
} ASN1T_RevocationInfoChoice;

class EXTERN ASN1C_RevocationInfoChoice :
   public ASN1CType
{
protected:
   ASN1T_RevocationInfoChoice& msgData;
public:
   ASN1C_RevocationInfoChoice (ASN1T_RevocationInfoChoice& data);
   ASN1C_RevocationInfoChoice (
      ASN1MessageBufferIF& msgBuf, ASN1T_RevocationInfoChoice& data);
   ASN1C_RevocationInfoChoice (ASN1C_RevocationInfoChoice& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_RevocationInfoChoice& getCopy (ASN1T_RevocationInfoChoice* pDstData = 0);
   ASN1T_RevocationInfoChoice* newCopy ();

   inline ASN1C_RevocationInfoChoice& operator= (ASN1C_RevocationInfoChoice& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_RevocationInfoChoice (ASN1CTXT* pctxt,
   ASN1T_RevocationInfoChoice *pvalue, ASN1TagType tagging);

EXTERN int asn1D_RevocationInfoChoice (ASN1CTXT* pctxt,
   ASN1T_RevocationInfoChoice *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_RevocationInfoChoice (ASN1CTXT *pctxt, ASN1T_RevocationInfoChoice* pSrcValue, ASN1T_RevocationInfoChoice* pDstValue);

EXTERN void asn1Free_RevocationInfoChoice (ASN1CTXT *pctxt, ASN1T_RevocationInfoChoice* pvalue);

/**************************************************************/
/*                                                            */
/*  RevocationInfoChoices                                     */
/*                                                            */
/**************************************************************/

/* List of ASN1T_RevocationInfoChoice */
typedef struct EXTERN ASN1T_RevocationInfoChoices : public ASN1TPDUSeqOfList {
   ~ASN1T_RevocationInfoChoices();
} ASN1T_RevocationInfoChoices;

class EXTERN ASN1C_RevocationInfoChoices :
   public ASN1CSeqOfList
{
protected:
   ASN1T_RevocationInfoChoices& msgData;
public:
   ASN1C_RevocationInfoChoices (ASN1T_RevocationInfoChoices& data);
   ASN1C_RevocationInfoChoices (
      ASN1MessageBufferIF& msgBuf, ASN1T_RevocationInfoChoices& data);
   ASN1C_RevocationInfoChoices (ASN1C_RevocationInfoChoices& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_RevocationInfoChoices& getCopy (ASN1T_RevocationInfoChoices* pDstData = 0);
   ASN1T_RevocationInfoChoices* newCopy ();

   ASN1C_RevocationInfoChoices& operator= (ASN1C_RevocationInfoChoices& srcData);
   void Append (ASN1T_RevocationInfoChoice * elem) {
      append ((void*)elem);
   }
} ;

EXTERN int asn1E_RevocationInfoChoices (ASN1CTXT* pctxt,
   ASN1T_RevocationInfoChoices *pvalue, ASN1TagType tagging);

EXTERN int asn1D_RevocationInfoChoices (ASN1CTXT* pctxt,
   ASN1T_RevocationInfoChoices *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_RevocationInfoChoices (ASN1CTXT *pctxt, ASN1T_RevocationInfoChoices* pSrcValue, ASN1T_RevocationInfoChoices* pDstValue);

EXTERN void asn1Free_RevocationInfoChoices (ASN1CTXT *pctxt, ASN1T_RevocationInfoChoices* pvalue);

/**************************************************************/
/*                                                            */
/*  SignedData                                                */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_SignedData;

typedef struct EXTERN ASN1T_SignedData : public ASN1TPDU {
   struct {
      unsigned certsRawPresent : 1;
      unsigned revInfoChoicesPresent : 1;
   } m;
   ASN1T_CMSVersion version;
   ASN1T_DigestAlgorithmIdentifiers digestAlgorithms;
   ASN1T_EncapsulatedContentInfo encapContentInfo;
   ASN1T_CertificateSetRaw certsRaw;
   ASN1T_RevocationInfoChoices revInfoChoices;
   ASN1T_SignerInfos signerInfos;
   ASN1T_SignedData ();
   ASN1T_SignedData (ASN1C_SignedData& srcData);
   ~ASN1T_SignedData ();
} ASN1T_SignedData;

class EXTERN ASN1C_SignedData :
   public ASN1CType
{
protected:
   ASN1T_SignedData& msgData;
public:
   ASN1C_SignedData (ASN1T_SignedData& data);
   ASN1C_SignedData (
      ASN1MessageBufferIF& msgBuf, ASN1T_SignedData& data);
   ASN1C_SignedData (ASN1C_SignedData& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_SignedData& getCopy (ASN1T_SignedData* pDstData = 0);
   ASN1T_SignedData* newCopy ();

   inline ASN1C_SignedData& operator= (ASN1C_SignedData& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_SignedData (ASN1CTXT* pctxt,
   ASN1T_SignedData *pvalue, ASN1TagType tagging);

EXTERN int asn1D_SignedData (ASN1CTXT* pctxt,
   ASN1T_SignedData *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_SignedData (ASN1CTXT *pctxt, ASN1T_SignedData* pSrcValue, ASN1T_SignedData* pDstValue);

EXTERN void asn1Free_SignedData (ASN1CTXT *pctxt, ASN1T_SignedData* pvalue);

/**************************************************************/
/*                                                            */
/*  ContentInfo                                               */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_ContentInfo;

typedef struct EXTERN ASN1T_ContentInfo : public ASN1TPDU {
   ASN1TObjId contentType;
   Asn1TObject content;
   ASN1T_ContentInfo ();
   ASN1T_ContentInfo (ASN1C_ContentInfo& srcData);
   ~ASN1T_ContentInfo ();
} ASN1T_ContentInfo;

class EXTERN ASN1C_ContentInfo :
   public ASN1CType
{
protected:
   ASN1T_ContentInfo& msgData;
public:
   ASN1C_ContentInfo (ASN1T_ContentInfo& data);
   ASN1C_ContentInfo (
      ASN1MessageBufferIF& msgBuf, ASN1T_ContentInfo& data);
   ASN1C_ContentInfo (ASN1C_ContentInfo& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_ContentInfo& getCopy (ASN1T_ContentInfo* pDstData = 0);
   ASN1T_ContentInfo* newCopy ();

   inline ASN1C_ContentInfo& operator= (ASN1C_ContentInfo& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_ContentInfo (ASN1CTXT* pctxt,
   ASN1T_ContentInfo *pvalue, ASN1TagType tagging);

EXTERN int asn1D_ContentInfo (ASN1CTXT* pctxt,
   ASN1T_ContentInfo *pvalue, ASN1TagType tagging, int length);

EXTERN int asn1XETC_ContentInfo (ASN1CTXT* pctxt,
    ASN1T_ContentInfo *pvalue);

EXTERN int asn1XDTC_ContentInfo (ASN1CtxtPtr& pctxt,
    ASN1T_ContentInfo *pvalue);

EXTERN int asn1ETC_ContentInfo (ASN1CTXT* pctxt,
   ASN1T_ContentInfo *pvalue);

EXTERN int asn1DTC_ContentInfo (ASN1CTXT* pctxt,
   ASN1T_ContentInfo *pvalue);

EXTERN void asn1Copy_ContentInfo (ASN1CTXT *pctxt, ASN1T_ContentInfo* pSrcValue, ASN1T_ContentInfo* pDstValue);

EXTERN void asn1Free_ContentInfo (ASN1CTXT *pctxt, ASN1T_ContentInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  SignedAttributes                                          */
/*                                                            */
/**************************************************************/

/* List of ASN1T_Attribute */
typedef struct EXTERN ASN1T_SignedAttributes : public ASN1TPDUSeqOfList {
   ~ASN1T_SignedAttributes();
} ASN1T_SignedAttributes;

class EXTERN ASN1C_SignedAttributes :
   public ASN1CSeqOfList
{
protected:
   ASN1T_SignedAttributes& msgData;
public:
   ASN1C_SignedAttributes (ASN1T_SignedAttributes& data);
   ASN1C_SignedAttributes (
      ASN1MessageBufferIF& msgBuf, ASN1T_SignedAttributes& data);
   ASN1C_SignedAttributes (ASN1C_SignedAttributes& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_SignedAttributes& getCopy (ASN1T_SignedAttributes* pDstData = 0);
   ASN1T_SignedAttributes* newCopy ();

   ASN1C_SignedAttributes& operator= (ASN1C_SignedAttributes& srcData);
   void Append (ASN1T_Attribute * elem) {
      append ((void*)elem);
   }
} ;

EXTERN int asn1E_SignedAttributes (ASN1CTXT* pctxt,
   ASN1T_SignedAttributes *pvalue, ASN1TagType tagging);

EXTERN int asn1D_SignedAttributes (ASN1CTXT* pctxt,
   ASN1T_SignedAttributes *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_SignedAttributes (ASN1CTXT *pctxt, ASN1T_SignedAttributes* pSrcValue, ASN1T_SignedAttributes* pDstValue);

EXTERN void asn1Free_SignedAttributes (ASN1CTXT *pctxt, ASN1T_SignedAttributes* pvalue);

/**************************************************************/
/*                                                            */
/*  UnsignedAttributes                                        */
/*                                                            */
/**************************************************************/

/* List of ASN1T_Attribute */
typedef struct EXTERN ASN1T_UnsignedAttributes : public ASN1TPDUSeqOfList {
   ~ASN1T_UnsignedAttributes();
} ASN1T_UnsignedAttributes;

class EXTERN ASN1C_UnsignedAttributes :
   public ASN1CSeqOfList
{
protected:
   ASN1T_UnsignedAttributes& msgData;
public:
   ASN1C_UnsignedAttributes (ASN1T_UnsignedAttributes& data);
   ASN1C_UnsignedAttributes (
      ASN1MessageBufferIF& msgBuf, ASN1T_UnsignedAttributes& data);
   ASN1C_UnsignedAttributes (ASN1C_UnsignedAttributes& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_UnsignedAttributes& getCopy (ASN1T_UnsignedAttributes* pDstData = 0);
   ASN1T_UnsignedAttributes* newCopy ();

   ASN1C_UnsignedAttributes& operator= (ASN1C_UnsignedAttributes& srcData);
   void Append (ASN1T_Attribute * elem) {
      append ((void*)elem);
   }
} ;

EXTERN int asn1E_UnsignedAttributes (ASN1CTXT* pctxt,
   ASN1T_UnsignedAttributes *pvalue, ASN1TagType tagging);

EXTERN int asn1D_UnsignedAttributes (ASN1CTXT* pctxt,
   ASN1T_UnsignedAttributes *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_UnsignedAttributes (ASN1CTXT *pctxt, ASN1T_UnsignedAttributes* pSrcValue, ASN1T_UnsignedAttributes* pDstValue);

EXTERN void asn1Free_UnsignedAttributes (ASN1CTXT *pctxt, ASN1T_UnsignedAttributes* pvalue);

/**************************************************************/
/*                                                            */
/*  SignerInfo                                                */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_SignerInfo;

typedef struct EXTERN ASN1T_SignerInfo : public ASN1TPDU {
   struct {
      unsigned signedAttrsPresent : 1;
      unsigned unsignedAttrsPresent : 1;
   } m;
   ASN1T_CMSVersion version;
   ASN1T_SignerIdentifier sid;
   ASN1T_DigestAlgorithmIdentifier digestAlgorithm;
   ASN1T_SignedAttributes signedAttrs;
   ASN1T_SignatureAlgorithmIdentifier signatureAlgorithm;
   ASN1T_SignatureValue signature;
   ASN1T_UnsignedAttributes unsignedAttrs;
   size_t rawSignedAttrsStart;
   size_t rawSignedAttrsLength;
   ASN1T_SignerInfo ();
   ASN1T_SignerInfo (ASN1C_SignerInfo& srcData);
   ~ASN1T_SignerInfo ();
} ASN1T_SignerInfo;

class EXTERN ASN1C_SignerInfo :
   public ASN1CType
{
protected:
   ASN1T_SignerInfo& msgData;
public:
   ASN1C_SignerInfo (ASN1T_SignerInfo& data);
   ASN1C_SignerInfo (
      ASN1MessageBufferIF& msgBuf, ASN1T_SignerInfo& data);
   ASN1C_SignerInfo (ASN1C_SignerInfo& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_SignerInfo& getCopy (ASN1T_SignerInfo* pDstData = 0);
   ASN1T_SignerInfo* newCopy ();

   inline ASN1C_SignerInfo& operator= (ASN1C_SignerInfo& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_SignerInfo (ASN1CTXT* pctxt,
   ASN1T_SignerInfo *pvalue, ASN1TagType tagging);

EXTERN int asn1D_SignerInfo (ASN1CTXT* pctxt,
   ASN1T_SignerInfo *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_SignerInfo (ASN1CTXT *pctxt, ASN1T_SignerInfo* pSrcValue, ASN1T_SignerInfo* pDstValue);

EXTERN void asn1Free_SignerInfo (ASN1CTXT *pctxt, ASN1T_SignerInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  Countersignature                                          */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_Countersignature;

typedef ASN1T_SignerInfo ASN1T_Countersignature;

class EXTERN ASN1C_Countersignature :
   public ASN1C_SignerInfo
{
protected:
public:
   ASN1C_Countersignature (ASN1T_Countersignature& data);
   ASN1C_Countersignature (
      ASN1MessageBufferIF& msgBuf, ASN1T_Countersignature& data);
   ASN1C_Countersignature (ASN1C_Countersignature& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_Countersignature& getCopy (ASN1T_Countersignature* pDstData = 0);
   ASN1T_Countersignature* newCopy ();

   inline ASN1C_Countersignature& operator= (ASN1C_Countersignature& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_Countersignature (ASN1CTXT* pctxt,
   ASN1T_Countersignature *pvalue, ASN1TagType tagging);

EXTERN int asn1D_Countersignature (ASN1CTXT* pctxt,
   ASN1T_Countersignature *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_Countersignature (ASN1CTXT *pctxt, ASN1T_Countersignature* pSrcValue, ASN1T_Countersignature* pDstValue);

EXTERN void asn1Free_Countersignature (ASN1CTXT *pctxt, ASN1T_Countersignature* pvalue);

/**************************************************************/
/*                                                            */
/*  KeyWrapAlgorithm                                          */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_KeyWrapAlgorithm;

typedef ASN1T_AlgorithmIdentifier ASN1T_KeyWrapAlgorithm;

class EXTERN ASN1C_KeyWrapAlgorithm :
   public ASN1C_AlgorithmIdentifier
{
protected:
public:
   ASN1C_KeyWrapAlgorithm (ASN1T_KeyWrapAlgorithm& data);
   ASN1C_KeyWrapAlgorithm (
      ASN1MessageBufferIF& msgBuf, ASN1T_KeyWrapAlgorithm& data);
   ASN1C_KeyWrapAlgorithm (ASN1C_KeyWrapAlgorithm& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_KeyWrapAlgorithm& getCopy (ASN1T_KeyWrapAlgorithm* pDstData = 0);
   ASN1T_KeyWrapAlgorithm* newCopy ();

   inline ASN1C_KeyWrapAlgorithm& operator= (ASN1C_KeyWrapAlgorithm& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_KeyWrapAlgorithm (ASN1CTXT* pctxt,
   ASN1T_KeyWrapAlgorithm *pvalue, ASN1TagType tagging);

EXTERN int asn1D_KeyWrapAlgorithm (ASN1CTXT* pctxt,
   ASN1T_KeyWrapAlgorithm *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_KeyWrapAlgorithm (ASN1CTXT *pctxt, ASN1T_KeyWrapAlgorithm* pSrcValue, ASN1T_KeyWrapAlgorithm* pDstValue);

EXTERN void asn1Free_KeyWrapAlgorithm (ASN1CTXT *pctxt, ASN1T_KeyWrapAlgorithm* pvalue);

/**************************************************************/
/*                                                            */
/*  RC2ParameterVersion                                       */
/*                                                            */
/**************************************************************/

typedef ASN1INT ASN1T_RC2ParameterVersion;

class EXTERN ASN1C_RC2ParameterVersion :
   public ASN1CType
{
protected:
   ASN1T_RC2ParameterVersion& msgData;
public:
   ASN1C_RC2ParameterVersion (ASN1T_RC2ParameterVersion& data);
   ASN1C_RC2ParameterVersion (
      ASN1MessageBufferIF& msgBuf, ASN1T_RC2ParameterVersion& data);
   ASN1C_RC2ParameterVersion (ASN1C_RC2ParameterVersion& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_RC2ParameterVersion& getCopy (ASN1T_RC2ParameterVersion* pDstData = 0);
   ASN1T_RC2ParameterVersion* newCopy ();

   inline ASN1C_RC2ParameterVersion& operator= (ASN1C_RC2ParameterVersion& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_RC2ParameterVersion (ASN1CTXT* pctxt,
   ASN1T_RC2ParameterVersion *pvalue, ASN1TagType tagging);

EXTERN int asn1D_RC2ParameterVersion (ASN1CTXT* pctxt,
   ASN1T_RC2ParameterVersion *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_RC2ParameterVersion (ASN1CTXT *pctxt, ASN1T_RC2ParameterVersion* pSrcValue, ASN1T_RC2ParameterVersion* pDstValue);

/**************************************************************/
/*                                                            */
/*  RC2wrapParameter                                          */
/*                                                            */
/**************************************************************/

typedef ASN1T_RC2ParameterVersion ASN1T_RC2wrapParameter;

class EXTERN ASN1C_RC2wrapParameter :
   public ASN1C_RC2ParameterVersion
{
protected:
public:
   ASN1C_RC2wrapParameter (ASN1T_RC2wrapParameter& data);
   ASN1C_RC2wrapParameter (
      ASN1MessageBufferIF& msgBuf, ASN1T_RC2wrapParameter& data);
   ASN1C_RC2wrapParameter (ASN1C_RC2wrapParameter& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_RC2wrapParameter& getCopy (ASN1T_RC2wrapParameter* pDstData = 0);
   ASN1T_RC2wrapParameter* newCopy ();

   inline ASN1C_RC2wrapParameter& operator= (ASN1C_RC2wrapParameter& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_RC2wrapParameter (ASN1CTXT* pctxt,
   ASN1T_RC2wrapParameter *pvalue, ASN1TagType tagging);

EXTERN int asn1D_RC2wrapParameter (ASN1CTXT* pctxt,
   ASN1T_RC2wrapParameter *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_RC2wrapParameter (ASN1CTXT *pctxt, ASN1T_RC2wrapParameter* pSrcValue, ASN1T_RC2wrapParameter* pDstValue);

/**************************************************************/
/*                                                            */
/*  IV                                                        */
/*                                                            */
/**************************************************************/

typedef ASN1TDynOctStr ASN1T_IV;

class EXTERN ASN1C_IV :
   public ASN1CType
{
protected:
   ASN1T_IV& msgData;
public:
   ASN1C_IV (ASN1T_IV& data);
   ASN1C_IV (
      ASN1MessageBufferIF& msgBuf, ASN1T_IV& data);
   ASN1C_IV (ASN1C_IV& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_IV& getCopy (ASN1T_IV* pDstData = 0);
   ASN1T_IV* newCopy ();

   inline ASN1C_IV& operator= (ASN1C_IV& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_IV (ASN1CTXT* pctxt,
   ASN1T_IV *pvalue, ASN1TagType tagging);

EXTERN int asn1D_IV (ASN1CTXT* pctxt,
   ASN1T_IV *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_IV (ASN1CTXT *pctxt, ASN1T_IV* pSrcValue, ASN1T_IV* pDstValue);

EXTERN void asn1Free_IV (ASN1CTXT *pctxt, ASN1T_IV* pvalue);

/**************************************************************/
/*                                                            */
/*  CBCParameter                                              */
/*                                                            */
/**************************************************************/

typedef ASN1T_IV ASN1T_CBCParameter;

class EXTERN ASN1C_CBCParameter :
   public ASN1C_IV
{
protected:
public:
   ASN1C_CBCParameter (ASN1T_CBCParameter& data);
   ASN1C_CBCParameter (
      ASN1MessageBufferIF& msgBuf, ASN1T_CBCParameter& data);
   ASN1C_CBCParameter (ASN1C_CBCParameter& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_CBCParameter& getCopy (ASN1T_CBCParameter* pDstData = 0);
   ASN1T_CBCParameter* newCopy ();

   inline ASN1C_CBCParameter& operator= (ASN1C_CBCParameter& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_CBCParameter (ASN1CTXT* pctxt,
   ASN1T_CBCParameter *pvalue, ASN1TagType tagging);

EXTERN int asn1D_CBCParameter (ASN1CTXT* pctxt,
   ASN1T_CBCParameter *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_CBCParameter (ASN1CTXT *pctxt, ASN1T_CBCParameter* pSrcValue, ASN1T_CBCParameter* pDstValue);

EXTERN void asn1Free_CBCParameter (ASN1CTXT *pctxt, ASN1T_CBCParameter* pvalue);

/**************************************************************/
/*                                                            */
/*  AES_IV                                                    */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_AES_IV;

typedef struct EXTERN ASN1T_AES_IV {
   ASN1UINT numocts;
   ASN1OCTET data[16];
   // ctors
   ASN1T_AES_IV () : numocts(0) {}
   ASN1T_AES_IV (ASN1UINT _numocts, const ASN1OCTET* _data) :
      numocts (_numocts) {
      memcpy (data, _data, ASN1MIN (numocts, sizeof(data)));
   }
   ASN1T_AES_IV (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = ASN1MIN ((strlen(cstring)+1), sizeof(data));
         strncpy ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
   }
   ASN1T_AES_IV (ASN1C_AES_IV& srcData);
   // assignment operators
   ASN1T_AES_IV& operator= (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = ASN1MIN ((strlen(cstring)+1), sizeof(data));
         strncpy ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
      return *this;
   }
} ASN1T_AES_IV;

class EXTERN ASN1C_AES_IV :
   public ASN1CType
{
protected:
   ASN1T_AES_IV& msgData;
public:
   ASN1C_AES_IV (ASN1T_AES_IV& data);
   ASN1C_AES_IV (
      ASN1MessageBufferIF& msgBuf, ASN1T_AES_IV& data);
   ASN1C_AES_IV (ASN1C_AES_IV& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_AES_IV& getCopy (ASN1T_AES_IV* pDstData = 0);
   ASN1T_AES_IV* newCopy ();

   inline ASN1C_AES_IV& operator= (ASN1C_AES_IV& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_AES_IV (ASN1CTXT* pctxt,
   ASN1T_AES_IV *pvalue, ASN1TagType tagging);

EXTERN int asn1D_AES_IV (ASN1CTXT* pctxt,
   ASN1T_AES_IV *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_AES_IV (ASN1CTXT *pctxt, ASN1T_AES_IV* pSrcValue, ASN1T_AES_IV* pDstValue);

/**************************************************************/
/*                                                            */
/*  RC2CBCParameter                                           */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_RC2CBCParameter;

typedef struct EXTERN ASN1T_RC2CBCParameter : public ASN1TPDU {
   ASN1INT rc2ParameterVersion;
   ASN1TDynOctStr iv;
   ASN1T_RC2CBCParameter ();
   ASN1T_RC2CBCParameter (ASN1C_RC2CBCParameter& srcData);
   ~ASN1T_RC2CBCParameter ();
} ASN1T_RC2CBCParameter;

class EXTERN ASN1C_RC2CBCParameter :
   public ASN1CType
{
protected:
   ASN1T_RC2CBCParameter& msgData;
public:
   ASN1C_RC2CBCParameter (ASN1T_RC2CBCParameter& data);
   ASN1C_RC2CBCParameter (
      ASN1MessageBufferIF& msgBuf, ASN1T_RC2CBCParameter& data);
   ASN1C_RC2CBCParameter (ASN1C_RC2CBCParameter& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_RC2CBCParameter& getCopy (ASN1T_RC2CBCParameter* pDstData = 0);
   ASN1T_RC2CBCParameter* newCopy ();

   inline ASN1C_RC2CBCParameter& operator= (ASN1C_RC2CBCParameter& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_RC2CBCParameter (ASN1CTXT* pctxt,
   ASN1T_RC2CBCParameter *pvalue, ASN1TagType tagging);

EXTERN int asn1D_RC2CBCParameter (ASN1CTXT* pctxt,
   ASN1T_RC2CBCParameter *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_RC2CBCParameter (ASN1CTXT *pctxt, ASN1T_RC2CBCParameter* pSrcValue, ASN1T_RC2CBCParameter* pDstValue);

EXTERN void asn1Free_RC2CBCParameter (ASN1CTXT *pctxt, ASN1T_RC2CBCParameter* pvalue);

/**************************************************************/
/*                                                            */
/*  RSAES_OAEP_params                                         */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_RSAES_OAEP_params;

typedef struct EXTERN ASN1T_RSAES_OAEP_params : public ASN1TPDU {
   struct {
      unsigned hashAlgorithmPresent : 1;
      unsigned maskGenAlgorithmPresent : 1;
      unsigned pSourceAlgorithmPresent : 1;
   } m;
   ASN1T_AlgorithmIdentifier hashAlgorithm;
   ASN1T_AlgorithmIdentifier maskGenAlgorithm;
   ASN1T_AlgorithmIdentifier pSourceAlgorithm;
   ASN1T_RSAES_OAEP_params ();
   ASN1T_RSAES_OAEP_params (ASN1C_RSAES_OAEP_params& srcData);
   ~ASN1T_RSAES_OAEP_params ();
} ASN1T_RSAES_OAEP_params;

class EXTERN ASN1C_RSAES_OAEP_params :
   public ASN1CType
{
protected:
   ASN1T_RSAES_OAEP_params& msgData;
public:
   ASN1C_RSAES_OAEP_params (ASN1T_RSAES_OAEP_params& data);
   ASN1C_RSAES_OAEP_params (
      ASN1MessageBufferIF& msgBuf, ASN1T_RSAES_OAEP_params& data);
   ASN1C_RSAES_OAEP_params (ASN1C_RSAES_OAEP_params& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_RSAES_OAEP_params& getCopy (ASN1T_RSAES_OAEP_params* pDstData = 0);
   ASN1T_RSAES_OAEP_params* newCopy ();

   inline ASN1C_RSAES_OAEP_params& operator= (ASN1C_RSAES_OAEP_params& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_RSAES_OAEP_params (ASN1CTXT* pctxt,
   ASN1T_RSAES_OAEP_params *pvalue, ASN1TagType tagging);

EXTERN int asn1D_RSAES_OAEP_params (ASN1CTXT* pctxt,
   ASN1T_RSAES_OAEP_params *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_RSAES_OAEP_params (ASN1CTXT *pctxt, ASN1T_RSAES_OAEP_params* pSrcValue, ASN1T_RSAES_OAEP_params* pDstValue);

EXTERN void asn1Free_RSAES_OAEP_params (ASN1CTXT *pctxt, ASN1T_RSAES_OAEP_params* pvalue);

/**************************************************************/
/*                                                            */
/*  RSASSA_PSS_params                                         */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_RSASSA_PSS_params;

typedef struct EXTERN ASN1T_RSASSA_PSS_params : public ASN1TPDU {
   struct {
      unsigned hashAlgorithmPresent : 1;
      unsigned maskGenAlgorithmPresent : 1;
   } m;
   ASN1T_AlgorithmIdentifier hashAlgorithm;
   ASN1T_AlgorithmIdentifier maskGenAlgorithm;
   ASN1INT saltLength;
   ASN1INT trailerField;
   ASN1T_RSASSA_PSS_params ();
   ASN1T_RSASSA_PSS_params (ASN1C_RSASSA_PSS_params& srcData);
   ~ASN1T_RSASSA_PSS_params ();
} ASN1T_RSASSA_PSS_params;

class EXTERN ASN1C_RSASSA_PSS_params :
   public ASN1CType
{
protected:
   ASN1T_RSASSA_PSS_params& msgData;
public:
   ASN1C_RSASSA_PSS_params (ASN1T_RSASSA_PSS_params& data);
   ASN1C_RSASSA_PSS_params (
      ASN1MessageBufferIF& msgBuf, ASN1T_RSASSA_PSS_params& data);
   ASN1C_RSASSA_PSS_params (ASN1C_RSASSA_PSS_params& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_RSASSA_PSS_params& getCopy (ASN1T_RSASSA_PSS_params* pDstData = 0);
   ASN1T_RSASSA_PSS_params* newCopy ();

   inline ASN1C_RSASSA_PSS_params& operator= (ASN1C_RSASSA_PSS_params& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_RSASSA_PSS_params (ASN1CTXT* pctxt,
   ASN1T_RSASSA_PSS_params *pvalue, ASN1TagType tagging);

EXTERN int asn1D_RSASSA_PSS_params (ASN1CTXT* pctxt,
   ASN1T_RSASSA_PSS_params *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_RSASSA_PSS_params (ASN1CTXT *pctxt, ASN1T_RSASSA_PSS_params* pSrcValue, ASN1T_RSASSA_PSS_params* pDstValue);

EXTERN void asn1Free_RSASSA_PSS_params (ASN1CTXT *pctxt, ASN1T_RSASSA_PSS_params* pvalue);

/**************************************************************/
/*                                                            */
/*  PBKDF2_params_salt                                        */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_PBKDF2_params_salt_specified  1
#define T_PBKDF2_params_salt_otherSource 2

class EXTERN ASN1C_PBKDF2_params_salt;

typedef struct EXTERN ASN1T_PBKDF2_params_salt : public ASN1TPDU {
   int t;
   union {
      /* t = 1 */
      ASN1TDynOctStr *specified;
      /* t = 2 */
      ASN1T_AlgorithmIdentifier *otherSource;
   } u;
   ASN1T_PBKDF2_params_salt () {}
   ASN1T_PBKDF2_params_salt (ASN1C_PBKDF2_params_salt& srcData);
   ~ASN1T_PBKDF2_params_salt ();
} ASN1T_PBKDF2_params_salt;

class EXTERN ASN1C_PBKDF2_params_salt :
   public ASN1CType
{
protected:
   ASN1T_PBKDF2_params_salt& msgData;
public:
   ASN1C_PBKDF2_params_salt (ASN1T_PBKDF2_params_salt& data);
   ASN1C_PBKDF2_params_salt (
      ASN1MessageBufferIF& msgBuf, ASN1T_PBKDF2_params_salt& data);
   ASN1C_PBKDF2_params_salt (ASN1C_PBKDF2_params_salt& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_PBKDF2_params_salt& getCopy (ASN1T_PBKDF2_params_salt* pDstData = 0);
   ASN1T_PBKDF2_params_salt* newCopy ();

   inline ASN1C_PBKDF2_params_salt& operator= (ASN1C_PBKDF2_params_salt& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_PBKDF2_params_salt (ASN1CTXT* pctxt,
   ASN1T_PBKDF2_params_salt *pvalue, ASN1TagType tagging);

EXTERN int asn1D_PBKDF2_params_salt (ASN1CTXT* pctxt,
   ASN1T_PBKDF2_params_salt *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_PBKDF2_params_salt (ASN1CTXT *pctxt, ASN1T_PBKDF2_params_salt* pSrcValue, ASN1T_PBKDF2_params_salt* pDstValue);

EXTERN void asn1Free_PBKDF2_params_salt (ASN1CTXT *pctxt, ASN1T_PBKDF2_params_salt* pvalue);

/**************************************************************/
/*                                                            */
/*  PBKDF2_params                                             */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_PBKDF2_params;

typedef struct EXTERN ASN1T_PBKDF2_params : public ASN1TPDU {
   struct {
      unsigned keyLengthPresent : 1;
      unsigned prfPresent : 1;
   } m;
   ASN1T_PBKDF2_params_salt salt;
   ASN1UINT iterationCount;
   ASN1UINT keyLength;
   ASN1T_AlgorithmIdentifier prf;
   ASN1T_PBKDF2_params ();
   ASN1T_PBKDF2_params (ASN1C_PBKDF2_params& srcData);
   ~ASN1T_PBKDF2_params ();
} ASN1T_PBKDF2_params;

class EXTERN ASN1C_PBKDF2_params :
   public ASN1CType
{
protected:
   ASN1T_PBKDF2_params& msgData;
public:
   ASN1C_PBKDF2_params (ASN1T_PBKDF2_params& data);
   ASN1C_PBKDF2_params (
      ASN1MessageBufferIF& msgBuf, ASN1T_PBKDF2_params& data);
   ASN1C_PBKDF2_params (ASN1C_PBKDF2_params& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_PBKDF2_params& getCopy (ASN1T_PBKDF2_params* pDstData = 0);
   ASN1T_PBKDF2_params* newCopy ();

   inline ASN1C_PBKDF2_params& operator= (ASN1C_PBKDF2_params& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_PBKDF2_params (ASN1CTXT* pctxt,
   ASN1T_PBKDF2_params *pvalue, ASN1TagType tagging);

EXTERN int asn1D_PBKDF2_params (ASN1CTXT* pctxt,
   ASN1T_PBKDF2_params *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_PBKDF2_params (ASN1CTXT *pctxt, ASN1T_PBKDF2_params* pSrcValue, ASN1T_PBKDF2_params* pDstValue);

EXTERN void asn1Free_PBKDF2_params (ASN1CTXT *pctxt, ASN1T_PBKDF2_params* pvalue);

/**************************************************************/
/*                                                            */
/*  PBES2_params                                              */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_PBES2_params;

typedef struct EXTERN ASN1T_PBES2_params : public ASN1TPDU {
   ASN1T_AlgorithmIdentifier keyDerivationFunc;
   ASN1T_AlgorithmIdentifier encryptionScheme;
   ASN1T_PBES2_params ();
   ASN1T_PBES2_params (ASN1C_PBES2_params& srcData);
   ~ASN1T_PBES2_params ();
} ASN1T_PBES2_params;

class EXTERN ASN1C_PBES2_params :
   public ASN1CType
{
protected:
   ASN1T_PBES2_params& msgData;
public:
   ASN1C_PBES2_params (ASN1T_PBES2_params& data);
   ASN1C_PBES2_params (
      ASN1MessageBufferIF& msgBuf, ASN1T_PBES2_params& data);
   ASN1C_PBES2_params (ASN1C_PBES2_params& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_PBES2_params& getCopy (ASN1T_PBES2_params* pDstData = 0);
   ASN1T_PBES2_params* newCopy ();

   inline ASN1C_PBES2_params& operator= (ASN1C_PBES2_params& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_PBES2_params (ASN1CTXT* pctxt,
   ASN1T_PBES2_params *pvalue, ASN1TagType tagging);

EXTERN int asn1D_PBES2_params (ASN1CTXT* pctxt,
   ASN1T_PBES2_params *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_PBES2_params (ASN1CTXT *pctxt, ASN1T_PBES2_params* pSrcValue, ASN1T_PBES2_params* pDstValue);

EXTERN void asn1Free_PBES2_params (ASN1CTXT *pctxt, ASN1T_PBES2_params* pvalue);

/**************************************************************/
/*                                                            */
/*  SharedInfo                                                */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_SharedInfo;

typedef struct EXTERN ASN1T_SharedInfo : public ASN1TPDU {
   struct {
      unsigned entityUInfoPresent : 1;
   } m;
   ASN1T_AlgorithmIdentifier keyInfo;
   ASN1TDynOctStr entityUInfo;
   ASN1TDynOctStr suppPubInfo;
   ASN1T_SharedInfo ();
   ASN1T_SharedInfo (ASN1C_SharedInfo& srcData);
   ~ASN1T_SharedInfo ();
} ASN1T_SharedInfo;

class EXTERN ASN1C_SharedInfo :
   public ASN1CType
{
protected:
   ASN1T_SharedInfo& msgData;
public:
   ASN1C_SharedInfo (ASN1T_SharedInfo& data);
   ASN1C_SharedInfo (
      ASN1MessageBufferIF& msgBuf, ASN1T_SharedInfo& data);
   ASN1C_SharedInfo (ASN1C_SharedInfo& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_SharedInfo& getCopy (ASN1T_SharedInfo* pDstData = 0);
   ASN1T_SharedInfo* newCopy ();

   inline ASN1C_SharedInfo& operator= (ASN1C_SharedInfo& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_SharedInfo (ASN1CTXT* pctxt,
   ASN1T_SharedInfo *pvalue, ASN1TagType tagging);

EXTERN int asn1D_SharedInfo (ASN1CTXT* pctxt,
   ASN1T_SharedInfo *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_SharedInfo (ASN1CTXT *pctxt, ASN1T_SharedInfo* pSrcValue, ASN1T_SharedInfo* pDstValue);

EXTERN void asn1Free_SharedInfo (ASN1CTXT *pctxt, ASN1T_SharedInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  TR34EncryptedData                                         */
/*                                                            */
/**************************************************************/

class EXTERN ASN1C_TR34EncryptedData;

typedef struct EXTERN ASN1T_TR34EncryptedData : public ASN1TPDU {
   ASN1INT version;
   ASN1T_IssuerAndSerialNumber issuerAndSerialNumber;
   ASN1TDynOctStr key;
   ASN1T_Attribute data;
   ASN1T_TR34EncryptedData ();
   ASN1T_TR34EncryptedData (ASN1C_TR34EncryptedData& srcData);
   ~ASN1T_TR34EncryptedData ();
} ASN1T_TR34EncryptedData;

class EXTERN ASN1C_TR34EncryptedData :
   public ASN1CType
{
protected:
   ASN1T_TR34EncryptedData& msgData;
public:
   ASN1C_TR34EncryptedData (ASN1T_TR34EncryptedData& data);
   ASN1C_TR34EncryptedData (
      ASN1MessageBufferIF& msgBuf, ASN1T_TR34EncryptedData& data);
   ASN1C_TR34EncryptedData (ASN1C_TR34EncryptedData& original);

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   int EncodeTo (ASN1MessageBufferIF& msgBuf);
   int DecodeFrom (ASN1MessageBufferIF& msgBuf);

   ASN1T_TR34EncryptedData& getCopy (ASN1T_TR34EncryptedData* pDstData = 0);
   ASN1T_TR34EncryptedData* newCopy ();

   inline ASN1C_TR34EncryptedData& operator= (ASN1C_TR34EncryptedData& srcData) {
      srcData.getCopy (&msgData);
      return *this;
   }
} ;

EXTERN int asn1E_TR34EncryptedData (ASN1CTXT* pctxt,
   ASN1T_TR34EncryptedData *pvalue, ASN1TagType tagging);

EXTERN int asn1D_TR34EncryptedData (ASN1CTXT* pctxt,
   ASN1T_TR34EncryptedData *pvalue, ASN1TagType tagging, int length);

EXTERN void asn1Copy_TR34EncryptedData (ASN1CTXT *pctxt, ASN1T_TR34EncryptedData* pSrcValue, ASN1T_TR34EncryptedData* pDstValue);

EXTERN void asn1Free_TR34EncryptedData (ASN1CTXT *pctxt, ASN1T_TR34EncryptedData* pvalue);

/* Value definitions */

extern EXTERN ASN1OBJID desCBC;
extern EXTERN ASN1OBJID sha_1;
extern EXTERN ASN1OBJID id_mgf1;
extern EXTERN ASN1OBJID id_pSpecified;
extern EXTERN ASN1OBJID dh_public_number;
extern EXTERN ASN1OBJID id_alg_ESDH;
extern EXTERN ASN1OBJID id_alg_CMS3DESwrap;
extern EXTERN ASN1OBJID id_alg_CMSRC2wrap;
extern EXTERN ASN1OBJID des_ede3_cbc;
extern EXTERN ASN1OBJID rc2_cbc;
extern EXTERN ASN1OBJID rc4;
extern EXTERN ASN1OBJID hMAC_SHA1;
extern EXTERN ASN1OBJID id_PBKDF2;
extern EXTERN ASN1OBJID id_PBES2;
extern EXTERN ASN1OBJID id_CryptoPro_encrypts_genericsecret;
extern EXTERN ASN1OBJID id_CryptoPro_encrypts_2des;
extern EXTERN ASN1OBJID id_CryptoPro_encrypts_gostgenericsecret;
extern EXTERN ASN1OBJID id_CryptoPro_encrypts_hybridsecret;
extern EXTERN ASN1OBJID aes;
extern EXTERN ASN1OBJID id_aes128_ECB;
extern EXTERN ASN1OBJID id_aes128_CBC;
extern EXTERN ASN1OBJID id_aes128_OFB;
extern EXTERN ASN1OBJID id_aes128_CFB;
extern EXTERN ASN1OBJID id_aes128_wrap;
extern EXTERN ASN1OBJID id_aes128_GCM;
extern EXTERN ASN1OBJID id_aes128_CCM;
extern EXTERN ASN1OBJID id_aes128_wrap_pad;
extern EXTERN ASN1OBJID id_aes192_ECB;
extern EXTERN ASN1OBJID id_aes192_CBC;
extern EXTERN ASN1OBJID id_aes192_OFB;
extern EXTERN ASN1OBJID id_aes192_CFB;
extern EXTERN ASN1OBJID id_aes192_wrap;
extern EXTERN ASN1OBJID id_aes192_GCM;
extern EXTERN ASN1OBJID id_aes192_CCM;
extern EXTERN ASN1OBJID id_aes192_wrap_pad;
extern EXTERN ASN1OBJID id_aes256_ECB;
extern EXTERN ASN1OBJID id_aes256_CBC;
extern EXTERN ASN1OBJID id_aes256_OFB;
extern EXTERN ASN1OBJID id_aes256_CFB;
extern EXTERN ASN1OBJID id_aes256_wrap;
extern EXTERN ASN1OBJID id_aes256_GCM;
extern EXTERN ASN1OBJID id_aes256_CCM;
extern EXTERN ASN1OBJID id_aes256_wrap_pad;
extern EXTERN ASN1OBJID id_ct_contentInfo;
extern EXTERN ASN1OBJID id_data;
extern EXTERN ASN1OBJID id_signedData;
extern EXTERN ASN1OBJID id_envelopedData;
extern EXTERN ASN1OBJID id_digestedData;
extern EXTERN ASN1OBJID id_encryptedData;
extern EXTERN ASN1OBJID id_ct_authData;

}
#endif
