<?xml version="1.0" encoding="windows-1251"?>

 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		 xmlns:msxsl="urn:schemas-microsoft-com:xslt"
		 xmlns:cp="localhost"
		 xmlns:fo="http://www.w3.org/1999/XSL/Format"
 		 version='1.0'>

    <!--  -->

<!--function BitToHex(bits) {
      var res='';
      for (var i=0; 4*i+3 < bits.length;i++)
	{if ((bits[4*i]=='0')&(bits[4*i+1]=='0')&(bits[4*i+2]=='0')&(bits[4*i+3]=='0')) {res[i]='0';}
	 if ((bits[4*i]=='0')&(bits[4*i+1]=='0')&(bits[4*i+2]=='0')&(bits[4*i+3]=='1')) {res[i]='1';}
	 if ((bits[4*i]=='0')&(bits[4*i+1]=='0')&(bits[4*i+2]=='1')&(bits[4*i+3]=='0')) {res[i]='2';}
	 if ((bits[4*i]=='0')&(bits[4*i+1]=='0')&(bits[4*i+2]=='1')&(bits[4*i+3]=='1')) {res[i]='3';}
	 if ((bits[4*i]=='0')&(bits[4*i+1]=='1')&(bits[4*i+2]=='0')&(bits[4*i+3]=='0')) {res[i]='4';}
	 if ((bits[4*i]=='0')&(bits[4*i+1]=='1')&(bits[4*i+2]=='0')&(bits[4*i+3]=='1')) {res[i]='5';}
	 if ((bits[4*i]=='0')&(bits[4*i+1]=='1')&(bits[4*i+2]=='1')&(bits[4*i+3]=='0')) {res[i]='6';}
	 if ((bits[4*i]=='0')&(bits[4*i+1]=='1')&(bits[4*i+2]=='1')&(bits[4*i+3]=='1')) {res[i]='7';}
	 if ((bits[4*i]=='1')&(bits[4*i+1]=='0')&(bits[4*i+2]=='0')&(bits[4*i+3]=='0')) {res[i]='8';}
	 if ((bits[4*i]=='1')&(bits[4*i+1]=='0')&(bits[4*i+2]=='0')&(bits[4*i+3]=='1')) {res[i]='9';}
	 if ((bits[4*i]=='1')&(bits[4*i+1]=='0')&(bits[4*i+2]=='1')&(bits[4*i+3]=='0')) {res[i]='A';}
	 if ((bits[4*i]=='1')&(bits[4*i+1]=='0')&(bits[4*i+2]=='1')&(bits[4*i+3]=='1')) {res[i]='B';}
	 if ((bits[4*i]=='1')&(bits[4*i+1]=='1')&(bits[4*i+2]=='0')&(bits[4*i+3]=='0')) {res[i]='C';}
	 if ((bits[4*i]=='1')&(bits[4*i+1]=='1')&(bits[4*i+2]=='0')&(bits[4*i+3]=='1')) {res[i]='D';}
	 if ((bits[4*i]=='1')&(bits[4*i+1]=='1')&(bits[4*i+2]=='1')&(bits[4*i+3]=='0')) {res[i]='E';}
	 if ((bits[4*i]=='1')&(bits[4*i+1]=='1')&(bits[4*i+2]=='1')&(bits[4*i+3]=='1')) {res[i]='F';}
	}

      return res;
   }-->


<msxsl:script language="JScript" implements-prefix="cp">
 <![CDATA[ 
   function BitToHex(bits) {
      var res='';
      for (var i=0; 4*i+3 < bits.length;i++)
	{if (bits.substr(4*i,4)=='0000') {res=res+'0';}
	 if (bits.substr(4*i,4)=='0001') {res=res+'1';}
	 if (bits.substr(4*i,4)=='0010') {res=res+'2';}
	 if (bits.substr(4*i,4)=='0011') {res=res+'3';}
	 if (bits.substr(4*i,4)=='0100') {res=res+'4';}
	 if (bits.substr(4*i,4)=='0101') {res=res+'5';}
	 if (bits.substr(4*i,4)=='0110') {res=res+'6';}
	 if (bits.substr(4*i,4)=='0111') {res=res+'7';}
	 if (bits.substr(4*i,4)=='1000') {res=res+'8';}
	 if (bits.substr(4*i,4)=='1001') {res=res+'9';}
	 if (bits.substr(4*i,4)=='1010') {res=res+'A';}
	 if (bits.substr(4*i,4)=='1011') {res=res+'B';}
	 if (bits.substr(4*i,4)=='1100') {res=res+'C';}
	 if (bits.substr(4*i,4)=='1101') {res=res+'D';}
	 if (bits.substr(4*i,4)=='1110') {res=res+'E';}
	 if (bits.substr(4*i,4)=='1111') {res=res+'F';}
	}
      return res+'+'+bits.length;
   }

   function HexToBit(Hex) {
      var res='';
      for (var i=0; i < Hex.length;i++)
	{if (Hex.substr(i,1)=='0') {res=res+'0000';}
	 if (Hex.substr(i,1)=='1') {res=res+'0001';}
	 if (Hex.substr(i,1)=='2') {res=res+'0010';}
	 if (Hex.substr(i,1)=='3') {res=res+'0011';}
	 if (Hex.substr(i,1)=='4') {res=res+'0100';}
	 if (Hex.substr(i,1)=='5') {res=res+'0101';}
	 if (Hex.substr(i,1)=='6') {res=res+'0110';}
	 if (Hex.substr(i,1)=='7') {res=res+'0111';}
	 if (Hex.substr(i,1)=='8') {res=res+'1000';}
	 if (Hex.substr(i,1)=='9') {res=res+'1001';}
	 if (Hex.substr(i,1)=='A') {res=res+'1010';}
	 if (Hex.substr(i,1)=='B') {res=res+'1011';}
	 if (Hex.substr(i,1)=='C') {res=res+'1100';}
	 if (Hex.substr(i,1)=='D') {res=res+'1101';}
	 if (Hex.substr(i,1)=='E') {res=res+'1110';}
	 if (Hex.substr(i,1)=='F') {res=res+'0111';}

	}

      return res;
   }

 ]]> 
</msxsl:script>



<xsl:template name="BitToHex">


     <xsl:for-each select="./utcTime">  
	<xsl:call-template name="UTCTime"/>
    </xsl:for-each>

	<!--   GeneralizedTime -->
     <xsl:for-each select="./generalTime">  
	<xsl:call-template name="GeneralizedTime"/>
    </xsl:for-each>

</xsl:template>




    <!--  -->


 <!--   -->
<xsl:template name="Time" match="Time">

	<!--   UTCTime -->

     <xsl:for-each select="./utcTime">  
	<xsl:call-template name="UTCTime"/>
    </xsl:for-each>

	<!--   GeneralizedTime -->
     <xsl:for-each select="./generalTime">  
	<xsl:call-template name="GeneralizedTime"/>
    </xsl:for-each>

</xsl:template>


	<!--   UTCTime -->
<xsl:template name="UTCTime" match="UTCTime">
    <!-- ??? ,    ??? -->
    <!-- ??? YY bigger then 49=19YY otherwise =20YY ??? -->

  <xsl:value-of select="substring(., 5,2)"/>
  <xsl:text>.</xsl:text>
  <xsl:value-of select="substring(., 3,2)"/>
  <xsl:choose>
      <xsl:when test="number(substring(., 1,2)) &gt; 49">
	<xsl:text>.19</xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text>.20</xsl:text>
      </xsl:otherwise>
  </xsl:choose>
  <xsl:value-of select="substring(., 1,2)"/>
  <xsl:text> </xsl:text>
  <xsl:value-of select="substring(., 7,2)"/>
  <xsl:text>:</xsl:text>
  <xsl:value-of select="substring(., 9,2)"/>
  <xsl:text>:</xsl:text>
  <xsl:value-of select="substring(.,11,2)"/>


</xsl:template>



	<!--   UTCTime -->
<xsl:template name="GeneralizedTime" match="GeneralizedTime">
  <xsl:value-of select="substring(., 7,2)"/>
  <xsl:text>.</xsl:text>
  <xsl:value-of select="substring(., 5,2)"/>
  <xsl:text>.</xsl:text>
  <xsl:value-of select="substring(., 1,4)"/>
  <xsl:text> </xsl:text>
  <xsl:value-of select="substring(., 9,2)"/>
  <xsl:text>:</xsl:text>
  <xsl:value-of select="substring(., 11,2)"/>
  <xsl:text>:</xsl:text>
  <xsl:value-of select="substring(.,13,2)"/>
</xsl:template>




<xsl:template match="ReasonFlags" name="ReasonFlags">


  <xsl:value-of select="."/>

  <xsl:text> </xsl:text>
  <xsl:if test='substring(.,1,1) = 1'>
	<!--  unused -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ReasonFlags_unused</xsl:with-param> </xsl:call-template>
  </xsl:if>

  <xsl:text> </xsl:text>
  <xsl:if test='substring(.,2,1) = 1'>
	<!-- keyCompromise -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ReasonFlags_keyCompromise</xsl:with-param> </xsl:call-template>
  </xsl:if>

  <xsl:text> </xsl:text>
  <xsl:if test='substring(.,3,1) = 1'>
	<!-- caCompromise -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ReasonFlags_caCompromise</xsl:with-param> </xsl:call-template>
  </xsl:if>

  <xsl:text> </xsl:text>
  <xsl:if test='substring(.,4,1) = 1'>
	<!-- affiliationChanged -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ReasonFlags_affiliationChanged</xsl:with-param> </xsl:call-template>
  </xsl:if>

  <xsl:text> </xsl:text>
  <xsl:if test='substring(.,5,1) = 1'>
	<!-- superseded -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ReasonFlags_superseded</xsl:with-param> </xsl:call-template>
  </xsl:if>

  <xsl:text> </xsl:text>
  <xsl:if test='substring(.,6,1) = 1'>
	<!-- cessationOfOperation -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ReasonFlags_cessationOfOperation</xsl:with-param> </xsl:call-template>
  </xsl:if>

  <xsl:text> </xsl:text>
  <xsl:if test='substring(.,7,1) = 1'>
	<!-- certificateHold -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ReasonFlags_certificateHold</xsl:with-param> </xsl:call-template>
  </xsl:if>

</xsl:template>



<!--     -->
<xsl:template name="AttributeTypeAndValue" match="AttributeTypeAndValue">
    <xsl:variable name="oidlength">
      <xsl:call-template name="printOIDlength">
      <xsl:with-param name="ID">
	<xsl:value-of select="./type"/>
      </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
     <xsl:for-each select="./type">
     		<xsl:call-template name="printOID"/>
     </xsl:for-each>

    <xsl:call-template name="longWord">
      <xsl:with-param name="val">
	<xsl:value-of select="./value"/>
      </xsl:with-param>
      <xsl:with-param name="startpos">
	<xsl:value-of select="$oidlength"/>
      </xsl:with-param>
    </xsl:call-template>

<!--  <xsl:apply-templates select="./value"/>-->
</xsl:template>

<xsl:template match="ORAddres" name="ORAddres">
  <xsl:value-of select="."/>
</xsl:template>

<xsl:template match="EDIPartyName" name="EDIPartyName">
  <xsl:value-of select="."/>
</xsl:template>

<xsl:template name="Controls" match="Controls">
	<xsl:for-each select="./*">
		<xsl:call-template name="AttributeTypeAndValue"/>
	</xsl:for-each>
</xsl:template>

<xsl:template name="EncryptedValue" match="EncryptedValue">
	<xsl:value-of select="."/>
</xsl:template>


<xsl:template match="UnknownInfo" name="UnknownInfo">
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_UnknownInfo_header</xsl:with-param> </xsl:call-template>
</xsl:template>	


<xsl:template name="SinglePubInfo" match="SinglePubInfo">
	<xsl:for-each select="action">

		<xsl:if test=". = 0">
			<xsl:value-of select="."/>
		</xsl:if>

		<xsl:if test=". = 1">
			<xsl:value-of select="."/>
		</xsl:if>

		<xsl:if test=". = 2">
			<xsl:value-of select="."/>
		</xsl:if>

		<xsl:if test=". = 3">
			<xsl:value-of select="."/>
		</xsl:if>
	</xsl:for-each>

	<xsl:for-each select="pubLocation">
		<xsl:call-template name="API_GeneralName"/>
	</xsl:for-each>

</xsl:template>

    <!--   -->




<xsl:template match="Signature" name="API_Signature" mode="text">
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Signature_header</xsl:with-param> </xsl:call-template>
    <xsl:text> </xsl:text>
    <xsl:value-of select="."/>
</xsl:template>

<xsl:template name="API_AlgorithmIdentifier" match="AlgorithmIdentifier" mode="text">
  <xsl:for-each select="./algorithm">  
    <xsl:call-template name="printOID"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates select="./parameters/*" mode="text"/>
  </xsl:for-each>
</xsl:template>



<xsl:template name="API_Version" match="Version" mode="text">
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Version_header</xsl:with-param> </xsl:call-template>
    <xsl:text> </xsl:text>
    <xsl:value-of select='name(./*)'/>
</xsl:template>


<xsl:template name="API_CertificateSerialNumber" match="CertificateSerialNumber" mode="text">
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificateSerialNumber_header</xsl:with-param> </xsl:call-template>					<!--  -->
    <xsl:text> </xsl:text>
    <xsl:value-of select="."/>
</xsl:template>






    <!--   -->
<xsl:template name="API_Name" match="Name" mode="text">

    <!--    -->
     <xsl:for-each select="./rdnSequence">  
	<xsl:call-template name="API_RNDSequence"/>
     </xsl:for-each>

</xsl:template>

    <!--   -->
<xsl:template name="Short_Name" match="Name" mode="short">

    <!--    -->
     <xsl:for-each select="./rdnSequence">  
	<xsl:call-template name="Short_RNDSequence"/>
     </xsl:for-each>

</xsl:template>



    <!--    -->
<xsl:template name="Short_RNDSequence" match="RNDSequence" mode="short">
    <xsl:for-each select="./*">
        <xsl:sort select="position()" case-order="upper-first" data-type="number"/>
	<xsl:call-template name="API_RelativeDistinguishedName"/>
        <xsl:text> </xsl:text>
    </xsl:for-each>
</xsl:template>

    <!--    -->
<xsl:template name="API_RNDSequence" match="RNDSequence" mode="text">
    <xsl:for-each select="./*">
		<!--   RelativeDistinguishedName -->
	        <xsl:sort select="position()" case-order="upper-first" data-type="number"/>
		<xsl:variable name="name">
			<xsl:call-template name="API_RelativeDistinguishedName"/>
		</xsl:variable>

	    <xsl:if test="position() != last()">
		 <xsl:value-of select="concat($name,', ')"/>
	    </xsl:if>

	    <xsl:if test="position() = last()">
		    <xsl:value-of select="$name"/>
	    </xsl:if>
    </xsl:for-each>
</xsl:template>


 <!--    -->
<xsl:template name="API_RelativeDistinguishedName" match="RelativeDistinguishedName" mode="text">
     <xsl:for-each select="./*">  
        <xsl:if test="position() != 1">+</xsl:if>
	<xsl:call-template name="API_AttributeTypeAndValue"/>
     </xsl:for-each>
</xsl:template>



<!--     -->
<xsl:template name="API_AttributeTypeAndValue" match="AttributeTypeAndValue" mode="text">
        <xsl:for-each select="./type">
     		<xsl:call-template name="printOID"/>
     </xsl:for-each>
  <xsl:apply-templates select="./value" mode="text"/>
</xsl:template>


     <!--   -->
<xsl:template name="API_Validity" match="Validity" mode="text">

    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Validity_notBefore</xsl:with-param> </xsl:call-template>               <!--  -->
    <xsl:text> </xsl:text>
    <xsl:for-each select="./notBefore">  
	<xsl:call-template name="Time"/>
    </xsl:for-each>
    <xsl:text> </xsl:text>

    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Validity_notAfter</xsl:with-param> </xsl:call-template>		<!--  -->
    <xsl:text> </xsl:text>

    <xsl:for-each select="./notAfter">  
	<xsl:call-template name="Time"/>
    </xsl:for-each>


</xsl:template>



	<!--    -->
<xsl:template name="API_UniqueIdentifier" match="UniqueIdentifier" mode="text">
	<xsl:value-of select="."/>
</xsl:template>


<!--     -->
<xsl:template match="DigestParamSet" name="API_DigestParamSet" mode="text">
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DigestParamSet_header</xsl:with-param> </xsl:call-template>                             <!--  -->
    <xsl:text> </xsl:text>
    <xsl:call-template name="printOID"/>
</xsl:template>


	<!--   -->
<xsl:template match="EncryptionParamSet" name="API_EncryptionParamSet" mode="text">
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_EncryptionParamSet_header</xsl:with-param> </xsl:call-template>                             <!--  -->
    <xsl:text> </xsl:text>
    <xsl:call-template name="printOID"/>
</xsl:template>



<!--     -->
<xsl:template match="PublicKeyParamSet" name="API_PublicKeyParamSet" mode ="text">
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PublicKeyParamSet_header</xsl:with-param> </xsl:call-template> 
    <xsl:text> </xsl:text>
    <xsl:call-template name="printOID"/> 
</xsl:template>



<xsl:template match="GeneralName" name="API_GeneralName" mode="text">
   <xsl:apply-templates/>
</xsl:template>


<xsl:template match="Attribute" name="API_Attribute" mode="text">

  <xsl:variable name="attributeCount" select="$attributeCount + 1"/>

     <xsl:for-each select="./type">  
	<xsl:call-template name="printOID"/>
    </xsl:for-each>
    <xsl:text> </xsl:text>
    <xsl:choose>
      <xsl:when test='values/*'>
	<xsl:apply-templates select="values/*"/>
      </xsl:when>
      <xsl:otherwise>
	    <xsl:value-of select="values"/>
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>




<xsl:template name="API_CertId" match="CertId" mode="text">

	<!-- -->

    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertId_issuer</xsl:with-param> </xsl:call-template>
    <xsl:text> </xsl:text>
     <xsl:for-each select="./issuer">  
	<xsl:call-template name="API_GeneralName"/>
    </xsl:for-each>
    <xsl:text> </xsl:text>
    <xsl:for-each select="serialNumber">
	<xsl:call-template name="API_CertificateSerialNumber"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="API_TSAPolicyId" match="TSAPolicyId" mode="text">
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TSAPolicyId</xsl:with-param> </xsl:call-template>
    <xsl:text> </xsl:text>
    <xsl:call-template name="printOID"/>	
</xsl:template>

<xsl:template match="Nonce" name="API_Nonce" mode="text">

    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Nonce</xsl:with-param> </xsl:call-template>				
    <xsl:text> </xsl:text>
    <xsl:value-of select="."/>                                      		<!--  -->

</xsl:template>



<xsl:template match="SignerIdentifier" name="API_SignerIdentifier" mode="text">

    <xsl:for-each select="./issuerAndSerialNumber">  
	<xsl:call-template name="API_IssuerAndSerialNumber"/>
    </xsl:for-each>
    <xsl:text> </xsl:text>
    <xsl:for-each select="./subjectKeyIdentifier">  
	<xsl:call-template name="SubjectKeyIdentifier"/>
    </xsl:for-each>

</xsl:template>

<xsl:template match="IssuerAndSerialNumber" name="API_IssuerAndSerialNumber" mode="text">


    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_IssuerAndSerialNumber_issuer</xsl:with-param> </xsl:call-template>		<!--  --> 	
	<xsl:call-template name="API_Name"/>
    <xsl:text> </xsl:text>
    <xsl:for-each select="./serialNumber">  
	<xsl:call-template name="API_CertificateSerialNumber"/>
    </xsl:for-each>


</xsl:template>


<xsl:template match="SignatureAlgorithmIdentifier" name="API_SignatureAlgorithmIdentifier" mode="text">
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SignatureAlgorithmIdentifier_header</xsl:with-param> </xsl:call-template>
	<xsl:text> </xsl:text>
	<xsl:call-template name="API_AlgorithmIdentifier"/>
</xsl:template>

<xsl:template match="SignatureValue" name="API_SignatureValue" mode="text">
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SignatureValue_header</xsl:with-param> </xsl:call-template>
	<xsl:text> </xsl:text>
	<xsl:value-of select="."/>
</xsl:template>


<xsl:template match="DigestAlgorithmIdentifier" name="API_DigestAlgorithmIdentifier" mode="text">
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DigestAlgorithmIdentifier_header</xsl:with-param> </xsl:call-template>
	<xsl:text> </xsl:text>
	<xsl:call-template name="API_AlgorithmIdentifier"/>	
</xsl:template>


	<!--    -->	
<xsl:template match="_Accuracy" name="API_Accuracy" mode="text">

        <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Accuracy_header</xsl:with-param> </xsl:call-template>
	<xsl:text> </xsl:text>	
	<xsl:for-each select="./seconds">      
		<xsl:value-of select="."/>  
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Accuracy_seconds</xsl:with-param> </xsl:call-template>
	</xsl:for-each>  

	<xsl:for-each select="./millis">      
		<xsl:value-of select="."/>      
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Accuracy_millis</xsl:with-param> </xsl:call-template>
	</xsl:for-each>  

	<xsl:for-each select="./micros">      
		<xsl:value-of select="."/>      
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Accuracy_micros</xsl:with-param> </xsl:call-template>
	</xsl:for-each>  

</xsl:template>



	<!--    -->
<xsl:template match="SignatureAlgorithm" name="API_SignatureAlgorithm" mode="text">
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SignatureAlgorithm_header</xsl:with-param> </xsl:call-template>
    <xsl:text> </xsl:text>	
    <xsl:for-each select=".">  
	<xsl:call-template name="API_AlgorithmIdentifier"/>
    </xsl:for-each>
</xsl:template>


<!--   Integer-->	
<xsl:template match="INTVersion" name="API_INTVersion" mode="text">
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_INTVersion_header</xsl:with-param> </xsl:call-template>
    <xsl:text> </xsl:text>
    <xsl:value-of select="."/>
</xsl:template>




	<!--  CertStatus -->
<xsl:template match="CertStatus" name="API_CertStatus" mode="text">
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertStatus_header</xsl:with-param> </xsl:call-template> 

	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertStatus_good</xsl:with-param> </xsl:call-template> 

	<xsl:for-each select="./revoked">  
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertStatus_good</xsl:with-param> </xsl:call-template>
      	</xsl:for-each>

	<xsl:for-each select="./revoked">  
		<xsl:call-template name="API_RevokedInfo"/>
      	</xsl:for-each>

	<xsl:for-each select="./unknown">  
		<xsl:call-template name="UnknownInfo"/>
      	</xsl:for-each>
</xsl:template>

	<!--  RevokedInfo -->
<xsl:template match="RevokedInfo" name="API_RevokedInfo" mode="text">

 	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_RevokedInfo_header</xsl:with-param> </xsl:call-template> 
	<xsl:text> </xsl:text>
	<xsl:for-each select="./revocationTime">  
		<xsl:call-template name="GeneralizedTime"/>
      	</xsl:for-each>

      <xsl:for-each select="./revocationReason">  
	   <xsl:text> </xsl:text>
	   <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_RevokedInfo_revocationReason</xsl:with-param> </xsl:call-template>
	   <xsl:call-template name="CRLReason"/>
       </xsl:for-each>
</xsl:template>	




	<!--  KeyHash -->
<xsl:template match="KeyHash" name="API_KeyHash" mode="text">

	  <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_KeyHash_header</xsl:with-param> </xsl:call-template>
	  <xsl:text> </xsl:text>
	  <xsl:value-of select="."/>
</xsl:template>

	<!--  Digest -->
<xsl:template match="Digest" name="API_Digest" mode="text">

  <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Digest_header</xsl:with-param> </xsl:call-template>                                      <!--  -->
  <xsl:text> </xsl:text>
  <xsl:value-of select="."/>
</xsl:template>


	<!--  CertHash -->
<xsl:template match="CertHash" name="API_CertHash" mode="text">

	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertHash_header</xsl:with-param> </xsl:call-template>				
	    <xsl:text> </xsl:text>
	    <xsl:value-of select="."/>
</xsl:template>

	<!--  SMIMECapability -->
<xsl:template match="SMIMECapability" name="API_SMIMECapability" mode="text">

     <xsl:for-each select="./capabilityID">  
	<xsl:call-template name="printOID"/>
     </xsl:for-each>
    <xsl:text> </xsl:text>

    	<!--  -->
    <xsl:for-each select="./*">  
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SMIMECapability_parameters</xsl:with-param> </xsl:call-template>
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="."/>
    </xsl:for-each>

</xsl:template>


<xsl:template match="DigestAlgorithmIdentifiers" name="API_DigestAlgorithmIdentifiers" mode="text">
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DigestAlgorithmIdentifiers_header</xsl:with-param> </xsl:call-template>
    <xsl:text> 
    </xsl:text>
    <xsl:for-each select="./*">  
        <xsl:text> 
        </xsl:text>

	<xsl:call-template name="API_DigestAlgorithmIdentifier"/>	
    </xsl:for-each>
</xsl:template>

<xsl:template match="UnsignedAttributes" name="API_UnsignedAttributes" mode="text">
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_UnsignedAttributes_header</xsl:with-param> </xsl:call-template>
      <xsl:text> 
      </xsl:text>
      <xsl:for-each select="./*">  
        <xsl:text> 
        </xsl:text>
	<xsl:call-template name="API_Attribute"/>
      </xsl:for-each>
</xsl:template>

<xsl:template match="UnauthAttributes" name="API_UnauthAttributes" mode="text">
  <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_UnauthAttributes_header</xsl:with-param> </xsl:call-template>			
      <xsl:text> 
      </xsl:text>
    <xsl:for-each select="./*">  
        <xsl:text> 
        </xsl:text>
	<xsl:call-template name="API_Attribute"/>
    </xsl:for-each>

</xsl:template>


<xsl:template match="SignedAttributes" name="API_SignedAttributes" mode="text">
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SignedAttributes_header</xsl:with-param> </xsl:call-template>
        <xsl:text> 
        </xsl:text>
        <xsl:for-each select="./*">  
          <xsl:text> 
          </xsl:text>
	  <xsl:call-template name="API_Attribute"/>
        </xsl:for-each>
</xsl:template>




</xsl:stylesheet>
