// dllmain.cpp : Defines the entry point for the DLL application.
#include "stdafx.h"
#include "PHPCadesVersion.h"
#include "PHPCadesAbout.h"
#include "PHPCadesCPStore.h"
#include "PHPCadesCPCertificate.h"
#include "PHPCadesCPCertificates.h"
#include "PHPCadesCPKeyUsage.h"
#include "PHPCadesCPExtendedKeyUsage.h"
#include "PHPCadesCPEKU.h"
#include "PHPCadesCPEKUs.h"
#include "PHPCadesCPAlgorithm.h"
#include "PHPCadesCPPrivateKey.h"
#include "PHPCadesCPEncodedData.h"
#include "PHPCadesCPPublicKey.h"
#include "PHPCadesCPOID.h"
#include "PHPCadesCPAttribute.h"
#include "PHPCadesCPAttributes.h"
#include "PHPCadesCPBasicConstraints.h"
#include "PHPCadesCPCertificateStatus.h"
#include "PHPCadesCPEnvelopedData.h"
#include "PHPCadesCPSigner.h"
#include "PHPCadesCPSigners.h"
#include "PHPCadesCPRecipients.h"
#include "PHPCadesCPSignedData.h"
#include "PHPCadesCPHashedData.h"
#include "PHPCadesCPRawSignature.h"
#include "PHPCadesCPSignedXML.h"
#include "PHPCadesSymmetricAlgorithm.h"

PHP_MINIT_FUNCTION(php_cpcsp) {
    // le_hash_resource = zend_register_list_destructors_ex(php_hash_res_dtor,
    // php_hash_res_pdtor, PHP_HASH_RESOURCE_NAME, module_number);
    about_init(TSRMLS_C);
    version_init(TSRMLS_C);
    store_init(TSRMLS_C);
    certs_init(TSRMLS_C);
    cert_init(TSRMLS_C);
    ku_init(TSRMLS_C);
    exku_init(TSRMLS_C);
    eku_init(TSRMLS_C);
    algo_init(TSRMLS_C);
    private_key_init(TSRMLS_C);
    encoded_data_init(TSRMLS_C);
    public_key_init(TSRMLS_C);
    oid_init(TSRMLS_C);
    attr_init(TSRMLS_C);
    basic_constr_init(TSRMLS_C);
    certstat_init(TSRMLS_C);
    enveloped_data_init(TSRMLS_C);
    sig_init(TSRMLS_C);
    eku_col_init(TSRMLS_C);
    attr_col_init(TSRMLS_C);
    signers_init(TSRMLS_C);
    recipients_init(TSRMLS_C);
    sig_dat_init(TSRMLS_C);
    hash_dat_init(TSRMLS_C);
    raw_sig_init(TSRMLS_C);
    sig_xml_init(TSRMLS_C);
    symmetric_algorithm_init(TSRMLS_C);

    REGISTER_LONG_CONSTANT("MEMORY_STORE", 0, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("LOCAL_MACHINE_STORE", 1,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CURRENT_USER_STORE", 2,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("ACTIVE_DIRECTORY_USER_STORE", 3,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("SMART_CARD_USER_STORE", 4,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("STORE_OPEN_READ_ONLY", 0,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("STORE_OPEN_READ_WRITE", 1,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("STORE_OPEN_MAXIMUM_ALLOWED", 2,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("STORE_OPEN_EXISTING_ONLY", 128,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("STORE_OPEN_INCLUDE_ARCHIVED", 256,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("CERTIFICATE_FIND_SHA1_HASH", 0,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERTIFICATE_FIND_SUBJECT_NAME", 1,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERTIFICATE_FIND_ISSUER_NAME", 2,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERTIFICATE_FIND_ROOT_NAME", 3,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERTIFICATE_FIND_TEMPLATE_NAME", 4,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERTIFICATE_FIND_EXTENSION", 5,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERTIFICATE_FIND_EXTENDED_PROPERTY", 6,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERTIFICATE_FIND_APPLICATION_POLICY", 7,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERTIFICATE_FIND_CERTIFICATE_POLICY", 8,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERTIFICATE_FIND_TIME_VALID", 9,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERTIFICATE_FIND_TIME_NOT_YET_VALID", 10,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERTIFICATE_FIND_TIME_EXPIRED", 11,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERTIFICATE_FIND_KEY_USAGE", 12,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("CERT_INFO_SUBJECT_SIMPLE_NAME", 0,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERT_INFO_ISSUER_SIMPLE_NAME", 1,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERT_INFO_SUBJECT_EMAIL_NAME", 2,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERT_INFO_ISSUER_EMAIL_NAME", 3,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERT_INFO_SUBJECT_UPN", 4,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERT_INFO_ISSUER_UPN", 5,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERT_INFO_SUBJECT_DNS_NAME", 6,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERT_INFO_ISSUER_DNS_NAME", 7,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("DIGITAL_SIGNATURE_KEY_USAGE", 128,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("NON_REPUDIATION_KEY_USAGE", 64,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("KEY_ENCIPHERMENT_KEY_USAGE", 32,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("DATA_ENCIPHERMENT_KEY_USAGE", 16,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("KEY_AGREEMENT_KEY_USAGE", 8,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("KEY_CERT_SIGN_KEY_USAGE", 4,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OFFLINE_CRL_SIGN_KEY_USAGE", 2,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CRL_SIGN_KEY_USAGE", 2,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("ENCIPHER_ONLY_KEY_USAGE", 1,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("DECIPHER_ONLY_KEY_USAGE", 32768,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("ENCODE_BASE64", 0, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("ENCODE_BINARY", 1, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("ENCODE_ANY", 0xffffffff,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("CADESCOM_ENCRYPTION_ALGORITHM_RC2", 0,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CADESCOM_ENCRYPTION_ALGORITHM_RC4", 1,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CADESCOM_ENCRYPTION_ALGORITHM_DES", 2,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CADESCOM_ENCRYPTION_ALGORITHM_3DES", 3,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CADESCOM_ENCRYPTION_ALGORITHM_AES", 4,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CADESCOM_ENCRYPTION_ALGORITHM_GOST_28147_89", 25,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("ENCRYPTION_KEY_LENGTH_MAXIMUM", 0,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("ENCRYPTION_KEY_LENGTH_40_BITS", 1,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("ENCRYPTION_KEY_LENGTH_56_BITS", 2,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("ENCRYPTION_KEY_LENGTH_128_BITS", 3,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("ENCRYPTION_KEY_LENGTH_192_BITS", 4,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("ENCRYPTION_KEY_LENGTH_256_BITS", 5,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("EKU_OTHER", 0, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("EKU_SERVER_AUTH", 1, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("EKU_CLIENT_AUTH", 2, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("EKU_CODE_SIGNING", 3, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("EKU_EMAIL_PROTECTION", 4,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("EKU_SMARTCARD_LOGON", 5,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("EKU_ENCRYPTING_FILE_SYSTEM", 6,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("SEX_NOT_KNOWN", 0, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("SEX_MALE", 1, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("SEX_FEMALE", 2, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("SEX_NOT_APPLICABLE", 9,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("PROV_RSA_FULL", 1, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_RSA_SIG", 2, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_DSS", 3, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_FORTEZZA", 4, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_MS_EXCHANGE", 5, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_SSL", 6, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_RSA_SCHANNEL", 12,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_DSS_DH", 13, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_EC_ECDSA_SIG", 14,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_EC_ECNRA_SIG", 15,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_EC_ECDSA_FULL", 16,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_EC_ECNRA_FULL", 17,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_DH_SCHANNEL", 18, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_SPYRUS_LYNKS", 20,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_RNG", 21, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_INTEL_SEC", 22, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_REPLACE_OWF", 23, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PROV_RSA_AES", 24, CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("KEY_SPEC_KEYEXCHANGE", 1,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("KEY_SPEC_SIGNATURE", 2,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("OID_OTHER", 0, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_AUTHORITY_KEY_IDENTIFIER_EXTENSION", 1,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_KEY_ATTRIBUTES_EXTENSION", 2,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_CERT_POLICIES_95_EXTENSION", 3,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_KEY_USAGE_RESTRICTION_EXTENSION", 4,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_LEGACY_POLICY_MAPPINGS_EXTENSION", 5,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_SUBJECT_ALT_NAME_EXTENSION", 6,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_ISSUER_ALT_NAME_EXTENSION", 7,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_BASIC_CONSTRAINTS_EXTENSION", 8,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_SUBJECT_KEY_IDENTIFIER_EXTENSION", 9,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_KEY_USAGE_EXTENSION", 10,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_PRIVATEKEY_USAGE_PERIOD_EXTENSION", 11,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_SUBJECT_ALT_NAME2_EXTENSION", 12,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_ISSUER_ALT_NAME2_EXTENSION", 13,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_BASIC_CONSTRAINTS2_EXTENSION", 14,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_NAME_CONSTRAINTS_EXTENSION", 15,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_CRL_DIST_POINTS_EXTENSION", 16,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_CERT_POLICIES_EXTENSION", 17,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_POLICY_MAPPINGS_EXTENSION", 18,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_AUTHORITY_KEY_IDENTIFIER2_EXTENSION", 19,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_POLICY_CONSTRAINTS_EXTENSION", 20,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_ENHANCED_KEY_USAGE_EXTENSION", 21,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_CERTIFICATE_TEMPLATE_EXTENSION", 22,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_APPLICATION_CERT_POLICIES_EXTENSION", 23,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_APPLICATION_POLICY_MAPPINGS_EXTENSION", 24,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_APPLICATION_POLICY_CONSTRAINTS_EXTENSION", 25,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_AUTHORITY_INFO_ACCESS_EXTENSION    ", 26,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_SERVER_AUTH_eku", 100,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_CLIENT_AUTH_eku", 101,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_CODE_SIGNING_eku", 102,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_EMAIL_PROTECTION_eku", 103,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_IPSEC_END_SYSTEM_eku", 104,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_IPSEC_TUNNEL_eku", 105,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_IPSEC_USER_eku", 106,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_TIME_STAMPING_eku", 107,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_CTL_USAGE_SIGNING_eku", 108,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_TIME_STAMP_SIGNING_eku", 109,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_SERVER_GATED_CRYPTO_eku", 110,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_ENCRYPTING_FILE_SYSTEM_eku", 111,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_EFS_RECOVERY_eku", 112,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_WHQL_CRYPTO_eku", 113,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_NT5_CRYPTO_eku", 114,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_OEM_WHQL_CRYPTO_eku", 115,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_EMBEDED_NT_CRYPTO_eku", 116,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_ROOT_LIST_SIGNER_eku", 117,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_QUALIFIED_SUBORDINATION_eku", 118,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_KEY_RECOVERY_eku", 119,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_DIGITAL_RIGHTS_eku", 120,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_LICENSES_eku", 121,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_LICENSE_SERVER_eku", 122,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_SMART_CARD_LOGON_eku", 123,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_PKIX_POLICY_QUALIFIER_CPS", 124,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("OID_PKIX_POLICY_QUALIFIER_USERNOTICE", 125,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("AUTHENTICATED_ATTRIBUTE_SIGNING_TIME", 0,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("AUTHENTICATED_ATTRIBUTE_DOCUMENT_NAME", 1,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("AUTHENTICATED_ATTRIBUTE_DOCUMENT_DESCRIPTION", 2,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("ATTRIBUTE_OTHER", 0xffffffff,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("CHECK_NONE", 0, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CHECK_TRUSTED_ROOT", 1,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CHECK_TIME_VALIDITY", 2,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CHECK_SIGNATURE_VALIDITY", 4,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CHECK_ONLINE_REVOCATION_STATUS", 8,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CHECK_OFFLINE_REVOCATION_STATUS", 16,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CHECK_COMPLETE_CHAIN", 32,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CHECK_NAME_CONSTRAINTS", 64,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CHECK_BASIC_CONSTRAINTS", 128,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CHECK_NESTED_VALIDITY_PERIOD", 256,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CHECK_ONLINE_ALL", 495,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CHECK_OFFLINE_ALL", 503,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("STRING_TO_UCS2LE", 0, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("BASE64_TO_BINARY", 0x1,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("CERTIFICATE_INCLUDE_CHAIN_EXCEPT_ROOT", 0,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERTIFICATE_INCLUDE_WHOLE_CHAIN", 1,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CERTIFICATE_INCLUDE_END_ENTITY_ONLY", 2,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("CADES_DEFAULT", 0, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CADES_BES", 0x1, CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CADES_X_LONG_TYPE_1", 0x5d,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CADES_T", 0x5,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("PKCS7_TYPE", 0xffff,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("VERIFY_SIGNATURE_ONLY", 0,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("VERIFY_SIGNATURE_AND_CERTIFICATE", 1,
                           CONST_CS | CONST_PERSISTENT);

    REGISTER_LONG_CONSTANT("HASH_ALGORITHM_SHA1", 0,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("HASH_ALGORITHM_MD2", 1,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("HASH_ALGORITHM_MD4", 2,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("HASH_ALGORITHM_MD5", 3,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("HASH_ALGORITHM_SHA_256", 4,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("HASH_ALGORITHM_SHA_384", 5,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("HASH_ALGORITHM_SHA_512", 6,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("HASH_ALGORITHM_GOSTR_3411", 100,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CADESCOM_HASH_ALGORITHM_CP_GOST_3411", 100,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CADESCOM_HASH_ALGORITHM_CP_GOST_3411_2012_256", 101,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CADESCOM_HASH_ALGORITHM_CP_GOST_3411_2012_512", 102,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CADESCOM_HASH_ALGORITHM_CP_GOST_3411_HMAC", 110,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CADESCOM_HASH_ALGORITHM_CP_GOST_3411_2012_256_HMAC", 111,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("CADESCOM_HASH_ALGORITHM_CP_GOST_3411_2012_512_HMAC", 112,
                           CONST_CS | CONST_PERSISTENT);


    REGISTER_LONG_CONSTANT("XML_SIGNATURE_TYPE_ENVELOPED", 0,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("XML_SIGNATURE_TYPE_ENVELOPING", 0x1,
                           CONST_CS | CONST_PERSISTENT);
    REGISTER_LONG_CONSTANT("XML_SIGNATURE_TYPE_TEMPLATE", 0x2,
                           CONST_CS | CONST_PERSISTENT);

    return SUCCESS;
}

/*zend_function_entry hash_functions[] = {
    PHP_FE(CPCSP_hash, NULL)
    PHP_FE(CPCSP_hash_init, NULL)
    PHP_FE(CPCSP_hash_update, NULL)
    PHP_FE(CPCSP_hash_final, NULL)
    PHP_FE(CPCSP_hash_file, NULL)
    PHP_FE(CPCSP_hash_update_file, NULL)
    PHP_FE(CPCSP_hash_copy, NULL)
    PHP_FE(CPCSP_hash_algos, NULL)
    {NULL, NULL, NULL}
};*/

zend_module_entry php_cpcsp_module_entry = {
    STANDARD_MODULE_HEADER, // #if ZEND_MODULE_API_NO >",  20010901
    "php_CPCSP",            //  
    NULL, //   
    PHP_MINIT(php_cpcsp), // PHP_MINIT(test), Module Initialization
    NULL,                 // PHP_MSHUTDOWN(test), Module Shutdown
    NULL,                 // PHP_RINIT(test), Request Initialization
    NULL,                 // PHP_RSHUTDOWN(test), Request Shutdown
    NULL,                 // PHP_MINFO(test), Module Info ( phpinfo())
    "0.1",                //   
    STANDARD_MODULE_PROPERTIES};

ZEND_GET_MODULE(php_cpcsp)

int main() {}

BOOL APIENTRY
    DllMain(HMODULE hModule, DWORD ul_reason_for_call, LPVOID lpReserved) {
    /*switch (ul_reason_for_call)
    {
    case DLL_PROCESS_ATTACH:
    case DLL_THREAD_ATTACH:
    case DLL_THREAD_DETACH:
    case DLL_PROCESS_DETACH:
        break;
    }*/
    return TRUE;
}
