<?xml version="1.0" encoding="windows-1251"?>
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 		xmlns:fo="http://www.w3.org/1999/XSL/Format"
 		version='1.0'>



<xsl:template match="OCSPRequest" name="OCSPRequest">
<xsl:param name="Included"/>

<xsl:if test="$Included = 'false'">

    <!-- Header   -->

	<!--    -->
  <fo:static-content flow-name="xsl-region-before">
    <fo:block>
    </fo:block>

       <!--   -->
     <fo:block text-align="center" font-size="8pt">
    </fo:block>
  </fo:static-content>



      <!-- Footer -->

  <fo:static-content flow-name="xsl-region-after">
    <fo:block text-align="center" font-size="10pt" 	
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_paper</xsl:with-param> </xsl:call-template>			<!--  -->
      <fo:page-number/>
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_of</xsl:with-param> </xsl:call-template>
      <fo:page-number-citation ref-id="end of certificate"/>
    </fo:block>
  </fo:static-content>




          
	<!--   -->
  <fo:flow flow-name="xsl-region-body">

    <fo:block text-align="center"
	      font-family="Arial" font-size="14pt"
	      space-before="32pt"
	      space-after="16pt"
	      space-before.precedence="0"               
	      space-after.precedence="3"
	      keep-with-next="always"
	      >

	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_OCSPRequest</xsl:with-param> </xsl:call-template>
    </fo:block>

            <!--     -->	  
    <xsl:call-template name="uc_title"/>


         <!--     -->
    <fo:block font-family="Times" font-size="10pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_OCSPRequest_info</xsl:with-param> </xsl:call-template>              <!--  -->
    </fo:block>


	<!--   -->
     <xsl:for-each select="./tbsRequest">  
	<xsl:call-template name="TBSRequest"/>
    </xsl:for-each>

	<!--   -->
     <xsl:for-each select="./optionalSignature">  
	<xsl:call-template name="OCSPSignature"/>
    </xsl:for-each>


	<!-- Footer  -->

    <fo:block id="end of certificate">
    </fo:block>
  </fo:flow>

</xsl:if>


<xsl:if test="$Included != 'false'">

         <!--     -->
    <fo:block font-family="Times" font-size="10pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_OCSPRequest_info</xsl:with-param> </xsl:call-template>              <!--  -->
    </fo:block>


	<!--   -->
     <xsl:for-each select="./tbsRequest">  
	<xsl:call-template name="TBSRequest"/>
    </xsl:for-each>

	<!--   -->
     <xsl:for-each select="./optionalSignature">  
	<xsl:call-template name="OCSPSignature"/>
    </xsl:for-each>


</xsl:if>

</xsl:template>

	<!-- ******************************************** -->

	<!--  TBSRequest -->
<xsl:template match="TBSRequest" name="TBSRequest">

    <!--   -->	
     <xsl:for-each select="./version">  
	<xsl:call-template name="Version"/>
    </xsl:for-each>

    <!--     -->	
    <xsl:for-each select="./requestorName">  
    <fo:block font-family="Times" font-size="14pt"                                
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSRequest_requestorName</xsl:with-param> </xsl:call-template>
     </fo:block>

     <fo:block>
	    <xsl:call-template name="GeneralName"/>
     </fo:block>
    </xsl:for-each>


    <fo:block font-family="Times" font-size="14pt"                                
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSRequest_requestList</xsl:with-param> </xsl:call-template>
     </fo:block>


    <!--   -->	
    <fo:block>
      <xsl:for-each select="./requestList/*">  
        <xsl:call-template name="Request"/>
      </xsl:for-each>
    </fo:block>



	<!--   -->
     <xsl:for-each select="./requestExtensions">
	  <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSRequest_extensions</xsl:with-param> </xsl:call-template>				
	  </fo:block>

		<!--   -->
	  <fo:block font-family="Times" font-size="10pt"
	    margin-left="1.5em"
	    >
	    <xsl:call-template name="Extensions"/>
          </fo:block>
    </xsl:for-each>


</xsl:template>

	<!-- ******************************************** -->

	<!--   Request -->
<xsl:template match="Request" name="Request">

	<!--     -->
     <fo:block font-family="Times" font-size="12pt"                        
	    space-before="18pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    text-align="center"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Request_reqCert</xsl:with-param> </xsl:call-template>				
     </fo:block>

      <xsl:for-each select="./reqCert">  
	<xsl:call-template name="ReqCert"/>
      </xsl:for-each>

      <xsl:for-each select="./singleRequestExtensions">  
	  <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Request_singleRequestExtensions</xsl:with-param> </xsl:call-template>				
	  </fo:block>

	<xsl:call-template name="Extensions"/>
      </xsl:for-each>

</xsl:template>

	<!-- ******************************************** -->

<xsl:template match="ReqCert" name="ReqCert">
     <xsl:for-each select="./certID">  
	<xsl:call-template name="CertID"/>
     </xsl:for-each>

     <xsl:for-each select="./fullCert">  
	<xsl:call-template name="FullCertificate"/>
     </xsl:for-each>

     <xsl:for-each select="./certIdWithSignature">  
	<xsl:call-template name="CertIdWithSignature"/>
     </xsl:for-each>

</xsl:template>

	<!--    CertID -->
<xsl:template match="CertID" name="CertID">
        <!--    -->

	<!--    -->
	<fo:block font-family="Times" font-size="10pt"                                
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	  <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertID_header</xsl:with-param> </xsl:call-template>					<!--  -->
	</fo:block>


	<!--    -->
	<fo:block font-family="Times" font-size="10pt"                                
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

		<!-- -->
	  <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertID_hashAlgorithm</xsl:with-param> </xsl:call-template>					<!--  -->
	</fo:block>

	<fo:block>
        <xsl:for-each select="./hashAlgorithm">  
  	      <xsl:call-template name="AlgorithmIdentifier"/>
        </xsl:for-each>
        </fo:block>

	<!--    -->

	<fo:block font-family="Times" font-size="10pt"
	      space-before="6pt"
	      space-after="3pt"                         
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
	   <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertID_issuerNameHash</xsl:with-param> </xsl:call-template>
	</fo:block>

	  <fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"
	    padding="3pt"
	    >
    	    <xsl:value-of select="issuerNameHash"/>                                      <!--  -->

        </fo:block>

	<!--    -->

	<fo:block font-family="Times" font-size="10pt"
	      space-before="6pt"
	      space-after="3pt"                         
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
	   <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertID_issuerKeyHash</xsl:with-param> </xsl:call-template>
	</fo:block>

	  <fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"
	    padding="3pt"
	    >
    	    <xsl:value-of select="issuerKeyHash"/>                                      <!--  -->
        </fo:block>

        <xsl:for-each select="./serialNumber">  
  	      <xsl:call-template name="CertificateSerialNumber"/>
        </xsl:for-each>


</xsl:template>

	<!--  FullCertificate -->
<xsl:template match="FullCertificate" name="FullCertificate">

	<!--    -->
	<fo:block font-family="Times" font-size="10pt"                                
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	  <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_FullCertificate_header</xsl:with-param> </xsl:call-template>					<!--  -->
	</fo:block>

    <xsl:for-each select="./certificate">  
	<xsl:call-template name="Certificate"/>
    </xsl:for-each>

    <xsl:for-each select="./attributeCert">  
	<xsl:call-template name="AttributeCertificate"/>
    </xsl:for-each>

</xsl:template>

	<!--  CertIdWithSignature -->
<xsl:template match="CertIdWithSignature" name="CertIdWithSignature">
	<!--     -->
	<fo:block font-family="Times" font-size="10pt"                                
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	  <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertIdWithSignature_header</xsl:with-param> </xsl:call-template>					<!--  -->
	</fo:block>


    <xsl:for-each select="./issuerandSerialNumber">  
	<xsl:call-template name="IssuerAndSerialNumber"/>
    </xsl:for-each>


	<!--    -->
	<fo:block font-family="Times" font-size="10pt"                                
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	  <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertIdWithSignature_tbsCertificateHash</xsl:with-param> </xsl:call-template>					<!--  -->
	</fo:block>

	
    <fo:block font-family="Courier New" font-size="10pt"                              
	    border-style="solid"
	    padding="3pt"
	    >
      <xsl:call-template name="split">
        <xsl:with-param name="val">
  	  <xsl:value-of select="./tbsCertificateHash"/>
        </xsl:with-param>
      </xsl:call-template>							<!--   -->
    </fo:block>


    <xsl:for-each select="./certsignature">  
	<xsl:call-template name="CertSignature"/>
    </xsl:for-each>

</xsl:template>


	<!--  CertSignature -->
<xsl:template match="CertSignature" name="CertSignature">

   <fo:block font-family="Times" font-size="10pt"
	      space-before="6pt"
	      space-after="3pt"                         
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertSignature_header</xsl:with-param> </xsl:call-template>
   </fo:block>
   <fo:block>
    <xsl:for-each select="./signatureAlgorithm">  
	<xsl:call-template name="SignatureAlgorithmIdentifier"/>
    </xsl:for-each>

    <xsl:for-each select="./signatureValue">  
	<xsl:call-template name="SignatureValue"/>
    </xsl:for-each>
   </fo:block>
</xsl:template>

	<!--   OCSPSignature -->
<xsl:template match="OCSPSignature" name="OCSPSignature">

    <fo:block font-family="Courier New" font-size="14pt"
	    space-before="32pt"			
	    space-after="16pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    text-align="center"
            keep-with-next="always"
	    >
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_OCSPSignature_header</xsl:with-param> </xsl:call-template>

    </fo:block>	


     <xsl:for-each select="./signatureAlgorithm">  
	<xsl:call-template name="SignatureAlgorithm"/>
    </xsl:for-each>

	<!--   -->
     <xsl:for-each select="./signature">  
	<xsl:call-template name="Signature"/>
    </xsl:for-each>

	<!--    -->
     <xsl:for-each select="./certs">  
	<xsl:call-template name="Certificates"/>
    </xsl:for-each>


</xsl:template>

<xsl:template match="Certificates" name="Certificates">
	<!--    -->

    <fo:block font-family="Times" font-size="14pt"                                
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Certificates_header</xsl:with-param> </xsl:call-template>
     </fo:block>

     <fo:block>
        <xsl:for-each select="./*">  
	   <xsl:call-template name="Certificate"/>
        </xsl:for-each>
     </fo:block>
</xsl:template>


<xsl:template match="ExtendedCertificate" name="ExtendedCertificate">

    <!--    -->
    <fo:block font-family="Times" font-size="14pt"                                
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

	<!-- :-->
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ExtendedCertificate_header</xsl:with-param> </xsl:call-template>
    </fo:block>

    <xsl:for-each select="./extendedCertificateInfo">  
	<xsl:call-template name="ExtendedCertificateInfo"/>
    </xsl:for-each>


    <xsl:for-each select="./signatureAlgorithm">  
	<xsl:call-template name="SignatureAlgorithmIdentifier"/>
    </xsl:for-each>

    <xsl:for-each select="./signature">  
	<xsl:call-template name="Signature"/>
    </xsl:for-each>

</xsl:template>

<xsl:template match="ExtendedCertificateInfo" name="ExtendedCertificateInfo">
    <!--   -->	
     <xsl:for-each select="./version">  
	<xsl:call-template name="Version"/>
    </xsl:for-each>

     <xsl:for-each select="./certificate">  
	<xsl:call-template name="Certificate"/>
    </xsl:for-each>

     <xsl:for-each select="./attributes">  
	<xsl:call-template name="UnauthAttributes"/>
    </xsl:for-each>

</xsl:template>

	<!--  AttributeCertificate !!!!!!!!!!-->
<xsl:template match="AttributeCertificate" name="AttributeCertificate">
	<xsl:text>Under Construction</xsl:text>
</xsl:template>

	<!--  AttributeCertificateInfo   !!!!!!!!!! -->
<xsl:template match="AttributeCertificateInfo" name="AttributeCertificateInfo">

    <!--   -->	
     <xsl:for-each select="./version">  
	<xsl:call-template name="Version"/>
    </xsl:for-each>

	<!--    -->
     <xsl:for-each select="./subject">  
	<xsl:text>under construction</xsl:text>
    </xsl:for-each>

    <!--    -->	
     <xsl:for-each select="./serialNumber">  
	<xsl:call-template name="CertificateSerialNumber"/>
    </xsl:for-each>

	<!--     -->
     <xsl:for-each select="./attCertValidityPeriod">  
	<xsl:text>under construction</xsl:text>
    </xsl:for-each>

	<!--    -->
     <xsl:for-each select="./attributes/*">  
	<xsl:call-template name="Attribute"/>
    </xsl:for-each>



	<!--   -->
	<!--   : -->
  <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_AttributeCertificateInfo_extensions</xsl:with-param> </xsl:call-template>				<!--  -->
  </fo:block>

	<!--   -->
  <fo:block font-family="Times" font-size="10pt"
	    margin-left="1.5em"
	    >

     <xsl:for-each select="./extensions">  
	<xsl:call-template name="Extensions"/>
    </xsl:for-each>

  </fo:block>


</xsl:template>


</xsl:stylesheet>