#pragma warning(disable:4996)

#include <iterator>
#include <vector>
#include <iostream>
#include <wchar.h>
#include <cstdlib>

#ifdef _WIN32
#include <tchar.h>
#else
#include <cstdio>
#include "reader/tchar.h"
#endif

#include "cades.h"

/*
    ,   
 CADES_X_LONG_TYPE_1.        
   countersign.dat ( Countersign). countersign.dat     .
*/

using namespace std;

#include "../samples_util.h"

int main(void)
{
    vector<unsigned char> message;
    //    
    if (ReadFileToVector("countersign.dat", message))
    {
	cout << "Reading signature from file \"countersign.dat\" failed" << endl;
	return -1;
    }

    if (message.empty())
    {
	cout << "File \"countersign.dat\" is empty" << endl;
	return -1;
    }

    //     
    HCRYPTMSG hMsg = CryptMsgOpenToDecode(X509_ASN_ENCODING | PKCS_7_ASN_ENCODING, 0, 0, 0, 0, 0);

    if (!hMsg)
    {
	cout << "CryptMsgOpenToDecode() failed" << endl;
	return -1;
    }

    //     
    if (!CryptMsgUpdate(hMsg, &message[0], (unsigned long)message.size(), 1))
    {
	CryptMsgClose(hMsg);
	cout << "CryptMsgUpdate() failed" << endl;
	return -1;
    }

    //   .    
    //   .
    DWORD size = 0;
    if (!CryptMsgGetParam(hMsg, CMSG_SIGNER_UNAUTH_ATTR_PARAM, 0, 0, &size))
    {
	CryptMsgClose(hMsg);
	cout << "CryptMsgGetParam() failed" << endl;
	return -1;
    }
    vector<unsigned char> paramBlob(size);
    if (!CryptMsgGetParam(hMsg, CMSG_SIGNER_UNAUTH_ATTR_PARAM, 0, &paramBlob[0], &size))
    {
	CryptMsgClose(hMsg);
	cout << "CryptMsgGetParam() failed" << endl;
	return -1;
    }
    paramBlob.resize(size);
    PCRYPT_ATTRIBUTES pAttrs = reinterpret_cast<PCRYPT_ATTRIBUTES>(&paramBlob[0]);

    //    .
    if (!CryptMsgClose(hMsg))
    {
	cout << "CryptMsgClose() failed" << endl;
	return -1;
    }

    //       .  
    //     ,    
    //   .
    CRYPT_DATA_BLOB countersignatureBlob = { 0, 0 };
    for (unsigned long i = 0; i < pAttrs->cAttr; ++i)
    {
	PCRYPT_ATTRIBUTE pAttr = &pAttrs->rgAttr[i];
	if (!strcmp(szOID_RSA_counterSign, pAttr->pszObjId))
	{
	    if (!pAttr->cValue)
		continue;
	    countersignatureBlob.pbData = pAttr->rgValue[0].pbData;
	    countersignatureBlob.cbData = pAttr->rgValue[0].cbData;
	    break;
	}
    }

    if (!countersignatureBlob.cbData)
    {
	cout << "Countersignature not found" << endl;
	return -1;
    }

    //      CMSG_SIGNER_INFO,
    //       CryptDecodeObject().
    size = 0;
    if (!CryptDecodeObject(X509_ASN_ENCODING | PKCS_7_ASN_ENCODING, PKCS7_SIGNER_INFO, countersignatureBlob.pbData, countersignatureBlob.cbData, 0, 0, &size))
    {
	cout << "CryptDecodeObject() failed" << endl;
	return -1;
    }

    vector<unsigned char> decodeBlob(size);
    if (!CryptDecodeObject(X509_ASN_ENCODING | PKCS_7_ASN_ENCODING, PKCS7_SIGNER_INFO, countersignatureBlob.pbData, countersignatureBlob.cbData, 0, &decodeBlob[0], &size))
    {
	cout << "CryptDecodeObject() failed" << endl;
	return -1;
    }

    PCMSG_SIGNER_INFO pSignerInfo = reinterpret_cast<PCMSG_SIGNER_INFO>(&decodeBlob[0]);

    //    
    ALG_ID hashAlgId = CadesMsgGetSigningCertIdHashAlgEx(pSignerInfo);
    if (!hashAlgId)
    {
	cout << "CadesMsgGetSigningCertIdHashAlg() failed" << endl;
	return -1;
    }

    PCADES_BLOB_ARRAY pTimestamps = 0;
    //     ,   .
    if (!CadesMsgGetSignatureTimestampsEx(pSignerInfo, &pTimestamps))
    {
	cout << "CadesGetSignatureTimestamps() failed" << endl;
	return -1;
    }

    //  
    if (!CadesFreeBlobArray(pTimestamps))
    {
	cout << "CadesFreeBlobArray() failed" << endl;
	return -1;
    }

    PCADES_BLOB_ARRAY pCerts = 0;
    //     ,   
    if (!CadesMsgGetCertificateValuesEx(pSignerInfo, &pCerts))
    {
	cout << "CadesGetCertificateValues() failed" << endl;
	return -1;
    }

    //  
    if (!CadesFreeBlobArray(pCerts))
    {
	cout << "CadesFreeBlobArray() failed" << endl;
	return -1;
    }

    PCADES_BLOB_ARRAY pCRLs = 0;
    PCADES_BLOB_ARRAY pOCSPs = 0;
    //         (        OCSP)   .
    if (!CadesMsgGetRevocationValuesEx(pSignerInfo, &pCRLs, &pOCSPs))
    {
	cout << "CadesGetRevocationValues() failed" << endl;
	return -1;
    }

    PCADES_BLOB_ARRAY pCadesCTimestamps = 0;
    //             
    if (!CadesMsgGetCadesCTimestampsEx(pSignerInfo, &pCadesCTimestamps))
    {
	cout << "CadesMsgGetCadesCTimestamps() failed" << endl;
	return -1;
    }

    //  
    if (!CadesFreeBlobArray(pCadesCTimestamps))
    {
	cout << "CadesFreeBlobArray() failed" << endl;
	return -1;
    }

    //  
    if (!CadesFreeBlobArray(pCRLs))
    {
	CadesFreeBlobArray(pOCSPs);
	cout << "CadesFreeBlobArray() failed" << endl;
	return -1;
    }

    //  
    if (!CadesFreeBlobArray(pOCSPs))
    {
	cout << "CadesFreeBlobArray() failed" << endl;
	return -1;
    }

    cout << "All CAdES countersignature attributes obtained successfully." << endl;

}
