#ifndef CPP_ENROLL_ENROLLMENT_OBJECT_H_
#define CPP_ENROLL_ENROLLMENT_OBJECT_H_

#include "cppcades.h"
#include "CPPEnrollEnumerations.h"
#include "CPPEnrollX509CertificateRequest.h"

using namespace ATL;
namespace CryptoPro {
namespace PKI {
namespace Enroll {

class CPPEnrollX509Enrollment
{
public:
    CPPEnrollX509Enrollment(void);
    ~CPPEnrollX509Enrollment(void);
    HRESULT CreateRequest(EncodingType Encoding, CStringBlob& encRequest);
    HRESULT Initialize(X509CertificateEnrollmentContext Context);
    HRESULT InitializeFromRequest(boost::shared_ptr<CPPEnrollX509CertificateRequestPkcs10>& pRequest);
    HRESULT InstallResponse(CADESCOM_InstallResponseRestrictionFlags Restrictions, CStringBlob& strResponse,
        EncodingType Encoding, CAtlStringA& strPassword);
    HRESULT get_CertificateFriendlyName(CAtlStringW& strName);
    HRESULT put_CertificateFriendlyName(const CAtlStringW& strName);
    HRESULT get_CertificateDescription(CAtlStringW& strDescription);
    HRESULT put_CertificateDescription(const CAtlStringW& strDescription);

    HRESULT get_Silent(BOOL &pVal);
    HRESULT put_Silent(BOOL bVal);
    HRESULT get_ForceReaderDialog(BOOL &pVal);
    HRESULT put_ForceReaderDialog(BOOL bVal);

    // internal
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509Enrollment);
    bool m_bContextInitialized;
    bool m_bRequestCreated;
    bool m_bSilent;
    bool m_bForceReaderDialog;
    //     CPPEnrollX509CertificateRequestPkcs10,
    //     CPPEnrollX509CertificateRequestPkcs,   
    //  ,        
    //  .
    boost::shared_ptr<CPPEnrollX509CertificateRequestPkcs10> m_pCertificateRequest;
    X509CertificateEnrollmentContext m_context;
    CAtlStringW m_strFriendlyName;
    CAtlStringW m_strDescription;

};

} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_ENROLLMENT_OBJECT_H_
