#ifndef CPP_ENROLL_CERTIFICATE_POLICY_OBJECT_H_
#define CPP_ENROLL_CERTIFICATE_POLICY_OBJECT_H_

#include "cppcades.h"
#include "CPPEnrollEnumerations.h"
#include "CPPEnrollObjectId.h"
#include "CPPEnrollCollections.h"
#include <atlcrypt2.h>

using namespace ATL;
namespace CryptoPro {
namespace PKI {
namespace Enroll {

class CPPEnrollPolicyQualifiers;

class CPPEnrollCertificatePolicy
{
public:
    CPPEnrollCertificatePolicy(void);
    ~CPPEnrollCertificatePolicy(void);
    HRESULT Initialize(boost::shared_ptr<CPPEnrollObjectId>& pObjectId);

    HRESULT get_ObjectId(boost::shared_ptr<CPPEnrollObjectId>& pObjectId);
    HRESULT get_PolicyQualifiers(boost::shared_ptr<CPPEnrollPolicyQualifiers>& pPolicyQualifiers);

    // internal use
    //LPCSTR get_pszOID();

private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollCertificatePolicy);
    boost::shared_ptr<CPPEnrollPolicyQualifiers> m_pPolicyQualifiers;
    boost::shared_ptr<CPPEnrollObjectId> m_pOid;
    CAtlStringA m_oid;
};

} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_CERTIFICATE_POLICY_OBJECT_H_
