#ifndef CPPCADES_CP_KEYUSAGE_OBJECT_H_
#define CPPCADES_CP_KEYUSAGE_OBJECT_H_

#include "cppcades.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPKeyUsageObject
{
public:
    CPPCadesCPKeyUsageObject(void);
    ~CPPCadesCPKeyUsageObject(void);

    HRESULT get_IsPresent(BOOL *pVal);
    HRESULT get_IsCritical(BOOL *pVal);
    HRESULT get_IsDigitalSignatureEnabled(BOOL *pVal);
    HRESULT get_IsNonRepudiationEnabled(BOOL *pVal);
    HRESULT get_IsKeyEnciphermentEnabled(BOOL *pVal);
    HRESULT get_IsDataEnciphermentEnabled(BOOL *pVal);
    HRESULT get_IsKeyAgreementEnabled(BOOL *pVal);
    HRESULT get_IsKeyCertSignEnabled(BOOL *pVal);
    HRESULT get_IsCRLSignEnabled(BOOL *pVal);
    HRESULT get_IsEncipherOnlyEnabled(BOOL *pVal);
    HRESULT get_IsDecipherOnlyEnabled(BOOL *pVal);

    //internal use
    HRESULT put_IsCritical(BOOL pVal);
    HRESULT put_IsPresent(BOOL pVal);
    void SetKeyUsageBits(PCRYPT_BIT_BLOB pKeyUsageBitBlob);
    void clear();

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPKeyUsageObject);

    BYTE m_keyUsageBits[2];
    BOOL m_isPresent;
    BOOL m_isCritical;
};
} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_KEYUSAGE_OBJECT_H_

