#ifndef CPPCADES_CP_CRL_OBJECT_H_
#define CPPCADES_CP_CRL_OBJECT_H_

#include "cppcades.h"
#include "asn1/Extension.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPCRLObject;

class CPPCadesCPCRLObject
{
public:
    CPPCadesCPCRLObject();
    ~CPPCadesCPCRLObject();

    HRESULT Import(CryptoPro::CBlob& value);
    HRESULT Export(CAPICOM_ENCODING_TYPE findType, CryptoPro::CBlob& value);

    HRESULT get_IssuerName(CAtlString& value);
    HRESULT get_ThisUpdate(CryptoPro::CDateTime& value);
    HRESULT get_NextUpdate(CryptoPro::CDateTime& value);
    HRESULT get_Thumbprint(CAtlString& value);
    HRESULT get_AuthKeyID(CAtlString& value);

    PCCRL_CONTEXT GetHandle();
    HRESULT Clear();
    void CheckValidState();

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPCRLObject);

    CCRLContext m_crl;
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_CRL_OBJECT_H_
